/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.tasks;

import java.awt.Color;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.Composite;
import pyrosim.legacy_2012_1.domain.GeomUtil;
import pyrosim.legacy_2012_1.domain.Hierarchy;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.boundcond.surf.PredefSurf;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Surface;
import pyrosim.legacy_2012_1.domain.geom.FDSObject;
import pyrosim.legacy_2012_1.domain.geom.GenericGeomSrc;
import pyrosim.legacy_2012_1.domain.geom.Hole;
import pyrosim.legacy_2012_1.domain.geom.IHole;
import pyrosim.legacy_2012_1.domain.geom.IModelObj;
import pyrosim.legacy_2012_1.domain.geom.IObstruction;
import pyrosim.legacy_2012_1.domain.geom.ModelComposite;
import pyrosim.legacy_2012_1.domain.geom.Obstruction;
import pyrosim.legacy_2012_1.domain.tasks.InsertTask;
import pyrosim.legacy_2012_1.domain.tasks.SelectTask;
import pyrosim.legacy_2012_1.domain.tasks.Tasks;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.GeomGroup;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPropsSrc;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.PropsBuilder;
import pyrosim.legacy_2012_1.thunderheadeng.util.CompositeTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.FilteredCollection;
import pyrosim.legacy_2012_1.thunderheadeng.util.Pair;
import pyrosim.legacy_2012_1.util.Util;

public class GroupGeomTask
extends CompositeTask<PyroMod> {
    public GroupGeomTask(PyroMod pyroMod, Collection<? extends IModelObj> collection, ConvertType convertType) {
        super(pyroMod);
        IModelObj iModelObj = convertType == ConvertType.GENERIC ? this.merge(Util.filter(collection, GenericGeomSrc.class)) : this.merge(Util.filter(collection, FDSObject.class), convertType);
        Pair<ModelComposite, Integer> pair = GroupGeomTask.getInsertInfo(collection);
        SelectTask selectTask = new SelectTask(pyroMod, iModelObj);
        selectTask.addTask(Tasks.delete(collection));
        selectTask.addTask(new InsertTask((Composite)pair.v1, ((Integer)pair.v2).intValue(), new IPyroObject[]{iModelObj}));
        this.addTask(selectTask);
    }

    /*
     * WARNING - void declaration
     */
    private static Pair<ModelComposite, Integer> getInsertInfo(Collection<? extends IModelObj> collection) {
        IPyroObject iPyroObject = Hierarchy.getCommonParent(collection);
        assert (iPyroObject instanceof ModelComposite);
        ModelComposite modelComposite = (ModelComposite)iPyroObject;
        IdentityHashMap<IPyroObject, Integer> identityHashMap = new IdentityHashMap<IPyroObject, Integer>();
        int n = 0;
        for (IPyroObject object : modelComposite.getMembers()) {
            identityHashMap.put(object, n++);
        }
        int n2 = modelComposite.getMembers().size();
        for (IPyroObject iPyroObject2 : collection) {
            void var7_9;
            IPyroObject iPyroObject3 = iPyroObject2.getParent();
            while (iPyroObject3 != null && iPyroObject3 != modelComposite) {
                IPyroObject iPyroObject4 = iPyroObject3;
                iPyroObject3 = iPyroObject4.getParent();
            }
            assert (iPyroObject3 == modelComposite);
            assert (identityHashMap.containsKey(var7_9));
            int n3 = (Integer)identityHashMap.get(var7_9);
            if (n3 >= n2) continue;
            n2 = n3;
        }
        return new Pair<ModelComposite, Integer>(modelComposite, n2);
    }

    private PyroMod getDomain() {
        return (PyroMod)this.getDomains().iterator().next();
    }

    private GenericGeomSrc merge(Collection<? extends GenericGeomSrc> collection) {
        PropsBuilder propsBuilder = new PropsBuilder();
        ArrayList<IGeom> arrayList = new ArrayList<IGeom>();
        for (GenericGeomSrc genericGeomSrc : collection) {
            IGeom iGeom = genericGeomSrc.getGeom();
            IPropsSrc iPropsSrc = genericGeomSrc.getDisplayProps();
            propsBuilder.add(iPropsSrc, iGeom.getNumPrims(7), true);
            arrayList.add(iGeom);
        }
        return new GenericGeomSrc(collection.iterator().next().getName(), pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.GeomUtil.group(arrayList), collection.iterator().next().getTexCoordGen(), propsBuilder.finalizeProps());
    }

    /*
     * WARNING - void declaration
     */
    private FDSObject merge(Collection<? extends FDSObject> collection, ConvertType convertType) {
        void var8_11;
        Object object;
        Surface surface = (Surface)this.getDomain().getSurfaceMgr().get(PredefSurf.INERT.name());
        ArrayList<Surface> arrayList = new ArrayList<Surface>(collection.size());
        ArrayList<Color> arrayList2 = new ArrayList<Color>(collection.size());
        ArrayList<IGeom> arrayList3 = new ArrayList<IGeom>(collection.size());
        for (FDSObject surfaceArray2 : collection) {
            Surface[] surfaceArray;
            object = GroupGeomTask.flatten(Color.class, surfaceArray2.getColors(), surfaceArray2.getGeom().getNumPrims(7));
            if (surfaceArray2 instanceof IObstruction) {
                surfaceArray = GroupGeomTask.flatten(Surface.class, ((IObstruction)surfaceArray2).getSurfaces(), surfaceArray2.getGeom().getNumPrims(1));
            } else {
                surfaceArray = new Surface[surfaceArray2.getGeom().getNumPrims(1)];
                for (int i = 0; i < surfaceArray.length; ++i) {
                    surfaceArray[i] = surface;
                }
            }
            arrayList.addAll(Arrays.asList(surfaceArray));
            arrayList2.addAll(Arrays.asList(object));
            arrayList3.add(surfaceArray2.getGeom());
        }
        Color[] colorArray = arrayList2.toArray(new Color[arrayList2.size()]);
        Surface[] surfaceArray = arrayList.toArray(new Surface[arrayList.size()]);
        if (GeomUtil.isUniform(colorArray)) {
            colorArray = new Color[]{colorArray[0]};
        }
        if (GeomUtil.isUniform(surfaceArray)) {
            Surface[] surfaceArray2 = new Surface[]{surfaceArray[0]};
        }
        object = new GeomGroup(arrayList3);
        return convertType == ConvertType.OBSTRUCTION ? GroupGeomTask.convertToObst(collection, (IGeom)object, colorArray, (Surface[])var8_11) : GroupGeomTask.convertToHole(collection, (IGeom)object, colorArray);
    }

    private static IObstruction convertToObst(Collection<? extends FDSObject> collection, IGeom iGeom, Color[] colorArray, Surface[] surfaceArray) {
        IObstruction iObstruction;
        FilteredCollection<IObstruction> filteredCollection = new FilteredCollection<IObstruction>(collection, IObstruction.class);
        if (!filteredCollection.isEmpty()) {
            IObstruction iObstruction2 = (IObstruction)filteredCollection.iterator().next();
            iObstruction = (IObstruction)iObstruction2.clone();
            iObstruction.setGeom(iGeom, true);
            iObstruction.setSurfaces(surfaceArray);
        } else {
            iObstruction = new Obstruction(Intl.intl("Obstruction"), iGeom, surfaceArray);
        }
        iObstruction.setColors(colorArray);
        return iObstruction;
    }

    private static IHole convertToHole(Collection<? extends FDSObject> collection, IGeom iGeom, Color[] colorArray) {
        IHole iHole;
        FilteredCollection<IHole> filteredCollection = new FilteredCollection<IHole>(collection, IHole.class);
        if (!filteredCollection.isEmpty()) {
            IHole iHole2 = (IHole)filteredCollection.iterator().next();
            iHole = (IHole)iHole2.clone();
            iHole.setGeom(iGeom, true);
        } else {
            iHole = new Hole(Intl.intl("Hole"), iGeom);
        }
        iHole.setColors(colorArray);
        return iHole;
    }

    private static <T> T[] flatten(Class<T> clazz, T[] TArray, int n) {
        if (TArray.length == 1 && n != 1) {
            Object[] objectArray = (Object[])Array.newInstance(clazz, n);
            for (int i = 0; i < n; ++i) {
                objectArray[i] = TArray[0];
            }
            return objectArray;
        }
        assert (TArray.length == n);
        return TArray;
    }

    public static enum ConvertType {
        HOLE,
        OBSTRUCTION,
        GENERIC;

    }
}

