/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.tasks;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.Composite;
import pyrosim.legacy_2012_1.domain.Grid;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.geom.AFDSObject;
import pyrosim.legacy_2012_1.domain.geom.ModelComposite;
import pyrosim.legacy_2012_1.domain.geom.PartCloud;
import pyrosim.legacy_2012_1.domain.particle.Particle;
import pyrosim.legacy_2012_1.domain.tasks.AddTask;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AABoxGeom;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.CompositeTask;
import pyrosim.legacy_2012_1.unitsystem.SIUS;

public class FillGridsWithPartsTask
extends CompositeTask<PyroMod> {
    private final ModelComposite d_root;
    private final String d_baseID;
    private final Collection<? extends Grid> d_grids;
    private final Particle d_particle;
    private final PartCloud.IDropletCount d_initDropCount;
    private final PartCloud.IInsertion d_insertion;
    private final boolean d_isStatic;
    private List<IPyroObject> d_addedObjects;
    private final boolean d_distributeQuantities;

    public FillGridsWithPartsTask(PyroMod pyroMod, ModelComposite modelComposite, String string, Collection<? extends Grid> collection, Particle particle, PartCloud.IDropletCount iDropletCount, PartCloud.IInsertion iInsertion, boolean bl, boolean bl2) {
        super(pyroMod);
        this.d_root = modelComposite;
        this.d_baseID = string;
        this.d_grids = collection;
        this.d_particle = particle;
        this.d_initDropCount = iDropletCount;
        this.d_insertion = iInsertion;
        this.d_isStatic = bl;
        this.d_addedObjects = new ArrayList<IPyroObject>();
        this.d_distributeQuantities = bl2;
    }

    public FillGridsWithPartsTask(PyroMod pyroMod, String string, Collection<? extends Grid> collection, Particle particle, PartCloud.IDropletCount iDropletCount, PartCloud.IInsertion iInsertion, boolean bl, boolean bl2) {
        this(pyroMod, pyroMod.getObstructions(), string, collection, particle, iDropletCount, iInsertion, bl, bl2);
    }

    @Override
    protected void queueBeginRuntimeTasks() {
        if (this.d_grids.isEmpty()) {
            return;
        }
        List<PartCloud> list = this.createGridClouds(this.d_grids, this.d_particle, this.d_initDropCount, this.d_insertion, this.d_isStatic, this.d_distributeQuantities);
        if (list.isEmpty()) {
            return;
        }
        this.d_addedObjects.addAll(list);
        String string = Intl.intl("Particle Clouds");
        ModelComposite modelComposite = this.d_root.find(string, ModelComposite.class, false);
        if (modelComposite == null) {
            modelComposite = new ModelComposite(string);
            this.addTask(new AddTask((Composite)this.d_root, new IPyroObject[]{modelComposite}));
            this.d_addedObjects.add(modelComposite);
        }
        this.addTask(new AddTask<PartCloud>((Composite<PartCloud>)modelComposite, (Collection<PartCloud>)list));
    }

    public List<IPyroObject> getAddedObjects() {
        return this.d_addedObjects;
    }

    /*
     * WARNING - void declaration
     */
    private List<PartCloud> createGridClouds(Collection<? extends Grid> collection, Particle particle, PartCloud.IDropletCount iDropletCount, PartCloud.IInsertion iInsertion, boolean bl, boolean bl2) {
        Unit unit = SIUS.unit(56);
        UnitDouble unitDouble = new UnitDouble(0.0, unit);
        ArrayList<Object> arrayList = new ArrayList<Object>(collection.size());
        for (Grid grid : collection) {
            UnitDouble unitDouble2 = grid.getVolume();
            unitDouble = unitDouble.add(unitDouble2);
            arrayList.add(unitDouble2);
        }
        ArrayList arrayList2 = new ArrayList();
        boolean n = false;
        for (Grid grid : collection) {
            Serializable serializable;
            Object object;
            void var11_13;
            UnitDouble unitDouble3 = (UnitDouble)arrayList.get((int)(++var11_13));
            double d = unitDouble3.getValue(unit) / unitDouble.getValue(unit);
            PartCloud.IDropletCount iDropletCount2 = iDropletCount;
            if (bl2 && iDropletCount instanceof PartCloud.ConstDropletCount) {
                int iInsertion2 = iDropletCount.getNumDrops(null);
                int insertPeriodically = (int)Math.round((double)iInsertion2 * d);
                if (insertPeriodically == 0) continue;
                iDropletCount2 = new PartCloud.ConstDropletCount(insertPeriodically);
            }
            PartCloud.IInsertion iInsertion2 = iInsertion;
            if (bl2 && iInsertion instanceof PartCloud.InsertPeriodically) {
                PartCloud.InsertPeriodically aABox = (PartCloud.InsertPeriodically)iInsertion;
                object = aABox.massPerTime;
                serializable = ((UnitDouble)object).scale(d);
                if (((UnitDouble)serializable).getValueNoUnit() == 0.0) continue;
                iInsertion2 = new PartCloud.InsertPeriodically(aABox.dt, (UnitDouble)serializable);
            }
            AABox aABox = new AABox();
            grid.getGeom().getBoundingBox(aABox);
            object = this.getCloudName(grid, particle);
            serializable = new PartCloud((String)object, particle, new AABoxGeom(aABox));
            ((PartCloud)serializable).setInsertion(iInsertion2);
            ((PartCloud)serializable).setInitDrops(iDropletCount2);
            ((PartCloud)serializable).setStatic(bl);
            ((AFDSObject)serializable).setVisible(false);
            arrayList2.add(serializable);
        }
        return arrayList2;
    }

    private String getCloudName(Grid grid, Particle particle) {
        if (this.d_baseID != null) {
            return grid.getName() + " " + this.d_baseID;
        }
        return String.format(Intl.intl("%1$s %2$s cloud"), grid.getName(), particle.getName());
    }
}

