/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.tasks;

import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.vecmath.Matrix4d;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.IPyroGeomSrc;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Surface;
import pyrosim.legacy_2012_1.domain.geom.FDSObject;
import pyrosim.legacy_2012_1.domain.geom.GenericGeomSrc;
import pyrosim.legacy_2012_1.domain.geom.IHole;
import pyrosim.legacy_2012_1.domain.geom.IModelObj;
import pyrosim.legacy_2012_1.domain.geom.IObstruction;
import pyrosim.legacy_2012_1.domain.geom.ModelComposite;
import pyrosim.legacy_2012_1.domain.tasks.SelectTask;
import pyrosim.legacy_2012_1.domain.tasks.Tasks;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.GeomGroup;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.TransformedGeom;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPropsSrc;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.PropsBuilder;
import pyrosim.legacy_2012_1.thunderheadeng.util.CompositeTask;

public class ExplodeTask
extends CompositeTask<PyroMod> {
    public ExplodeTask(PyroMod pyroMod, Collection<? extends IModelObj> collection) {
        super(pyroMod);
        ObstDecorator obstDecorator = new ObstDecorator();
        EmptyDecorator emptyDecorator = new EmptyDecorator();
        ArrayList<IPyroObject> arrayList = new ArrayList<IPyroObject>();
        ArrayList<IModelObj> arrayList2 = new ArrayList<IModelObj>();
        for (IModelObj iModelObj : collection) {
            IPyroObject iPyroObject;
            List<IGeom> list = ExplodeTask.explodeGeom(iModelObj);
            if (list == null) continue;
            List<IModelObj> list2 = Collections.EMPTY_LIST;
            if (iModelObj instanceof IObstruction) {
                list2 = ExplodeTask.explodeFDSObject((IObstruction)iModelObj, list, obstDecorator);
            } else if (iModelObj instanceof IHole) {
                list2 = ExplodeTask.explodeFDSObject((IHole)iModelObj, list, emptyDecorator);
            } else if (iModelObj instanceof GenericGeomSrc) {
                list2 = ExplodeTask.explode((GenericGeomSrc)iModelObj, list);
            }
            if (list2.size() == 1) {
                iPyroObject = list2.get(0);
            } else {
                ModelComposite modelComposite = new ModelComposite(iModelObj.getName());
                modelComposite.addAll(list2);
                iPyroObject = modelComposite;
            }
            arrayList2.add(iModelObj);
            arrayList.add(iPyroObject);
        }
        if (!arrayList.isEmpty()) {
            SelectTask selectTask = new SelectTask(pyroMod, arrayList);
            selectTask.addTask(Tasks.replace(arrayList2, arrayList, true));
            this.addTask(selectTask);
        }
    }

    private static List<GenericGeomSrc> explode(GenericGeomSrc genericGeomSrc, List<IGeom> list) {
        IPropsSrc iPropsSrc = genericGeomSrc.getDisplayProps();
        ArrayList<GenericGeomSrc> arrayList = new ArrayList<GenericGeomSrc>(list.size());
        int n = 0;
        for (IGeom iGeom : list) {
            int n2 = iGeom.getNumPrims(7);
            PropsBuilder propsBuilder = new PropsBuilder();
            propsBuilder.add(iPropsSrc.subset(n, n2), n2, false);
            IPropsSrc iPropsSrc2 = propsBuilder.finalizeProps();
            GenericGeomSrc genericGeomSrc2 = (GenericGeomSrc)genericGeomSrc.clone();
            genericGeomSrc2.setGeom(iGeom, true);
            genericGeomSrc2.setDisplayProps(iPropsSrc2);
            arrayList.add(genericGeomSrc2);
            n += n2;
        }
        return arrayList;
    }

    private static <T extends FDSObject> List<T> explodeFDSObject(T t, List<IGeom> list, Decorator<T> decorator) {
        Color[] colorArray = t.getColors();
        int n = 0;
        decorator.begin(t);
        ArrayList<FDSObject> arrayList = new ArrayList<FDSObject>(list.size());
        for (IGeom iGeom : list) {
            int n2 = iGeom.getNumPrims(7);
            Color[] colorArray2 = ExplodeTask.subArray(colorArray, n, n2);
            n += n2;
            FDSObject fDSObject = (FDSObject)t.clone();
            fDSObject.setGeom(iGeom, true);
            fDSObject.setColors(colorArray2);
            decorator.decorateNext(fDSObject);
            arrayList.add(fDSObject);
        }
        return arrayList;
    }

    private static List<IGeom> explodeGeom(IPyroGeomSrc iPyroGeomSrc) {
        Serializable serializable;
        IGeom iGeom = iPyroGeomSrc.getGeom();
        Matrix4d matrix4d = null;
        if (iGeom instanceof TransformedGeom) {
            serializable = (TransformedGeom)iGeom;
            serializable = TransformedGeom.collapse((TransformedGeom)serializable);
            matrix4d = ((TransformedGeom)serializable).xform;
            iGeom = ((TransformedGeom)serializable).geom;
        }
        if (!(iGeom instanceof GeomGroup) || !iGeom.canExplode()) {
            return null;
        }
        serializable = new ArrayList();
        iGeom.explode((Collection<IGeom>)((Object)serializable));
        if (matrix4d != null) {
            for (int i = 0; i < serializable.size(); ++i) {
                IGeom iGeom2 = ((IGeom)serializable.get(i)).transform(matrix4d, IGeom.XformOp.RETAINED);
                serializable.set(i, iGeom2);
            }
        }
        return serializable;
    }

    private static <T> T[] subArray(T[] TArray, int n, int n2) {
        if (TArray.length == 1) {
            return TArray;
        }
        return Arrays.copyOfRange(TArray, n, n + n2);
    }

    private static class EmptyDecorator<T extends FDSObject>
    implements Decorator<T> {
        private EmptyDecorator() {
        }

        @Override
        public void begin(T t) {
        }

        @Override
        public void decorateNext(T t) {
        }
    }

    private static class ObstDecorator
    implements Decorator<IObstruction> {
        private Surface[] d_surfs;
        private int d_surfIx;

        private ObstDecorator() {
        }

        @Override
        public void begin(IObstruction iObstruction) {
            this.d_surfs = iObstruction.getSurfaces();
            this.d_surfIx = 0;
        }

        @Override
        public void decorateNext(IObstruction iObstruction) {
            int n = iObstruction.getGeom().getNumPrims(1);
            Surface[] surfaceArray = (Surface[])ExplodeTask.subArray(this.d_surfs, this.d_surfIx, n);
            this.d_surfIx += n;
            iObstruction.setSurfaces(surfaceArray);
        }
    }

    private static interface Decorator<T extends FDSObject> {
        public void begin(T var1);

        public void decorateNext(T var1);
    }
}

