/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.tasks;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import pyrosim.legacy_2012_1.domain.Composite;
import pyrosim.legacy_2012_1.domain.INamed;
import pyrosim.legacy_2012_1.domain.managers.Util;
import pyrosim.legacy_2012_1.thunderheadeng.util.AUndoableTask;

public class AutoRenameTask<V extends INamed>
extends AUndoableTask {
    private final Composite<? super V> d_mgr;
    private final INamed[] d_objects;
    private String[] d_names;

    public AutoRenameTask(Composite<? super V> composite, V ... VArray) {
        this(composite, (Collection<? super V>)Arrays.asList(VArray));
    }

    public AutoRenameTask(Composite<? super V> composite, Collection<? extends V> collection) {
        this.d_mgr = composite;
        this.d_objects = collection.toArray(new INamed[collection.size()]);
    }

    @Override
    public void undo() {
        this.rename();
    }

    @Override
    public void run() {
        if (this.d_names == null) {
            HashSet<String> hashSet = new HashSet<String>();
            for (Object object : this.d_mgr.flatten()) {
                if (!(object instanceof INamed)) continue;
                hashSet.add(((INamed)object).getName());
            }
            this.d_names = new String[this.d_objects.length];
            for (int i = 0; i < this.d_objects.length; ++i) {
                Object object;
                object = Util.getUniqueName(this.d_mgr, this.d_objects[i], hashSet);
                hashSet.add((String)object);
                this.d_names[i] = object;
            }
        }
        this.rename();
    }

    private void rename() {
        this.d_mgr.pauseUpdates();
        for (int i = 0; i < this.d_objects.length; ++i) {
            String string = this.d_objects[i].getName();
            String string2 = this.d_names[i];
            this.d_names[i] = string;
            this.d_objects[i].setName(string2);
        }
        this.d_mgr.resumeUpdates();
    }
}

