/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.tasks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.Composite;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.thunderheadeng.util.AUndoableTask;

public class AddTask<V extends IPyroObject>
extends AUndoableTask {
    private final Object d_objs;
    private final Composite<V> d_parent;

    public AddTask(Composite<V> composite, V ... VArray) {
        this(composite, (Collection<V>)Arrays.asList(VArray));
    }

    public AddTask(Composite<V> composite, Collection<? extends V> collection) {
        this.d_parent = composite;
        this.d_objs = collection.size() == 1 ? collection.iterator().next() : new ArrayList<V>(collection);
    }

    public List<? extends V> getObjects() {
        return this.d_objs instanceof ArrayList ? (ArrayList)this.d_objs : Arrays.asList((IPyroObject)this.d_objs);
    }

    protected PyroMod getDomain() {
        return (PyroMod)this.d_parent.getDomain();
    }

    protected Composite<V> getParent() {
        return this.d_parent;
    }

    protected void pauseUpdates() {
        PyroMod pyroMod = this.getDomain();
        if (pyroMod != null) {
            pyroMod.pauseUpdates();
        }
    }

    protected void resumeUpdates() {
        PyroMod pyroMod = this.getDomain();
        if (pyroMod != null) {
            pyroMod.resumeUpdates();
        }
    }

    @Override
    public void undo() {
        this.pauseUpdates();
        List<V> list = this.getObjects();
        for (int i = list.size() - 1; i >= 0; --i) {
            this.remove(this.d_parent, (IPyroObject)list.get(i));
        }
        this.resumeUpdates();
    }

    @Override
    public void run() {
        this.pauseUpdates();
        for (IPyroObject iPyroObject : this.getObjects()) {
            this.add(this.d_parent, iPyroObject);
        }
        this.resumeUpdates();
    }

    protected void remove(Composite<V> composite, V v) {
        this.d_parent.remove((IPyroObject)v);
    }

    protected void add(Composite<V> composite, V v) {
        boolean bl = this.d_parent.add((IPyroObject)v);
        assert (bl);
    }
}

