/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.tasks;

import java.util.Collection;
import java.util.List;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.Composite;
import pyrosim.legacy_2012_1.domain.Grid;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.geom.IModelObj;
import pyrosim.legacy_2012_1.domain.geom.ModelComposite;
import pyrosim.legacy_2012_1.domain.geom.Vent;
import pyrosim.legacy_2012_1.domain.tasks.AddTask;
import pyrosim.legacy_2012_1.domain.tasks.InsertTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.CompositeTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.Pair;

public class AddGridBoundaryVentsTask
extends CompositeTask<PyroMod> {
    private static final String GRID_BOUNDARY_VENT_PARENT = Intl.intl("Mesh Boundary Vents");

    public AddGridBoundaryVentsTask(PyroMod pyroMod, List<Pair<Grid, List<Vent>>> list) {
        super(pyroMod);
        ModelComposite modelComposite = this.findComposite(pyroMod.getObstructions(), GRID_BOUNDARY_VENT_PARENT, 0);
        for (Pair<Grid, List<Vent>> pair : list) {
            String string = String.format(Intl.intl("Vents for %s"), ((Grid)pair.v1).getName());
            ModelComposite modelComposite2 = this.findComposite(modelComposite, string, null);
            this.addTask(new AddTask<IModelObj>((Composite<IModelObj>)modelComposite2, (Collection)pair.v2));
        }
    }

    private ModelComposite findComposite(ModelComposite modelComposite, String string, Integer n) {
        ModelComposite modelComposite2 = modelComposite.find(string, ModelComposite.class, false);
        if (modelComposite2 == null) {
            modelComposite2 = new ModelComposite(string);
            if (n != null) {
                this.addTask(new InsertTask((Composite)modelComposite, n.intValue(), new IPyroObject[]{modelComposite2}));
            } else {
                this.addTask(new AddTask((Composite)modelComposite, new IPyroObject[]{modelComposite2}));
            }
        }
        return modelComposite2;
    }
}

