/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.signals;

import java.util.Set;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2012_1.domain.controls.IControl;
import pyrosim.legacy_2012_1.domain.signals.AOneInPin;
import pyrosim.legacy_2012_1.domain.signals.IDoubleInPin;
import pyrosim.legacy_2012_1.domain.signals.IDoubleOutPin;
import pyrosim.legacy_2012_1.domain.signals.IOutPin;
import pyrosim.legacy_2012_1.domain.signals.Util;
import pyrosim.legacy_2012_1.unitsystem.SIUS;
import pyrosim.legacy_2012_1.unitsystem.UnitSystem;

public abstract class AOneDoubleInPin
extends AOneInPin
implements IDoubleInPin {
    static final long serialVersionUID = 1L;

    public AOneDoubleInPin(IControl iControl) {
        super(iControl);
    }

    @Override
    public boolean isCompatible(IOutPin iOutPin) {
        return iOutPin instanceof IDoubleOutPin;
    }

    @Override
    public void connect(IOutPin iOutPin) {
        assert (iOutPin instanceof IDoubleOutPin);
        Unit unit = AOneDoubleInPin.getSampleUnit(iOutPin);
        Set<? extends IOutPin> set = this.getConnections();
        if (!set.isEmpty()) {
            Unit unit2 = AOneDoubleInPin.getSampleUnit(set.iterator().next());
            if (!Util.areCompatible(unit, unit2)) {
                this.updateInputUnit(unit);
            }
        } else {
            this.updateInputUnit(unit);
        }
        super.connect(iOutPin);
    }

    private static Unit getSampleUnit(IOutPin iOutPin) {
        assert (iOutPin instanceof IDoubleOutPin);
        SIUS sIUS = SIUS.getInstance();
        IDoubleOutPin iDoubleOutPin = (IDoubleOutPin)iOutPin;
        int n = iDoubleOutPin.getUnitType();
        return ((UnitSystem)sIUS).getUnit(n);
    }

    @Override
    public void changeInputUnits(UnitSystem unitSystem) {
        Set<? extends IOutPin> set = this.getConnections();
        if (!set.isEmpty()) {
            IDoubleOutPin iDoubleOutPin = (IDoubleOutPin)set.iterator().next();
            int n = iDoubleOutPin.getUnitType();
            Unit unit = unitSystem.getUnit(n);
            this.changeInputUnit(unit);
        }
    }

    protected abstract void changeInputUnit(Unit var1);

    @Override
    public boolean equals(Object object) {
        return object instanceof AOneDoubleInPin && super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 10065972;
    }
}

