/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.signals;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import pyrosim.legacy_2012_1.domain.dependencies.SkipDep;
import pyrosim.legacy_2012_1.domain.signals.AInPin;
import pyrosim.legacy_2012_1.domain.signals.IOutPin;
import pyrosim.legacy_2012_1.domain.signals.ISignalSink;
import pyrosim.legacy_2012_1.thunderheadeng.util.IHasher;
import pyrosim.legacy_2012_1.thunderheadeng.util.IdentityHasher;
import pyrosim.legacy_2012_1.thunderheadeng.util.ListSet;

public abstract class AMultiInPin
extends AInPin {
    static final long serialVersionUID = 1L;
    private final int d_maxConnections;
    @SkipDep
    private ListSet<IOutPin> d_connections;

    public AMultiInPin(ISignalSink iSignalSink, int n) {
        super(iSignalSink);
        this.d_connections = n != Integer.MAX_VALUE ? new ListSet<Object>((IHasher<Object>)IdentityHasher.INSTANCE, (T[])new Object[]{n}) : new ListSet(IdentityHasher.INSTANCE);
        this.d_maxConnections = n;
    }

    @Override
    public Object clone() {
        AMultiInPin aMultiInPin = (AMultiInPin)super.clone();
        aMultiInPin.d_connections = new ListSet<IOutPin>((IHasher<IOutPin>)IdentityHasher.INSTANCE, (Collection<IOutPin>)this.d_connections);
        return aMultiInPin;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof AMultiInPin)) {
            return false;
        }
        AMultiInPin aMultiInPin = (AMultiInPin)object;
        return super.equals(object) && this.d_maxConnections == aMultiInPin.d_maxConnections;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 231503 + this.d_maxConnections;
    }

    @Override
    public boolean canConnect(IOutPin iOutPin) {
        return super.canConnect(iOutPin) && this.d_connections.size() < this.d_maxConnections;
    }

    @Override
    public void connect(IOutPin iOutPin) {
        assert (this.canConnect(iOutPin));
        this.d_connections.add(iOutPin);
        super.connect(iOutPin);
    }

    @Override
    public boolean disconnect(IOutPin iOutPin) {
        if (!this.d_connections.remove(iOutPin)) {
            return false;
        }
        return super.disconnect(iOutPin);
    }

    @Override
    public boolean disconnectAll() {
        this.d_connections.clear();
        return true;
    }

    @Override
    public Set<? extends IOutPin> getConnections() {
        return Collections.unmodifiableSet(this.d_connections);
    }
}

