/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.signals;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.dependencies.DLink;
import pyrosim.legacy_2012_1.domain.dependencies.DepList;
import pyrosim.legacy_2012_1.domain.dependencies.SkipDep;
import pyrosim.legacy_2012_1.domain.signals.IInPin;
import pyrosim.legacy_2012_1.domain.signals.IOutPin;
import pyrosim.legacy_2012_1.domain.signals.ISignalSink;
import pyrosim.legacy_2012_1.domain.signals.ISignalSource;
import pyrosim.legacy_2012_1.domain.signals.Util;
import pyrosim.legacy_2012_1.thunderheadeng.util.AUndoableTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.ICloneRequired;
import pyrosim.legacy_2012_1.thunderheadeng.util.IHasher;
import pyrosim.legacy_2012_1.thunderheadeng.util.JavaHasher;
import pyrosim.legacy_2012_1.thunderheadeng.util.ListSet;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;

public abstract class AInPin
implements IInPin,
ICloneRequired,
Serializable {
    static final long serialVersionUID = 1L;
    @SkipDep
    private ISignalSink d_attachedSink;

    public AInPin(ISignalSink iSignalSink) {
        this.d_attachedSink = iSignalSink;
    }

    @Override
    public Object clone() {
        try {
            AInPin aInPin = (AInPin)super.clone();
            aInPin.d_attachedSink = null;
            return aInPin;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            assert (false);
            return null;
        }
    }

    @Override
    public Object clone(ISignalSink iSignalSink) {
        AInPin aInPin = (AInPin)this.clone();
        aInPin.d_attachedSink = iSignalSink;
        return aInPin;
    }

    @Override
    public void setSink(ISignalSink iSignalSink) {
        this.d_attachedSink = iSignalSink;
    }

    public boolean equals(Object object) {
        if (!(object instanceof AInPin)) {
            return false;
        }
        AInPin aInPin = (AInPin)object;
        Set<? extends IOutPin> set = this.getConnections();
        Set<? extends IOutPin> set2 = aInPin.getConnections();
        if (set.size() > 1) {
            set = new ListSet<IOutPin>((IHasher<? extends IOutPin>)JavaHasher.INSTANCE, (Collection<? extends IOutPin>)set);
        }
        if (set2.size() > 1) {
            set2 = new ListSet<IOutPin>((IHasher<? extends IOutPin>)JavaHasher.INSTANCE, (Collection<? extends IOutPin>)set2);
        }
        return set.equals(set2);
    }

    public int hashCode() {
        int n = 215294;
        for (IOutPin iOutPin : this.getConnections()) {
            n += iOutPin.hashCode();
        }
        return n;
    }

    @Override
    public Set<ISignalSource> getConnectedSources() {
        LinkedHashSet<ISignalSource> linkedHashSet = new LinkedHashSet<ISignalSource>();
        for (IOutPin iOutPin : this.getConnections()) {
            linkedHashSet.add(iOutPin.getAttachedSource());
        }
        return linkedHashSet;
    }

    @Override
    public ISignalSink getAttachedSink() {
        return this.d_attachedSink;
    }

    @Override
    public boolean canConnect(IOutPin iOutPin) {
        return iOutPin.getAttachedSource() != this.getAttachedSink() && this.isCompatible(iOutPin);
    }

    @Override
    public void connect(IOutPin iOutPin) {
    }

    @Override
    public boolean disconnect(IOutPin iOutPin) {
        return true;
    }

    @Override
    public void takeDepSnapshot(DepList depList) {
        for (IOutPin iOutPin : this.getConnections()) {
            depList.add(DLink.WEAK, (IPyroObject)iOutPin.getAttachedSource());
        }
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T t, Set<T> set) {
        pyrosim.legacy_2012_1.util.Util.removeAllNotOfType(set, ISignalSource.class);
        List<IOutPin> list = this.getConnectedPins((ISignalSource)t);
        Iterator<T> iterator = set.iterator();
        block0: while (iterator.hasNext()) {
            ISignalSource iSignalSource = (ISignalSource)iterator.next();
            if (iSignalSource == null) continue;
            for (IOutPin iOutPin : list) {
                IOutPin iOutPin2 = Util.getPin(iSignalSource, iOutPin.getName());
                if (iOutPin2 != null && this.isCompatible(iOutPin2)) continue;
                iterator.remove();
                continue block0;
            }
        }
    }

    private List<IOutPin> getConnectedPins(ISignalSource iSignalSource) {
        Set<? extends IOutPin> set = this.getConnections();
        ArrayList<IOutPin> arrayList = new ArrayList<IOutPin>(set.size());
        for (IOutPin iOutPin : set) {
            if (iOutPin.getAttachedSource() != iSignalSource) continue;
            arrayList.add(iOutPin);
        }
        return arrayList;
    }

    @Override
    public Task taskReplaceDep(final IPyroObject iPyroObject, final IPyroObject iPyroObject2) {
        return new AUndoableTask(){
            private List<IOutPin> d_disconnectedPins;
            private List<IOutPin> d_connectedPins;

            @Override
            public void undo() {
                if (this.d_connectedPins != null) {
                    for (IOutPin iOutPin : this.d_connectedPins) {
                        AInPin.this.disconnect(iOutPin);
                    }
                }
                for (IOutPin iOutPin : this.d_disconnectedPins) {
                    AInPin.this.connect(iOutPin);
                }
            }

            @Override
            public void run() {
                this.d_disconnectedPins = AInPin.this.getConnectedPins((ISignalSource)iPyroObject);
                for (IOutPin iOutPin : this.d_disconnectedPins) {
                    AInPin.this.disconnect(iOutPin);
                }
                if (iPyroObject2 != null) {
                    this.d_connectedPins = new ArrayList<IOutPin>(this.d_disconnectedPins.size());
                    for (IOutPin iOutPin : this.d_disconnectedPins) {
                        IOutPin iOutPin2 = Util.getPin((ISignalSource)iPyroObject2, iOutPin.getName());
                        assert (iOutPin2 != null);
                        AInPin.this.connect(iOutPin2);
                        this.d_connectedPins.add(iOutPin2);
                    }
                } else {
                    this.d_connectedPins = null;
                }
            }
        };
    }
}

