/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.reaction;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.CustomFDSProps;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.NamedPyroObject;
import pyrosim.legacy_2012_1.domain.reaction.Byproducts;
import pyrosim.legacy_2012_1.domain.reaction.FireSuppression;
import pyrosim.legacy_2012_1.domain.reaction.Fuel;
import pyrosim.legacy_2012_1.domain.reaction.HeatReleaseRate;
import pyrosim.legacy_2012_1.io.PyroSimObjectInputStream;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;
import pyrosim.legacy_2012_1.unitsystem.SIUS;

public class Reaction
extends NamedPyroObject
implements Serializable {
    static final long serialVersionUID = 1L;
    private String d_fyi;
    private boolean d_active;
    private Fuel d_fuel = new Fuel();
    private FireSuppression d_suppression = new FireSuppression();
    private Byproducts d_byproducts = new Byproducts();
    private HeatReleaseRate d_hrr = HeatReleaseRate.newLES();
    private CustomFDSProps d_customFDSProps = new CustomFDSProps();

    public Reaction(String string) {
        super(string);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (PyroSimObjectInputStream.getVersion(objectInputStream) < 38) {
            assert (this.d_hrr == null);
            HeatReleaseRate heatReleaseRate = HeatReleaseRate.newLES();
            UnitDouble unitDouble = this.d_fuel.d_hrrpuaUpperLimit;
            if (!unitDouble.equals(SIUS.newud(200.0, 22))) {
                heatReleaseRate = new HeatReleaseRate(heatReleaseRate.eddyDissipation, heatReleaseRate.cEdc, unitDouble, heatReleaseRate.hrrpuvUpperLimit);
            }
            this.d_hrr = heatReleaseRate;
        }
        if (this.d_customFDSProps == null) {
            this.d_customFDSProps = new CustomFDSProps();
        }
    }

    @Override
    protected void addToDomain(PyroMod pyroMod, IPyroObject iPyroObject) {
        super.addToDomain(pyroMod, iPyroObject);
        if (pyroMod.getReactions().flatten().isEmpty() || pyroMod.getReactions().flatten().size() == 1 && pyroMod.getReactions().flatten().iterator().next() == this) {
            this.setActive(true);
        }
    }

    public CustomFDSProps getCustomFDSProps() {
        return this.d_customFDSProps;
    }

    public void setCustomFDSProps(CustomFDSProps customFDSProps) {
        this.d_customFDSProps = customFDSProps;
        this.changedEvt(new Object[0]);
    }

    public String getFYI() {
        return this.d_fyi == null ? "" : this.d_fyi;
    }

    public void setFYI(String string) {
        this.d_fyi = string;
        this.changedEvt(new Object[0]);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Reaction)) {
            return false;
        }
        Reaction reaction = (Reaction)object;
        return super.equals(object) && this.d_fuel.equals(reaction.d_fuel) && theUtil.equal(this.d_suppression, reaction.d_suppression) && this.d_byproducts.equals(reaction.d_byproducts) && this.d_hrr.equals(reaction.d_hrr) && this.d_customFDSProps.equals(reaction.d_customFDSProps);
    }

    public void imprint(Reaction reaction) {
        this.d_fuel = reaction.d_fuel;
        this.d_byproducts = reaction.d_byproducts;
        this.d_suppression = reaction.d_suppression;
        this.d_hrr = reaction.d_hrr;
        this.d_customFDSProps = reaction.d_customFDSProps;
        this.changedEvt(new Object[0]);
    }

    public boolean isActive() {
        return this.d_active;
    }

    public void setActive(boolean bl) {
        this.d_active = bl;
        this.changedEvt(new Object[0]);
    }

    public Fuel getFuel() {
        return this.d_fuel;
    }

    public void setFuel(Fuel fuel) {
        this.d_fuel = fuel;
        this.changedEvt(new Object[0]);
    }

    public Byproducts getByproducts() {
        return this.d_byproducts;
    }

    public void setByproducts(Byproducts byproducts) {
        this.d_byproducts = byproducts;
        this.changedEvt(new Object[0]);
    }

    public FireSuppression getSuppression() {
        return this.d_suppression;
    }

    public void setSuppression(FireSuppression fireSuppression) {
        this.d_suppression = fireSuppression;
        this.changedEvt(new Object[0]);
    }

    public HeatReleaseRate getHRR() {
        return this.d_hrr;
    }

    public void setHRR(HeatReleaseRate heatReleaseRate) {
        this.d_hrr = heatReleaseRate;
        this.changedEvt(new Object[0]);
    }

    @Override
    public boolean invokesMixFrac() {
        return true;
    }
}

