/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.reaction;

import java.io.Serializable;
import pyrosim.legacy_2012_1.domain.reaction.Soot;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;
import pyrosim.legacy_2012_1.unitsystem.SIUS;

public class Byproducts
implements Serializable {
    static final long serialVersionUID = 1L;
    public final double d_coYield;
    public final double d_h2Yield;
    public final double d_sootYield;
    public final Soot d_soot;
    public final Energy d_energy;

    public Byproducts() {
        this(0.0, 0.0, 0.01, new Soot(), new OxygenEnergy());
    }

    public Byproducts(double d, double d2, double d3, Soot soot, Energy energy) {
        this.d_coYield = d;
        this.d_h2Yield = d2;
        this.d_sootYield = d3;
        this.d_soot = soot;
        this.d_energy = energy;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Byproducts)) {
            return false;
        }
        Byproducts byproducts = (Byproducts)object;
        return this.d_coYield == byproducts.d_coYield && this.d_h2Yield == byproducts.d_h2Yield && this.d_sootYield == byproducts.d_sootYield && theUtil.equal(this.d_soot, byproducts.d_soot) && this.d_energy.equals(byproducts.d_energy);
    }

    public static class OxygenEnergy
    extends Energy {
        static final long serialVersionUID = 1L;
        public final UnitDouble d_epumo2;

        public OxygenEnergy() {
            this(SIUS.newud(13100.0, 48), false);
        }

        public OxygenEnergy(UnitDouble unitDouble, boolean bl) {
            super(bl);
            this.d_epumo2 = unitDouble;
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof OxygenEnergy)) {
                return false;
            }
            OxygenEnergy oxygenEnergy = (OxygenEnergy)object;
            return super.equals(object) && this.d_epumo2.equals(oxygenEnergy.d_epumo2);
        }
    }

    public static class FuelEnergy
    extends Energy {
        static final long serialVersionUID = 1L;
        public final UnitDouble d_heatOfCombustion;

        public FuelEnergy(UnitDouble unitDouble, boolean bl) {
            super(bl);
            this.d_heatOfCombustion = unitDouble;
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof FuelEnergy)) {
                return false;
            }
            FuelEnergy fuelEnergy = (FuelEnergy)object;
            return super.equals(object) && this.d_heatOfCombustion.equals(fuelEnergy.d_heatOfCombustion);
        }
    }

    public static abstract class Energy
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final boolean d_ideal;

        public Energy() {
            this(false);
        }

        public Energy(boolean bl) {
            this.d_ideal = bl;
        }

        public boolean equals(Object object) {
            return object instanceof Energy && ((Energy)object).d_ideal == this.d_ideal;
        }
    }
}

