/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.quantity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.dependencies.DLink;
import pyrosim.legacy_2012_1.domain.dependencies.DepList;
import pyrosim.legacy_2012_1.domain.quantity.IQuantity;
import pyrosim.legacy_2012_1.domain.quantity.ObjectQuantity;
import pyrosim.legacy_2012_1.domain.quantity.Quantity;
import pyrosim.legacy_2012_1.domain.quantity.QuantityType;
import pyrosim.legacy_2012_1.domain.quantity.StaticQuantity;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObjectFilter;
import pyrosim.legacy_2012_1.util.ANameSorter;
import pyrosim.legacy_2012_1.util.Filters;
import pyrosim.legacy_2012_1.util.ITransformer;
import pyrosim.legacy_2012_1.util.TransformedCollection;
import pyrosim.legacy_2012_1.util.Util;

public class QuantityUtil {
    public static final IObjectFilter<Quantity> STATIC_QUANT_FILTER = new IObjectFilter<Quantity>(){

        @Override
        public boolean shouldFilter(Quantity quantity) {
            return quantity.getNumArgs() == 0;
        }
    };
    public static final IObjectFilter<Quantity> OBJ_QUANT_FILTER = new IObjectFilter<Quantity>(){

        @Override
        public boolean shouldFilter(Quantity quantity) {
            return quantity.getNumArgs() > 0;
        }
    };

    public static boolean isOneOf(Quantity quantity, QuantityType ... quantityTypeArray) {
        for (QuantityType quantityType : quantityTypeArray) {
            if (quantity.quantityType != quantityType) continue;
            return true;
        }
        return false;
    }

    public static boolean canOutputAll(Quantity quantity, int n) {
        return (quantity.outputTypes & n) == n;
    }

    public static boolean canOutputAny(Quantity quantity, int n) {
        return (quantity.outputTypes & n) != 0;
    }

    public static boolean isSpecMassFraction(Quantity quantity) {
        return quantity.unitType == 18;
    }

    public static Collection<Quantity> getQuantities(final int n) {
        return QuantityUtil.getQuantities(new IObjectFilter<Quantity>(){

            @Override
            public boolean shouldFilter(Quantity quantity) {
                return !QuantityUtil.canOutputAll(quantity, n);
            }
        });
    }

    public static Collection<Quantity> getQuantities(int n, QuantityType ... quantityTypeArray) {
        TypeFilter typeFilter = new TypeFilter(n, quantityTypeArray);
        return QuantityUtil.getQuantities(typeFilter);
    }

    public static Collection<Quantity> getQuantities(final IObjectFilter<Quantity> iObjectFilter) {
        Collection<Quantity> collection = Arrays.asList(Quantity.values());
        collection = Util.filter(collection, Quantity.class, new IObjectFilter<Quantity>(){

            @Override
            public boolean shouldFilter(Quantity quantity) {
                return quantity.isDeprecated() || iObjectFilter.shouldFilter(quantity);
            }
        });
        return collection;
    }

    public static Collection<Quantity> sort(Collection<Quantity> collection) {
        ArrayList<Quantity> arrayList = new ArrayList<Quantity>(collection);
        Collections.sort(arrayList, new ANameSorter<Quantity>(){

            @Override
            protected String getName(Quantity quantity) {
                return quantity.name;
            }
        });
        return arrayList;
    }

    public static Collection<IQuantity> sortQuantities(Collection<? extends IQuantity> collection) {
        ArrayList<IQuantity> arrayList = new ArrayList<IQuantity>(collection);
        Collections.sort(arrayList, new ANameSorter<IQuantity>(){

            @Override
            protected String getName(IQuantity iQuantity) {
                return iQuantity.getDescription();
            }
        });
        return arrayList;
    }

    public static Map<String, List<Quantity>> groupObjQuantities() {
        HashMap<String, List<Quantity>> hashMap = new HashMap<String, List<Quantity>>();
        for (Quantity quantity : Quantity.values()) {
            if (quantity.category == null || quantity.getNumArgs() <= 0) continue;
            ArrayList<Quantity> arrayList = (ArrayList<Quantity>)hashMap.get(quantity.category);
            if (arrayList == null) {
                arrayList = new ArrayList<Quantity>();
                hashMap.put(quantity.category, arrayList);
            }
            arrayList.add(quantity);
        }
        return hashMap;
    }

    public static Collection<StaticQuantity> generateStaticQuantities(IObjectFilter<Quantity> iObjectFilter, boolean bl) {
        iObjectFilter = Filters.merge(OBJ_QUANT_FILTER, iObjectFilter);
        Collection<Quantity> collection = QuantityUtil.getQuantities(iObjectFilter);
        ITransformer<Quantity, StaticQuantity> iTransformer = new ITransformer<Quantity, StaticQuantity>(){

            @Override
            public StaticQuantity transform(Quantity quantity) {
                return quantity.create();
            }
        };
        Collection<Object> collection2 = new TransformedCollection<Quantity, StaticQuantity>(collection, iTransformer);
        if (bl) {
            collection2 = Util.sort(collection2, new ANameSorter<StaticQuantity>(){

                @Override
                protected String getName(StaticQuantity staticQuantity) {
                    return staticQuantity.getDescription();
                }
            });
        }
        return collection2;
    }

    public static Collection<? extends IPyroObject> getValidArguments(PyroMod pyroMod, Quantity quantity, int n) {
        Class<? extends IPyroObject> clazz = quantity.requiredTypes[n];
        IObjectFilter iObjectFilter = quantity.typeFilters[n];
        return Util.getAllObjects(pyroMod, clazz, iObjectFilter, true);
    }

    public static void takeDepSnapshot(DepList depList, DLink dLink, IQuantity ... iQuantityArray) {
        for (IQuantity iQuantity : iQuantityArray) {
            QuantityUtil.takeDepSnapshot(depList, dLink, iQuantity);
        }
    }

    public static void takeDepSnapshot(DepList depList, DLink dLink, Collection<IQuantity> collection) {
        for (IQuantity iQuantity : collection) {
            QuantityUtil.takeDepSnapshot(depList, dLink, iQuantity);
        }
    }

    public static void takeDepSnapshot(DepList depList, DLink dLink, IQuantity iQuantity) {
        if (iQuantity instanceof ObjectQuantity) {
            ObjectQuantity objectQuantity = (ObjectQuantity)iQuantity;
            for (Object t : objectQuantity.objects) {
                depList.add(dLink, (IPyroObject)t);
            }
        }
    }

    public static boolean isQuantityRef(IPyroObject iPyroObject, IQuantity ... iQuantityArray) {
        for (IQuantity iQuantity : iQuantityArray) {
            if (!QuantityUtil.isQuantityRef(iPyroObject, iQuantity)) continue;
            return true;
        }
        return false;
    }

    public static boolean isQuantityRef(IPyroObject iPyroObject, Collection<? extends IQuantity> collection) {
        for (IQuantity iQuantity : collection) {
            if (!QuantityUtil.isQuantityRef(iPyroObject, iQuantity)) continue;
            return true;
        }
        return false;
    }

    public static boolean isQuantityRef(IPyroObject iPyroObject, IQuantity iQuantity) {
        if (iQuantity instanceof ObjectQuantity) {
            for (Object t : ((ObjectQuantity)iQuantity).objects) {
                if (t != iPyroObject) continue;
                return true;
            }
        }
        return false;
    }

    public static class TypeFilter
    implements IObjectFilter<Quantity> {
        private final int outputTypes;
        private final QuantityType[] quantityTypes;

        public TypeFilter(int n, QuantityType ... quantityTypeArray) {
            this.outputTypes = n;
            this.quantityTypes = quantityTypeArray;
        }

        @Override
        public boolean shouldFilter(Quantity quantity) {
            return this.quantityTypes.length > 0 && !QuantityUtil.isOneOf(quantity, this.quantityTypes) || !QuantityUtil.canOutputAll(quantity, this.outputTypes);
        }
    }
}

