/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.particle;

import java.io.Serializable;
import org.jscience.physics.units.SI;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class SizeDistribution
implements Serializable {
    static final long serialVersionUID = 1L;
    public final UnitDouble d_medianDiameter;
    public final Type d_type;

    public SizeDistribution() {
        this(new UnitDouble(500.0, SI.MICRO(SI.METER)), new RosinRammler());
    }

    public SizeDistribution(UnitDouble unitDouble, Type type) {
        this.d_medianDiameter = unitDouble;
        this.d_type = type;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SizeDistribution)) {
            return false;
        }
        SizeDistribution sizeDistribution = (SizeDistribution)object;
        return this.d_medianDiameter.equals(sizeDistribution.d_medianDiameter) && this.d_type.equals(sizeDistribution.d_type);
    }

    public int hashCode() {
        return 1665355757 + this.d_medianDiameter.hashCode() + this.d_type.hashCode();
    }

    public static class RosinRammler
    implements Type {
        static final long serialVersionUID = 1L;
        public final double d_gammaD;
        public final UnitDouble d_minDiameter;
        public final UnitDouble d_maxDiameter;
        public final Double d_sigma;

        public RosinRammler() {
            this(2.4);
        }

        public RosinRammler(double d) {
            this(d, new UnitDouble(20.0, SI.MICRO(SI.METER)), new UnitDouble(Double.POSITIVE_INFINITY, SI.MICRO(SI.METER)), null);
        }

        public RosinRammler(double d, UnitDouble unitDouble, UnitDouble unitDouble2, Double d2) {
            this.d_gammaD = d;
            this.d_minDiameter = unitDouble;
            this.d_maxDiameter = unitDouble2;
            this.d_sigma = d2;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof RosinRammler)) {
                return false;
            }
            RosinRammler rosinRammler = (RosinRammler)object;
            return this.d_gammaD == rosinRammler.d_gammaD && this.d_minDiameter.equals(rosinRammler.d_minDiameter) && this.d_maxDiameter.equals(rosinRammler.d_maxDiameter) && theUtil.equal(this.d_sigma, rosinRammler.d_sigma);
        }

        public int hashCode() {
            return 593801012 + theUtil.hashCode(this.d_gammaD) + this.d_minDiameter.hashCode() + this.d_maxDiameter.hashCode() + theUtil.hashCode(this.d_sigma);
        }
    }

    public static class Constant
    implements Type {
        static final long serialVersionUID = 1L;

        public boolean equals(Object object) {
            return object == this || object instanceof Constant;
        }

        public int hashCode() {
            return -2110521542;
        }
    }

    public static interface Type
    extends Serializable {
    }
}

