/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.particle;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Set;
import org.jscience.physics.units.SI;
import pyrosim.legacy_2012_1.domain.ExSpec;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.dependencies.DLink;
import pyrosim.legacy_2012_1.domain.dependencies.DepList;
import pyrosim.legacy_2012_1.domain.dependencies.IDirectDependent;
import pyrosim.legacy_2012_1.domain.tasks.AReplaceRefTask;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.EmptyTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;
import pyrosim.legacy_2012_1.unitsystem.SIUS;
import pyrosim.legacy_2012_1.util.Util;

public class Pyrolysis
implements Serializable,
IDirectDependent {
    static final long serialVersionUID = 1L;
    public final UnitDouble d_meltingTemp;
    private boolean d_evaporate;
    public final UnitDouble d_vapTemp;
    public final UnitDouble d_heatOfVap;
    private ExSpec d_vapSpec;

    public Pyrolysis() {
        this(new UnitDouble(0.0, SI.CELSIUS), true, new UnitDouble(100.0, SI.CELSIUS), SIUS.newud(2259.0, 46), null);
    }

    protected Pyrolysis(UnitDouble unitDouble, boolean bl, UnitDouble unitDouble2, UnitDouble unitDouble3, ExSpec exSpec) {
        this.d_meltingTemp = unitDouble;
        this.d_evaporate = bl;
        this.d_vapTemp = unitDouble2;
        this.d_heatOfVap = unitDouble3;
        this.d_vapSpec = exSpec;
        assert (!bl || unitDouble2 != null && unitDouble3 != null) : "If evaporation is turned on, the vaporazation temperature and heat of vaporazation must be specified";
    }

    public static Pyrolysis evapOff(UnitDouble unitDouble) {
        return new Pyrolysis(unitDouble, false, null, null, null);
    }

    public static Pyrolysis evapOn(UnitDouble unitDouble, UnitDouble unitDouble2, UnitDouble unitDouble3, ExSpec exSpec) {
        return new Pyrolysis(unitDouble, true, unitDouble2, unitDouble3, exSpec);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Pyrolysis)) {
            return false;
        }
        Pyrolysis pyrolysis = (Pyrolysis)object;
        return this.d_meltingTemp.equals(pyrolysis.d_meltingTemp) && this.d_evaporate == pyrolysis.d_evaporate && this.d_vapTemp.equals(pyrolysis.d_vapTemp) && this.d_heatOfVap.equals(pyrolysis.d_heatOfVap) && theUtil.equal(this.d_vapSpec, pyrolysis.d_vapSpec);
    }

    public int hashCode() {
        return 1648883510 + this.d_meltingTemp.hashCode() + theUtil.hashCode(this.d_evaporate) + this.d_vapTemp.hashCode() + this.d_heatOfVap.hashCode() + theUtil.hashCode(this.d_vapSpec);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.d_evaporate = true;
        objectInputStream.defaultReadObject();
    }

    public boolean evaporates() {
        return this.d_evaporate;
    }

    public ExSpec getVaporizationSpecies() {
        return this.d_vapSpec;
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T t, Set<T> set) {
        Util.removeAllNotOfType(set, ExSpec.class);
    }

    @Override
    public Task taskReplaceDep(IPyroObject iPyroObject, IPyroObject iPyroObject2) {
        if (iPyroObject != this.d_vapSpec) {
            return EmptyTask.INSTANCE;
        }
        return new AReplaceRefTask<ExSpec>((Object)iPyroObject, (Object)iPyroObject2){

            @Override
            protected void set(ExSpec exSpec) {
                Pyrolysis.this.d_vapSpec = exSpec;
            }
        };
    }

    @Override
    public void takeDepSnapshot(DepList depList) {
        depList.add(DLink.WEAK, (IPyroObject)this.d_vapSpec);
    }
}

