/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.particle;

import java.io.Serializable;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.Composite;
import pyrosim.legacy_2012_1.domain.particle.FuelPartDesc;
import pyrosim.legacy_2012_1.domain.particle.FuelPyrolysis;
import pyrosim.legacy_2012_1.domain.particle.Output;
import pyrosim.legacy_2012_1.domain.particle.Particle;
import pyrosim.legacy_2012_1.domain.particle.SizeDistribution;
import pyrosim.legacy_2012_1.domain.particle.ThermalProps;
import pyrosim.legacy_2012_1.domain.particle.TracerPartDesc;
import pyrosim.legacy_2012_1.domain.particle.WaterPartDesc;
import pyrosim.legacy_2012_1.unitsystem.SIUS;

public class ParticleList
extends Composite<Particle>
implements Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    public static final String FUEL = Intl.intl("Fuel");
    public static final String WATER = Intl.intl("Water");
    public static final String TRACER = Intl.intl("Tracer");

    public ParticleList() {
        this(Intl.intl("Particles"));
    }

    public ParticleList(String string) {
        super(string, Particle.class);
    }

    public void addDefaults() {
        this.addDefault(ParticleList.getDefaultFuel());
        this.addDefault(new Particle(Intl.intl("Tracer"), new TracerPartDesc()));
        this.addDefault(new Particle(Intl.intl("Water"), new WaterPartDesc()));
    }

    public static Particle getDefaultFuel() {
        FuelPartDesc fuelPartDesc = new FuelPartDesc(new ThermalProps(SIUS.newud(789.0, 4), SIUS.newud(2.44, 11), null), new FuelPyrolysis(SIUS.newud(-114.3, 1), SIUS.newud(78.4, 1), SIUS.newud(841.0, 46), SIUS.newud(29800.0, 48)), new SizeDistribution(), new Output(10), null, 5000);
        Particle particle = new Particle(Intl.intl("Fuel"), fuelPartDesc);
        particle.setFYI(Intl.intl("Ethanol"));
        return particle;
    }
}

