/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.particle;

import java.io.IOException;
import java.io.ObjectInputStream;
import pyrosim.legacy_2012_1.domain.CustomFDSProps;
import pyrosim.legacy_2012_1.domain.NamedPyroObject;
import pyrosim.legacy_2012_1.domain.particle.FuelPartDesc;
import pyrosim.legacy_2012_1.domain.particle.GenericPartDesc;
import pyrosim.legacy_2012_1.domain.particle.IParticleDesc;
import pyrosim.legacy_2012_1.domain.particle.WaterPartDesc;
import pyrosim.legacy_2012_1.domain.signals.IInPin;
import pyrosim.legacy_2012_1.domain.signals.ISignalSink;
import pyrosim.legacy_2012_1.domain.signals.OneLogicInPin;

public class Particle
extends NamedPyroObject
implements ISignalSink {
    static final long serialVersionUID = 1L;
    private String d_fyi;
    private IParticleDesc d_desc;
    private CustomFDSProps d_customFDSProps;
    private OneLogicInPin d_inPin;

    public Particle(String string) {
        this(string, new GenericPartDesc());
    }

    public Particle(String string, IParticleDesc iParticleDesc) {
        super(string);
        this.d_desc = iParticleDesc;
        this.d_customFDSProps = new CustomFDSProps();
        this.d_inPin = new OneLogicInPin(this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.d_customFDSProps == null) {
            this.d_customFDSProps = new CustomFDSProps();
        }
        if (this.d_inPin == null) {
            this.d_inPin = new OneLogicInPin(this);
        }
    }

    public CustomFDSProps getCustomFDSProps() {
        return this.d_customFDSProps;
    }

    public void setCustomFDSProps(CustomFDSProps customFDSProps) {
        this.d_customFDSProps = customFDSProps;
        this.changedEvt(new Object[0]);
    }

    public String getFYI() {
        return this.d_fyi == null ? "" : this.d_fyi;
    }

    public void setFYI(String string) {
        this.d_fyi = string;
        this.changedEvt(new Object[0]);
    }

    @Override
    public Object clone() {
        Particle particle = (Particle)super.clone();
        particle.d_inPin = (OneLogicInPin)this.d_inPin.clone(particle);
        return particle;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return object instanceof Particle && super.equals(object) && this.d_inPin.equals(((Particle)object).d_inPin) && this.propEquals(object);
    }

    public boolean propEquals(Object object) {
        return object == this || object instanceof Particle && this.d_desc.equals(((Particle)object).d_desc) && this.d_customFDSProps.equals(((Particle)object).d_customFDSProps);
    }

    public int propHash() {
        return this.d_desc.hashCode() + this.d_customFDSProps.hashCode();
    }

    @Override
    public IInPin getInputPin() {
        return this.d_inPin;
    }

    public IParticleDesc getDescription() {
        return this.d_desc;
    }

    public void setDescription(IParticleDesc iParticleDesc) {
        assert (this.d_desc.isMassless() == iParticleDesc.isMassless());
        this.d_desc = iParticleDesc;
        this.changedEvt(new Object[0]);
    }

    public boolean isMassless() {
        return this.d_desc.isMassless();
    }

    public boolean isWater() {
        return this.d_desc instanceof WaterPartDesc;
    }

    public boolean isFuel() {
        return this.d_desc instanceof FuelPartDesc;
    }

    public boolean isGeneric() {
        return this.d_desc instanceof GenericPartDesc;
    }

    @Override
    public boolean invokesMixFrac() {
        return this.d_desc.invokesMixFrac();
    }
}

