/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.output;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.vecmath.Point3d;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Surface;
import pyrosim.legacy_2012_1.domain.dependencies.DLink;
import pyrosim.legacy_2012_1.domain.dependencies.DepList;
import pyrosim.legacy_2012_1.domain.output.AMsrStat;
import pyrosim.legacy_2012_1.domain.quantity.IQuantity;
import pyrosim.legacy_2012_1.domain.quantity.Quantity;
import pyrosim.legacy_2012_1.domain.quantity.QuantityType;
import pyrosim.legacy_2012_1.domain.quantity.QuantityUtil;
import pyrosim.legacy_2012_1.domain.tasks.SetReplacementTask;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AABoxGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObjectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.util.IdentityHashSet;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;
import pyrosim.legacy_2012_1.util.Util;

public class SolidMsrStat
extends AMsrStat {
    static final long serialVersionUID = 1L;
    private final Set<Surface> d_surfaces;

    public SolidMsrStat(String string, IQuantity iQuantity) {
        this(string, iQuantity, new AABoxGeom(new Point3d(0.0, 0.0, 0.0), new Point3d(1.0, 1.0, 1.0), 0), Collections.EMPTY_LIST, Collections.EMPTY_LIST);
    }

    public SolidMsrStat(String string, IQuantity iQuantity, IGeom iGeom, Collection<Surface> collection, Collection<Integer> collection2) {
        super(string, iQuantity, collection2, iGeom);
        this.d_surfaces = new IdentityHashSet<Surface>(collection);
    }

    @Override
    public boolean equals(Object object) {
        return object == this || object instanceof SolidMsrStat && super.equals(object) && Util.identitySetsEqual(((SolidMsrStat)object).d_surfaces, this.d_surfaces);
    }

    @Override
    public IObjectFilter<Quantity> getQuantityFilter() {
        return new QuantityUtil.TypeFilter(1, QuantityType.SOLID);
    }

    public Set<Surface> getSurfaces() {
        return Collections.unmodifiableSet(this.d_surfaces);
    }

    public void setSurfaces(Collection<Surface> collection) {
        this.d_surfaces.clear();
        this.d_surfaces.addAll(collection);
        this.changedEvt(new Object[0]);
    }

    @Override
    public void takeDepSnapshot(DepList depList) {
        super.takeDepSnapshot(depList);
        depList.add(DLink.WEAK, this.d_surfaces);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T t, Set<T> set) {
        super.removeInvalidReplacements(t, set);
    }

    @Override
    public Task taskReplaceDep(IPyroObject iPyroObject, IPyroObject iPyroObject2) {
        if (iPyroObject instanceof Surface) {
            return new SetReplacementTask<Surface>(this, this.d_surfaces, iPyroObject, iPyroObject2);
        }
        return super.taskReplaceDep(iPyroObject, iPyroObject2);
    }
}

