/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.output;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Set;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.APyroObject;
import pyrosim.legacy_2012_1.domain.IPyroGeomSrc;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.dependencies.DLink;
import pyrosim.legacy_2012_1.domain.dependencies.DepList;
import pyrosim.legacy_2012_1.domain.dependencies.IDirectDependent;
import pyrosim.legacy_2012_1.domain.quantity.IQuantity;
import pyrosim.legacy_2012_1.domain.quantity.QuantityReplacer;
import pyrosim.legacy_2012_1.domain.quantity.QuantityUtil;
import pyrosim.legacy_2012_1.domain.tasks.AReplaceRefTask;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.ConvexHull;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.EmptyGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.ITest;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.DisplayGeom;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IDisplayProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPrimProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IBoxCollector;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectCollector;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;

public class Slice
extends APyroObject
implements IPyroGeomSrc,
IDirectDependent {
    static final long serialVersionUID = 1L;
    private IQuantity d_measurement;
    private boolean d_includeFlowVector;
    private boolean d_visible;
    private static final Color s_color = new Color(Color.PINK.getRed(), Color.PINK.getGreen(), Color.pink.getBlue(), 150);

    public Slice(IQuantity iQuantity, boolean bl) {
        this.d_measurement = iQuantity;
        this.d_includeFlowVector = bl;
        this.d_visible = true;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.d_visible = true;
        objectInputStream.defaultReadObject();
    }

    @Override
    public boolean isMixFracOnly() {
        return this.getQuantity().get().mixFracOnly;
    }

    public IQuantity getQuantity() {
        return this.d_measurement;
    }

    public void setQuantity(IQuantity iQuantity) {
        this.d_measurement = iQuantity;
        this.changedEvt(new Object[0]);
    }

    public boolean includeFlowVector() {
        return this.d_includeFlowVector;
    }

    public void setIncludeFlowVector(boolean bl) {
        if (this.d_includeFlowVector == bl) {
            return;
        }
        this.d_includeFlowVector = bl;
        this.changedEvt(new Object[0]);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Slice) {
            Slice slice = (Slice)object;
            return slice.d_includeFlowVector == this.d_includeFlowVector && slice.d_measurement.equals(this.d_measurement);
        }
        return false;
    }

    @Override
    public boolean isVisible() {
        return this.d_visible;
    }

    @Override
    public void setVisible(boolean bl) {
        if (this.d_visible == bl) {
            return;
        }
        this.d_visible = bl;
        this.changedEvt(PyroMod.EVT_VISIBILITY_CHANGED);
    }

    @Override
    public IGeom getGeom() {
        return EmptyGeom.INSTANCE;
    }

    @Override
    public void setGeom(IGeom iGeom, boolean bl) {
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps iDisplayProps) {
        return new DisplayGeom(this.getGeom(), (IPrimProps)new IPrimProps.Face(s_color, null, false));
    }

    @Override
    public void takeDepSnapshot(DepList depList) {
        QuantityUtil.takeDepSnapshot(depList, DLink.STRONG, this.getQuantity());
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T t, Set<T> set) {
        QuantReplacer quantReplacer = new QuantReplacer();
        quantReplacer.removeInvalidReplacements(t, set, this.getQuantity());
    }

    @Override
    public Task taskReplaceDep(IPyroObject iPyroObject, IPyroObject iPyroObject2) {
        QuantReplacer quantReplacer = new QuantReplacer();
        return quantReplacer.taskReplaceDep(iPyroObject, iPyroObject2, this.getQuantity());
    }

    @Override
    public AABox getBounds() {
        return this.getGeom().getBoundingBox(new AABox());
    }

    @Override
    public void getAll(IBoxCollector iBoxCollector, IIsectFilter iIsectFilter) {
        if (iIsectFilter.acceptPickObject(this)) {
            iBoxCollector.add(this);
        }
    }

    @Override
    public void pickBox(IBoxCollector iBoxCollector, IIsectFilter iIsectFilter, ConvexHull convexHull) {
        if (!iIsectFilter.acceptPickObject(this)) {
            return;
        }
        if (this.getGeom().intersectsBox(this, iIsectFilter, convexHull)) {
            iBoxCollector.add(this);
        }
    }

    @Override
    public void pickPoints(IIsectCollector iIsectCollector, IIsectFilter iIsectFilter, Point3d point3d, Point3d point3d2, Vector3d vector3d, ITest<AABox> iTest) {
        if (!iIsectFilter.acceptPickObject(this)) {
            return;
        }
        this.getGeom().pickPoints(iIsectCollector, iIsectFilter, this, point3d, point3d2, vector3d, iTest);
    }

    private class QuantReplacer
    extends QuantityReplacer {
        public QuantReplacer() {
            super((PyroMod)Slice.this.getDomain());
        }

        @Override
        protected Task taskReplaceQuant(IQuantity iQuantity, IQuantity iQuantity2) {
            assert (iQuantity2 != null);
            return new AReplaceRefTask<IQuantity>((Object)iQuantity, (Object)iQuantity2){

                @Override
                protected void set(IQuantity iQuantity) {
                    Slice.this.setQuantity(iQuantity);
                }
            };
        }
    }
}

