/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.output;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.LegacyDictionary_2012_1;
import pyrosim.legacy_2012_1.domain.Grid;
import pyrosim.legacy_2012_1.domain.output.Slice;
import pyrosim.legacy_2012_1.domain.quantity.IQuantity;
import pyrosim.legacy_2012_1.geom.Geometry;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.GeomConstants;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Plane3d;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.APlaneHandle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.IHandle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AARectangle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.GeomGroup;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IDOF;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPointOptimizer;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.PlanarSurface;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.Pair;

public class PlanarSlice
extends Slice {
    static final long serialVersionUID = 1L;
    public static final int X = 0;
    public static final int Y = 1;
    public static final int Z = 2;
    private int d_plane;
    private UnitDouble d_location;

    public PlanarSlice(int n, UnitDouble unitDouble, IQuantity iQuantity, boolean bl) {
        super(iQuantity, bl);
        this.d_plane = n;
        this.d_location = unitDouble;
    }

    public PlanarSlice(SliceGeom sliceGeom, IQuantity iQuantity, boolean bl) {
        this(sliceGeom.plane, new UnitDouble(sliceGeom.loc, Geometry.LU), iQuantity, bl);
    }

    public PlanarSlice(PlanarSurface planarSurface, IQuantity iQuantity, boolean bl) {
        super(iQuantity, bl);
        Pair<Integer, UnitDouble> pair = PlanarSlice.convert(planarSurface.plane);
        this.d_plane = (Integer)pair.v1;
        this.d_location = (UnitDouble)pair.v2;
    }

    public int getPlane() {
        return this.d_plane;
    }

    public UnitDouble getLocation() {
        return this.d_location;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof PlanarSlice) {
            PlanarSlice planarSlice = (PlanarSlice)object;
            return super.equals(planarSlice) && this.d_plane == planarSlice.d_plane && this.d_location.equals(planarSlice.d_location);
        }
        return false;
    }

    @Override
    public AABox getBounds() {
        return new AABox(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    private static Pair<Integer, UnitDouble> convert(Plane3d plane3d) {
        int n;
        Vector3d vector3d;
        Vector3d vector3d2 = plane3d.getNormal();
        int n2 = Util3D.getClosestAxis(vector3d2);
        switch (n2) {
            case 0: {
                vector3d = GeomConstants.VEC3D_XPOS;
                n = 0;
                break;
            }
            case 1: {
                vector3d = GeomConstants.VEC3D_YPOS;
                n = 1;
                break;
            }
            default: {
                vector3d = GeomConstants.VEC3D_ZPOS;
                n = 2;
            }
        }
        double d = vector3d.dot(vector3d2) < 0.0 ? plane3d.w : -plane3d.w;
        return new Pair<Integer, UnitDouble>(n, new UnitDouble(d, Geometry.LU));
    }

    private static Plane3d convert(int n, double d) {
        switch (n) {
            case 0: {
                return new Plane3d(1.0, 0.0, 0.0, -d);
            }
            case 1: {
                return new Plane3d(0.0, 1.0, 0.0, -d);
            }
        }
        return new Plane3d(0.0, 0.0, 1.0, -d);
    }

    @Override
    public void setGeom(IGeom iGeom, boolean bl) {
        if ((iGeom = Geometry.finalize(iGeom, bl)) instanceof SliceGeom) {
            SliceGeom sliceGeom = (SliceGeom)iGeom;
            this.d_plane = sliceGeom.plane;
            this.d_location = new UnitDouble(sliceGeom.loc, Geometry.LU);
            this.changedEvt(new Object[0]);
        } else if (iGeom instanceof PlanarSurface) {
            PlanarSurface planarSurface = (PlanarSurface)iGeom;
            Pair<Integer, UnitDouble> pair = PlanarSlice.convert(planarSurface.plane);
            this.d_plane = (Integer)pair.v1;
            this.d_location = (UnitDouble)pair.v2;
            this.changedEvt(new Object[0]);
        }
    }

    public static class SliceGeom
    extends GeomGroup {
        private static final long serialVersionUID = -5217337990260872179L;
        public final Collection<? extends Grid> grids;
        public final int plane;
        public final double loc;

        public SliceGeom(int n, double d, Collection<? extends Grid> collection) {
            this(SliceGeom.getQuads(n, d, collection), n, d, collection);
        }

        private SliceGeom(List<? extends IGeom> list, int n, double d, Collection<? extends Grid> collection) {
            super(list);
            this.plane = n;
            this.loc = d;
            this.grids = collection;
        }

        @Override
        public Object fromLegacy(LegacyDictionary_2012_1 legacyDictionary_2012_1) {
            return super.fromLegacy(legacyDictionary_2012_1);
        }

        private static List<AARectangle> getQuads(int n, double d, Collection<? extends Grid> collection) {
            ArrayList<AARectangle> arrayList = new ArrayList<AARectangle>();
            for (Grid grid : collection) {
                AABox aABox = grid.getGeom().getBoundingBox(new AABox());
                switch (n) {
                    case 0: {
                        if (!(aABox.getMinX() <= d) || !(d <= aABox.getMaxX())) break;
                        arrayList.add(new AARectangle(0, d, aABox.getMinY(), aABox.getMinZ(), aABox.getMaxY(), aABox.getMaxZ()));
                        break;
                    }
                    case 1: {
                        if (!(aABox.getMinY() <= d) || !(d <= aABox.getMaxY())) break;
                        arrayList.add(new AARectangle(1, d, aABox.getMinX(), aABox.getMinZ(), aABox.getMaxX(), aABox.getMaxZ()));
                        break;
                    }
                    case 2: {
                        if (!(aABox.getMinZ() <= d) || !(d <= aABox.getMaxZ())) break;
                        arrayList.add(new AARectangle(2, d, aABox.getMinX(), aABox.getMinY(), aABox.getMaxX(), aABox.getMaxY()));
                    }
                }
            }
            return arrayList;
        }

        @Override
        public GeomGroup optimize(IPointOptimizer iPointOptimizer) {
            GeomGroup geomGroup = super.optimize(iPointOptimizer);
            return geomGroup == this ? this : new SliceGeom(geomGroup.children, this.plane, this.loc, this.grids);
        }

        @Override
        public IDOF getDOF() {
            return IDOF.ALIGNED;
        }

        @Override
        public IGeom transform(Matrix4d matrix4d, IGeom.XformOp xformOp) {
            Plane3d plane3d;
            switch (this.plane) {
                case 0: {
                    plane3d = new Plane3d(1.0, 0.0, 0.0, -this.loc);
                    break;
                }
                case 1: {
                    plane3d = new Plane3d(0.0, 1.0, 0.0, -this.loc);
                    break;
                }
                case 2: {
                    plane3d = new Plane3d(0.0, 0.0, 1.0, -this.loc);
                    break;
                }
                default: {
                    assert (false);
                    plane3d = null;
                }
            }
            plane3d = plane3d.transformBy(matrix4d);
            Point3d point3d = new Point3d(-plane3d.x * plane3d.w, -plane3d.y * plane3d.w, -plane3d.z * plane3d.w);
            Vector3d vector3d = plane3d.getNormal();
            int n = Util.getClosestAxis(vector3d);
            switch (n) {
                case 0: {
                    return new SliceGeom(0, point3d.x, this.grids);
                }
                case 1: {
                    return new SliceGeom(1, point3d.y, this.grids);
                }
                case 2: {
                    return new SliceGeom(2, point3d.z, this.grids);
                }
            }
            return this;
        }

        @Override
        public Collection<? extends IHandle> generateManipHandles() {
            return Arrays.asList(new Handle(this));
        }

        private static class Handle
        extends APlaneHandle<SliceGeom> {
            public Handle(SliceGeom sliceGeom) {
                super(sliceGeom);
            }

            @Override
            public boolean equals(Object object) {
                return super.equals(object) && object instanceof Handle;
            }

            @Override
            public IGeom getGeom() {
                return (IGeom)this.getManipGeom();
            }

            @Override
            protected Vector3d getPlaneNormal(SliceGeom sliceGeom) {
                switch (sliceGeom.plane) {
                    case 0: {
                        return GeomConstants.VEC3D_XPOS;
                    }
                    case 1: {
                        return GeomConstants.VEC3D_YPOS;
                    }
                    case 2: {
                        return GeomConstants.VEC3D_ZPOS;
                    }
                }
                return null;
            }

            @Override
            protected SliceGeom modify(SliceGeom sliceGeom, double d) {
                return new SliceGeom(sliceGeom.plane, sliceGeom.loc + d, sliceGeom.grids);
            }
        }
    }
}

