/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.output;

import java.util.List;
import java.util.Vector;
import junit.framework.TestCase;
import org.jscience.physics.units.Unit;
import pyrosim.PyroSim;
import pyrosim.legacy_2012_1.domain.output.Isosurface;
import pyrosim.legacy_2012_1.domain.quantity.IQuantity;
import pyrosim.legacy_2012_1.domain.quantity.Quantity;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.unitsystem.SIUS;

public class IsosurfaceTest
extends TestCase {
    private Isosurface d_isofRec1;
    private Isosurface d_isofRec2;
    private Vector d_v1;
    private Vector d_v2;
    private Vector d_v3a;
    private Vector d_v3b;
    private Vector d_v4a;
    private Vector d_v4b;
    private Unit d_densityUnit;
    private Unit d_tempUnit;
    private Unit d_timeUnit;

    public IsosurfaceTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.d_densityUnit = SIUS.getInstance().getDensityUnit();
        this.d_tempUnit = SIUS.getInstance().getTempUnit();
        this.d_timeUnit = SIUS.getInstance().getTimeUnit();
        double d = 1.0;
        double d2 = 2.0;
        this.d_v1 = new Vector();
        this.d_v1.add(new UnitDouble(d, this.d_densityUnit));
        this.d_v1.add(new UnitDouble(d2, this.d_densityUnit));
        this.d_isofRec1 = new Isosurface((IQuantity)Quantity.DENSITY.create(), this.d_v1);
        this.d_v2 = new Vector();
        this.d_v2.add(new UnitDouble(d, this.d_tempUnit));
        this.d_v2.add(new UnitDouble(d2, this.d_tempUnit));
        this.d_isofRec2 = new Isosurface((IQuantity)Quantity.TEMPERATURE.create(), this.d_v2);
        this.d_v3a = new Vector();
        this.d_v3a.add(new UnitDouble(d2, this.d_densityUnit));
        this.d_v3a.add(new UnitDouble(d, this.d_densityUnit));
        this.d_v3b = new Vector();
        this.d_v3b.add(new UnitDouble(d, this.d_tempUnit));
        this.d_v3b.add(new UnitDouble(d2, this.d_tempUnit));
        this.d_v4a = new Vector();
        this.d_v4a.add(new UnitDouble(d2, this.d_tempUnit));
        this.d_v4a.add(new UnitDouble(d, this.d_tempUnit));
        this.d_v4b = new Vector();
        this.d_v4b.add(new UnitDouble(d, this.d_densityUnit));
        this.d_v4b.add(new UnitDouble(d2, this.d_densityUnit));
    }

    public void testGetValuesAndQuantity() {
        List<UnitDouble> list = this.d_isofRec1.getContours();
        IsosurfaceTest.assertEquals((Object)this.d_v1, list);
        list = this.d_isofRec2.getContours();
        IsosurfaceTest.assertEquals((Object)this.d_v2, list);
        IQuantity iQuantity = this.d_isofRec1.getQuantity();
        IsosurfaceTest.assertEquals((Object)iQuantity, (Object)Quantity.DENSITY.create());
        IsosurfaceTest.assertEquals((int)this.d_isofRec1.getContours().size(), (int)2);
        IsosurfaceTest.assertEquals((int)this.d_isofRec2.getContours().size(), (int)2);
    }

    public void testEquals() {
        Isosurface isosurface = new Isosurface((IQuantity)Quantity.DENSITY.create(), this.d_v3a);
        IsosurfaceTest.assertFalse((boolean)isosurface.equals(this.d_isofRec1));
        isosurface = new Isosurface((IQuantity)Quantity.TEMPERATURE.create(), this.d_v4a);
        IsosurfaceTest.assertFalse((boolean)isosurface.equals(this.d_isofRec2));
        isosurface = new Isosurface((IQuantity)Quantity.DENSITY.create(), this.d_v3b);
        IsosurfaceTest.assertFalse((boolean)isosurface.equals(this.d_isofRec1));
        isosurface = new Isosurface((IQuantity)Quantity.TEMPERATURE.create(), this.d_v4b);
        IsosurfaceTest.assertFalse((boolean)isosurface.equals(this.d_isofRec2));
        isosurface = new Isosurface((IQuantity)Quantity.TEMPERATURE.create(), this.d_v1);
        IsosurfaceTest.assertFalse((boolean)isosurface.equals(this.d_isofRec1));
        isosurface = new Isosurface((IQuantity)Quantity.DENSITY.create(), this.d_v2);
        IsosurfaceTest.assertFalse((boolean)isosurface.equals(this.d_isofRec2));
        isosurface = new Isosurface((IQuantity)Quantity.DENSITY.create(), this.d_v1);
        IsosurfaceTest.assertTrue((boolean)isosurface.equals(this.d_isofRec1));
        isosurface = new Isosurface((IQuantity)Quantity.TEMPERATURE.create(), this.d_v2);
        IsosurfaceTest.assertTrue((boolean)isosurface.equals(this.d_isofRec2));
    }

    static {
        new PyroSim();
    }
}

