/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.output;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.APyroObject;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.dependencies.DLink;
import pyrosim.legacy_2012_1.domain.dependencies.DepList;
import pyrosim.legacy_2012_1.domain.dependencies.IDirectDependent;
import pyrosim.legacy_2012_1.domain.quantity.IQuantity;
import pyrosim.legacy_2012_1.domain.quantity.QuantityReplacer;
import pyrosim.legacy_2012_1.domain.quantity.QuantityUtil;
import pyrosim.legacy_2012_1.domain.quantity.VelocitySign;
import pyrosim.legacy_2012_1.domain.tasks.AReplaceRefTask;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class Isosurface
extends APyroObject
implements IDirectDependent {
    private static final long serialVersionUID = 1L;
    private IQuantity d_measurement;
    private List<UnitDouble> d_contours;
    private VelocitySign d_velocitySign;

    public Isosurface(IQuantity iQuantity, UnitDouble ... unitDoubleArray) {
        this(iQuantity, Arrays.asList(unitDoubleArray));
    }

    public Isosurface(IQuantity iQuantity, List<UnitDouble> list) {
        this.d_measurement = iQuantity;
        this.d_contours = list;
        this.d_velocitySign = VelocitySign.ALWAYS_POSITIVE;
    }

    @Override
    public boolean isMixFracOnly() {
        return this.getQuantity().get().mixFracOnly;
    }

    public void setQuantity(IQuantity iQuantity) {
        this.d_measurement = iQuantity;
        this.changedEvt(new Object[0]);
    }

    public IQuantity getQuantity() {
        return this.d_measurement;
    }

    public void setContours(List<UnitDouble> list) {
        this.d_contours = list;
        this.changedEvt(new Object[0]);
    }

    public List<UnitDouble> getContours() {
        return this.d_contours;
    }

    public VelocitySign getVelocitySign() {
        return this.d_velocitySign;
    }

    public void setVelocitySign(VelocitySign velocitySign) {
        this.d_velocitySign = velocitySign;
        this.changedEvt(new Object[0]);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Isosurface) {
            Isosurface isosurface = (Isosurface)object;
            return this.d_measurement.equals(isosurface.d_measurement) && this.d_contours.equals(isosurface.d_contours) && theUtil.equal((Object)this.d_velocitySign, (Object)isosurface.d_velocitySign);
        }
        return false;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.d_velocitySign == null) {
            this.d_velocitySign = VelocitySign.ALWAYS_POSITIVE;
        }
    }

    @Override
    public void takeDepSnapshot(DepList depList) {
        QuantityUtil.takeDepSnapshot(depList, DLink.STRONG, this.getQuantity());
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T t, Set<T> set) {
        QuantReplacer quantReplacer = new QuantReplacer();
        quantReplacer.removeInvalidReplacements(t, set, this.getQuantity());
    }

    @Override
    public Task taskReplaceDep(IPyroObject iPyroObject, IPyroObject iPyroObject2) {
        QuantReplacer quantReplacer = new QuantReplacer();
        return quantReplacer.taskReplaceDep(iPyroObject, iPyroObject2, this.getQuantity());
    }

    private class QuantReplacer
    extends QuantityReplacer {
        public QuantReplacer() {
            super((PyroMod)Isosurface.this.getDomain());
        }

        @Override
        protected boolean canReplaceQuant(IQuantity iQuantity, IQuantity iQuantity2) {
            return iQuantity.get().unitType == iQuantity2.get().unitType && QuantityUtil.canOutputAll(iQuantity2.get(), 32);
        }

        @Override
        protected Task taskReplaceQuant(IQuantity iQuantity, IQuantity iQuantity2) {
            assert (iQuantity2 != null);
            return new AReplaceRefTask<IQuantity>((Object)iQuantity, (Object)iQuantity2){

                @Override
                protected void set(IQuantity iQuantity) {
                    Isosurface.this.setQuantity(iQuantity);
                }
            };
        }
    }
}

