/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.output;

import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.domain.output.AMsrStat;
import pyrosim.legacy_2012_1.LegacyDictionary_2012_1;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.Grid;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.NamedPyroObject;
import pyrosim.legacy_2012_1.domain.dependencies.DLink;
import pyrosim.legacy_2012_1.domain.dependencies.DepList;
import pyrosim.legacy_2012_1.domain.dependencies.IDirectDependent;
import pyrosim.legacy_2012_1.domain.output.IMeasurementStat;
import pyrosim.legacy_2012_1.domain.output.StatGeom;
import pyrosim.legacy_2012_1.domain.quantity.IQuantity;
import pyrosim.legacy_2012_1.domain.quantity.Quantity;
import pyrosim.legacy_2012_1.domain.quantity.QuantityReplacer;
import pyrosim.legacy_2012_1.domain.quantity.QuantityUtil;
import pyrosim.legacy_2012_1.domain.tasks.AReplaceRefTask;
import pyrosim.legacy_2012_1.geom.Geometry;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.ConvexHull;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AABoxGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AARectangle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.BlockGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IDOF;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Point;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.ITest;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.DisplayGeom;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IDisplayProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPrimProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IBoxCollector;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectCollector;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.util.EmptyTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObjectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;
import pyrosim.legacy_2012_1.util.Util;

public abstract class AMsrStat
extends NamedPyroObject
implements IMeasurementStat,
IDirectDependent {
    static final long serialVersionUID = 1L;
    private IQuantity d_msr;
    private Set<Integer> d_stats;
    private IGeom d_geom;
    private boolean d_visible;
    private static final Color s_boxColor = new Color(0.2f, 0.2f, 1.0f, 0.3f);
    private static final Color s_pointColor = new Color(0.2f, 0.2f, 1.0f, 1.0f);

    public abstract IObjectFilter<Quantity> getQuantityFilter();

    public AMsrStat(String string, IQuantity iQuantity, Collection<Integer> collection, IGeom iGeom) {
        super(string);
        this.d_msr = iQuantity;
        this.d_stats = new HashSet<Integer>(collection);
        assert (AMsrStat.isValidGeom(iGeom));
        this.d_geom = iGeom;
        this.d_visible = true;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AMsrStat)) {
            return false;
        }
        AMsrStat aMsrStat = (AMsrStat)object;
        return this.d_msr.equals(aMsrStat.d_msr) && this.d_stats.equals(aMsrStat.d_stats) && this.d_geom.equals(aMsrStat.d_geom);
    }

    @Override
    public Object clone() {
        AMsrStat aMsrStat = (AMsrStat)super.clone();
        aMsrStat.d_stats = new HashSet<Integer>(this.d_stats);
        return aMsrStat;
    }

    @Override
    public void setVisible(boolean bl) {
        if (this.d_visible == bl) {
            return;
        }
        this.d_visible = bl;
        this.changedEvt(PyroMod.EVT_VISIBILITY_CHANGED);
    }

    @Override
    public boolean isVisible() {
        return this.d_visible;
    }

    @Override
    public IQuantity getQuantity() {
        return this.d_msr;
    }

    @Override
    public void setStats(Collection<Integer> collection) {
        this.d_stats.clear();
        this.d_stats.addAll(collection);
        this.changedEvt(new Object[0]);
    }

    @Override
    public Set<Integer> getStats() {
        return Collections.unmodifiableSet(this.d_stats);
    }

    public static boolean isValidGeom(IGeom iGeom) {
        return iGeom instanceof Point || iGeom instanceof AABoxGeom || iGeom instanceof AARectangle || iGeom instanceof StatGeom.GridGeom;
    }

    @Override
    public IGeom getGeom() {
        if (this.d_geom instanceof BlockGeom) {
            return this.d_geom;
        }
        if (this.d_geom instanceof AABoxGeom) {
            AABoxGeom aABoxGeom = (AABoxGeom)this.d_geom;
            return new BlockGeom(aABoxGeom.min, aABoxGeom.max, aABoxGeom.swizzle);
        }
        if (this.d_geom instanceof RestrictedRect) {
            return this.d_geom;
        }
        if (this.d_geom instanceof AARectangle) {
            return new RestrictedRect((AARectangle)this.d_geom);
        }
        return this.d_geom;
    }

    @Override
    public void setGeom(IGeom iGeom, boolean bl) {
        if (AMsrStat.isValidGeom(iGeom = Geometry.finalize(iGeom, bl))) {
            this.d_geom = iGeom;
            this.changedEvt(new Object[0]);
        }
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps iDisplayProps) {
        Color color = this.d_geom instanceof Point ? s_pointColor : s_boxColor;
        IPrimProps.AProps aProps = this.d_geom instanceof Point ? new IPrimProps.Vertex(color, 10.0) : new IPrimProps.Face(color, null, true);
        return new DisplayGeom(this.d_geom, (IPrimProps)aProps);
    }

    @Override
    public void takeDepSnapshot(DepList depList) {
        QuantityUtil.takeDepSnapshot(depList, DLink.STRONG, this.d_msr);
        if (this.d_geom instanceof StatGeom.GridGeom) {
            depList.add(DLink.STRONG, (IPyroObject)((StatGeom.GridGeom)this.d_geom).grid);
        }
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T t, Set<T> set) {
        if (QuantityUtil.isQuantityRef(t, this.d_msr)) {
            Util.removeNonNull(set);
        }
    }

    @Override
    public Task taskReplaceDep(IPyroObject iPyroObject, IPyroObject iPyroObject2) {
        if (QuantityUtil.isQuantityRef(iPyroObject, this.d_msr)) {
            assert (iPyroObject.equals(iPyroObject2));
            QuantReplacer quantReplacer = new QuantReplacer();
            return quantReplacer.taskReplaceDep(iPyroObject, iPyroObject2, this.d_msr);
        }
        if (iPyroObject instanceof Grid) {
            assert (iPyroObject2 != null);
            return new AReplaceRefTask<Grid>((Object)iPyroObject, (Object)iPyroObject2){

                @Override
                protected void set(Grid grid) {
                    AMsrStat.this.setGeom(new StatGeom.GridGeom(grid), true);
                }
            };
        }
        return EmptyTask.INSTANCE;
    }

    @Override
    public boolean isMixFracOnly() {
        return this.d_msr.get().mixFracOnly;
    }

    @Override
    public AABox getBounds() {
        return this.getGeom().getBoundingBox(new AABox());
    }

    @Override
    public void getAll(IBoxCollector iBoxCollector, IIsectFilter iIsectFilter) {
        if (iIsectFilter.acceptPickObject(this)) {
            iBoxCollector.add(this);
        }
    }

    @Override
    public void pickBox(IBoxCollector iBoxCollector, IIsectFilter iIsectFilter, ConvexHull convexHull) {
        if (!iIsectFilter.acceptPickObject(this)) {
            return;
        }
        if (this.getGeom().intersectsBox(this, iIsectFilter, convexHull)) {
            iBoxCollector.add(this);
        }
    }

    @Override
    public void pickPoints(IIsectCollector iIsectCollector, IIsectFilter iIsectFilter, Point3d point3d, Point3d point3d2, Vector3d vector3d, ITest<AABox> iTest) {
        if (!iIsectFilter.acceptPickObject(this)) {
            return;
        }
        this.getGeom().pickPoints(iIsectCollector, iIsectFilter, this, point3d, point3d2, vector3d, iTest);
    }

    protected class QuantReplacer
    extends QuantityReplacer {
        public QuantReplacer() {
            super((PyroMod)AMsrStat.this.getDomain());
        }

        @Override
        protected boolean canReplaceQuant(IQuantity iQuantity, IQuantity iQuantity2) {
            return iQuantity.equals(iQuantity2);
        }

        @Override
        protected Task taskReplaceQuant(IQuantity iQuantity, IQuantity iQuantity2) {
            assert (iQuantity2 != null);
            return new AReplaceRefTask<IQuantity>((Object)AMsrStat.this.d_msr, (Object)iQuantity2){

                @Override
                protected void set(IQuantity iQuantity) {
                    AMsrStat.this.d_msr = iQuantity;
                    AMsrStat.this.changedEvt(new Object[0]);
                }
            };
        }
    }

    private static class RestrictedRect
    extends AARectangle {
        static final long serialVersionUID = 1L;

        public RestrictedRect(AARectangle aARectangle) {
            super(aARectangle.d_plane, aARectangle.d_planeVal, aARectangle.d_minx, aARectangle.d_miny, aARectangle.d_maxx, aARectangle.d_maxy);
        }

        @Override
        public AMsrStat.RestrictedRect fromLegacy(LegacyDictionary_2012_1 legacyDictionary_2012_1) {
            return new AMsrStat.RestrictedRect(super.fromLegacy(legacyDictionary_2012_1));
        }

        @Override
        public IDOF getDOF() {
            return IDOF.ALIGNED;
        }
    }
}

