/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.output;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.APyroObject;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.dependencies.DLink;
import pyrosim.legacy_2012_1.domain.dependencies.DepList;
import pyrosim.legacy_2012_1.domain.dependencies.IDirectDependent;
import pyrosim.legacy_2012_1.domain.output.Plot3d;
import pyrosim.legacy_2012_1.domain.quantity.IQuantity;
import pyrosim.legacy_2012_1.domain.quantity.QuantityReplacer;
import pyrosim.legacy_2012_1.domain.quantity.QuantityUtil;
import pyrosim.legacy_2012_1.domain.quantity.VelocitySign;
import pyrosim.legacy_2012_1.thunderheadeng.util.AUndoableTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;

public abstract class AMeasurementSet
extends APyroObject
implements IDirectDependent {
    static final long serialVersionUID = 1L;
    private final Set<IQuantity> d_measurements = new LinkedHashSet<IQuantity>();
    private VelocitySign d_velocitySign;

    public AMeasurementSet(IQuantity ... iQuantityArray) {
        this.setQuantities(iQuantityArray);
        this.d_velocitySign = VelocitySign.ALWAYS_POSITIVE;
    }

    public VelocitySign getVelocitySign() {
        return this.d_velocitySign;
    }

    public void setVelocitySign(VelocitySign velocitySign) {
        this.d_velocitySign = velocitySign;
        this.changedEvt(new Object[0]);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.d_velocitySign == null) {
            this.d_velocitySign = VelocitySign.ALWAYS_POSITIVE;
        }
    }

    public abstract int getOutputType();

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Plot3d)) {
            return false;
        }
        AMeasurementSet aMeasurementSet = (AMeasurementSet)object;
        return aMeasurementSet.d_measurements.equals(this.d_measurements);
    }

    public void setQuantities(IQuantity ... iQuantityArray) {
        this.setQuantities(Arrays.asList(iQuantityArray));
    }

    public void setQuantities(Collection<IQuantity> collection) {
        this.d_measurements.clear();
        this.d_measurements.addAll(collection);
        this.changedEvt(new Object[0]);
    }

    public Set<IQuantity> getQuantities() {
        return Collections.unmodifiableSet(this.d_measurements);
    }

    @Override
    public boolean isEnabled() {
        return !this.d_measurements.isEmpty();
    }

    @Override
    public void takeDepSnapshot(DepList depList) {
        QuantityUtil.takeDepSnapshot(depList, DLink.WEAK, this.d_measurements);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T t, Set<T> set) {
        QuantReplacer quantReplacer = new QuantReplacer();
        quantReplacer.removeInvalidReplacements(t, set, this.d_measurements);
    }

    @Override
    public Task taskReplaceDep(IPyroObject iPyroObject, IPyroObject iPyroObject2) {
        QuantReplacer quantReplacer = new QuantReplacer();
        return quantReplacer.taskReplaceDep(iPyroObject, iPyroObject2, this.d_measurements);
    }

    @Override
    public boolean isMixFracOnly() {
        for (IQuantity iQuantity : this.d_measurements) {
            if (!iQuantity.get().mixFracOnly) continue;
            return true;
        }
        return false;
    }

    private class QuantReplacer
    extends QuantityReplacer {
        public QuantReplacer() {
            super((PyroMod)AMeasurementSet.this.getDomain());
        }

        @Override
        protected boolean canReplaceQuant(IQuantity iQuantity, IQuantity iQuantity2) {
            return QuantityUtil.canOutputAll(iQuantity2.get(), AMeasurementSet.this.getOutputType());
        }

        @Override
        protected Task taskReplaceQuant(final IQuantity iQuantity, final IQuantity iQuantity2) {
            return new AUndoableTask(){
                boolean d_added;

                @Override
                public void undo() {
                    if (this.d_added) {
                        AMeasurementSet.this.d_measurements.remove(iQuantity2);
                    }
                    AMeasurementSet.this.d_measurements.add(iQuantity);
                    AMeasurementSet.this.changedEvt(new Object[0]);
                }

                @Override
                public void run() {
                    AMeasurementSet.this.d_measurements.remove(iQuantity);
                    if (iQuantity2 != null) {
                        this.d_added = AMeasurementSet.this.d_measurements.add(iQuantity2);
                    }
                    AMeasurementSet.this.changedEvt(new Object[0]);
                }
            };
        }
    }
}

