/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.hvac;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.dependencies.DepList;
import pyrosim.legacy_2012_1.domain.geom.Vent;
import pyrosim.legacy_2012_1.domain.hvac.HvacComponent;
import pyrosim.legacy_2012_1.domain.hvac.HvacDuct;
import pyrosim.legacy_2012_1.domain.hvac.HvacFilter;
import pyrosim.legacy_2012_1.domain.tasks.AReplaceRefTask;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.Pair;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;
import pyrosim.legacy_2012_1.util.Util;

public class HvacNode
extends HvacComponent {
    private static final long serialVersionUID = 1414663300556603303L;
    public static final String OPT_VENT_XYZ = "opt_vent_xyz";
    private Map<Pair<HvacDuct, HvacDuct>, UnitDouble> d_losses;

    public HvacNode(String string) {
        super(string);
        HvacNode.setDefaults(this);
        this.d_losses = new HashMap<Pair<HvacDuct, HvacDuct>, UnitDouble>();
    }

    @Override
    public HvacNode clone() {
        HvacNode hvacNode = (HvacNode)super.clone();
        hvacNode.d_losses = new HashMap<Pair<HvacDuct, HvacDuct>, UnitDouble>(this.d_losses);
        return hvacNode;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.d_losses == null) {
            this.d_losses = new HashMap<Pair<HvacDuct, HvacDuct>, UnitDouble>();
        }
    }

    public static void setDefaults(HvacComponent hvacComponent) {
        hvacComponent.setProp("TYPE_ID", "NODE");
        hvacComponent.setProp("AMBIENT", false);
        hvacComponent.setProp("FILTER_ID", null);
        hvacComponent.setProp("LOSS", Collections.EMPTY_LIST);
        hvacComponent.setProp("VENT_ID", null);
        hvacComponent.setProp("XYZ", null);
        hvacComponent.setProp(OPT_VENT_XYZ, "XYZ");
        hvacComponent.setProp("DUCT_ID", Collections.EMPTY_LIST);
    }

    @Override
    public void takeDepSnapshot(DepList depList) {
        this.addDep(depList, "VENT_ID");
        this.addDep(depList, "FILTER_ID");
        this.addDep(depList, "DUCT_ID");
    }

    private void setVent(Vent vent) {
        this.setProp("VENT_ID", vent);
        this.changedEvt(new Object[0]);
    }

    private void setFilter(HvacFilter hvacFilter) {
        this.setProp("FILTER_ID", hvacFilter);
        this.changedEvt(new Object[0]);
    }

    private void setDuct(HvacDuct hvacDuct) {
        this.addDuct(hvacDuct);
        this.changedEvt(new Object[0]);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T t, Set<T> set) {
        if (t instanceof Vent) {
            Util.removeAllNotOfType(set, Vent.class);
        } else if (t instanceof HvacFilter) {
            Util.removeAllNotOfType(set, HvacFilter.class);
        } else if (t instanceof HvacDuct) {
            Util.removeAllNotOfType(set, HvacDuct.class);
        }
    }

    @Override
    public Task taskReplaceDep(IPyroObject iPyroObject, IPyroObject iPyroObject2) {
        if (iPyroObject instanceof Vent) {
            return new AReplaceRefTask<Vent>((Object)iPyroObject, (Object)iPyroObject2){

                @Override
                protected void set(Vent vent) {
                    HvacNode.this.setVent(vent);
                }
            };
        }
        if (iPyroObject instanceof HvacFilter) {
            return new AReplaceRefTask<HvacFilter>((Object)iPyroObject, (Object)iPyroObject2){

                @Override
                protected void set(HvacFilter hvacFilter) {
                    HvacNode.this.setFilter(hvacFilter);
                }
            };
        }
        if (iPyroObject instanceof HvacDuct) {
            return new AReplaceRefTask<HvacDuct>((Object)iPyroObject, (Object)iPyroObject2){

                @Override
                protected void set(HvacDuct hvacDuct) {
                    HvacNode.this.setDuct(hvacDuct);
                }
            };
        }
        return super.taskReplaceDep(iPyroObject, iPyroObject2);
    }

    public void addDuct(HvacDuct hvacDuct) {
        if (hvacDuct == null) {
            return;
        }
        ArrayList<HvacDuct> arrayList = new ArrayList<HvacDuct>((Collection)this.getProp("DUCT_ID"));
        if (!arrayList.contains(hvacDuct)) {
            arrayList.add(hvacDuct);
            this.setProp("DUCT_ID", arrayList);
        }
    }

    public void removeDuct(HvacDuct hvacDuct) {
        if (hvacDuct == null) {
            return;
        }
        List list = (List)this.getProp("DUCT_ID");
        if (list.contains(hvacDuct)) {
            list.remove(hvacDuct);
            this.setProp("DUCT_ID", list);
        }
    }

    public boolean isAttachedToDuct(HvacDuct hvacDuct) {
        List list = (List)this.getProp("DUCT_ID");
        return list.contains(hvacDuct);
    }

    public int getNumDucts() {
        return ((List)this.getProp("DUCT_ID")).size();
    }

    public boolean isInterior() {
        return (Boolean)this.getProp("AMBIENT") == false;
    }

    public Map<Pair<HvacDuct, HvacDuct>, UnitDouble> getLossMap() {
        return this.d_losses;
    }

    public void setLossMap(Map<Pair<HvacDuct, HvacDuct>, UnitDouble> map) {
        this.d_losses = map;
    }

    public List<UnitDouble> getLossList(boolean bl) {
        ArrayList<UnitDouble> arrayList = new ArrayList<UnitDouble>();
        List list = (List)this.getProp("DUCT_ID");
        for (HvacDuct hvacDuct : list) {
            for (HvacDuct hvacDuct2 : list) {
                Pair<HvacDuct, HvacDuct> pair = new Pair<HvacDuct, HvacDuct>(hvacDuct, hvacDuct2);
                UnitDouble unitDouble = this.d_losses.get(pair);
                if (bl && unitDouble != null && theUtil.eq0(unitDouble.getValue(Unit.ONE), 1.0E-9)) {
                    unitDouble = null;
                }
                arrayList.add(this.d_losses.get(pair));
            }
        }
        assert (arrayList.size() == this.getNumDucts() * this.getNumDucts());
        return arrayList;
    }
}

