/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.hvac;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2012_1.domain.ExSpec;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.TimeFunction;
import pyrosim.legacy_2012_1.domain.dependencies.DepList;
import pyrosim.legacy_2012_1.domain.hvac.HvacComponent;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.AUndoableTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;
import pyrosim.legacy_2012_1.util.Util;

public class HvacFilter
extends HvacComponent {
    private static final long serialVersionUID = 1L;
    public static final String OPT_LOSS_RAMP = "opt_loss_ramp";
    public TimeFunction d_func;

    public HvacFilter(String string) {
        super(string);
        HvacFilter.setDefaults(this);
        this.d_func = TimeFunction.newDefault();
    }

    public static void setDefaults(HvacComponent hvacComponent) {
        hvacComponent.setProp("TYPE_ID", "FILTER");
        hvacComponent.setProp("CLEAN_LOSS", new UnitDouble(0.0, Unit.ONE));
        hvacComponent.setProp("EFFICIENCY", new UnitDouble(0.0, Unit.ONE));
        hvacComponent.setProp("LOADING", Collections.EMPTY_LIST);
        hvacComponent.setProp("LOADING_MULTIPLIER", Collections.EMPTY_LIST);
        hvacComponent.setProp("SPEC_ID", Collections.EMPTY_LIST);
        hvacComponent.setProp("LOSS", Collections.EMPTY_LIST);
        hvacComponent.setProp("RAMP_ID", null);
        hvacComponent.setProp(OPT_LOSS_RAMP, "LOSS");
    }

    @Override
    public void takeDepSnapshot(DepList depList) {
        this.addDep(depList, "SPEC_ID");
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T t, Set<T> set) {
        if (t instanceof ExSpec) {
            Util.removeAllNotOfType(set, ExSpec.class);
            List list = (List)this.getProp("SPEC_ID");
            for (ExSpec exSpec : list) {
                if (!set.contains(exSpec)) continue;
                set.remove(exSpec);
            }
        }
    }

    @Override
    public Task taskReplaceDep(final IPyroObject iPyroObject, final IPyroObject iPyroObject2) {
        if (iPyroObject instanceof ExSpec) {
            return new AUndoableTask(){
                private ExSpec d_oldSpec;
                private ExSpec d_replSpec;

                @Override
                public void run() {
                    this.d_oldSpec = (ExSpec)iPyroObject;
                    this.d_replSpec = (ExSpec)iPyroObject2;
                    HvacFilter.this.setExSpec(this.d_oldSpec, this.d_replSpec);
                }

                @Override
                public void undo() {
                    ExSpec exSpec = this.d_oldSpec;
                    this.d_oldSpec = this.d_replSpec;
                    this.d_replSpec = exSpec;
                    HvacFilter.this.setExSpec(this.d_oldSpec, this.d_replSpec);
                }
            };
        }
        return super.taskReplaceDep(iPyroObject, iPyroObject2);
    }

    private void setExSpec(ExSpec exSpec, ExSpec exSpec2) {
        ArrayList<ExSpec> arrayList = new ArrayList<ExSpec>((Collection)this.getProp("SPEC_ID"));
        ArrayList<UnitDouble> arrayList2 = new ArrayList<UnitDouble>((Collection)this.getProp("LOADING"));
        ArrayList<UnitDouble> arrayList3 = new ArrayList<UnitDouble>((Collection)this.getProp("LOADING_MULTIPLIER"));
        int n = arrayList.indexOf(exSpec);
        if (n >= 0) {
            UnitDouble unitDouble = (UnitDouble)arrayList2.get(n);
            UnitDouble unitDouble2 = (UnitDouble)arrayList3.get(n);
            arrayList.remove(n);
            arrayList2.remove(n);
            arrayList3.remove(n);
            if (exSpec2 != null) {
                arrayList.add(exSpec2);
                arrayList2.add(unitDouble);
                arrayList3.add(unitDouble2);
            }
        }
        this.setProp("SPEC_ID", arrayList);
        this.setProp("LOADING", arrayList2);
        this.setProp("LOADING_MULTIPLIER", arrayList3);
        this.changedEvt(new Object[0]);
    }

    @Override
    public Object clone() {
        HvacFilter hvacFilter = (HvacFilter)super.clone();
        hvacFilter.d_func = (TimeFunction)this.d_func.clone();
        return hvacFilter;
    }
}

