/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.hvac;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.TimeFunction;
import pyrosim.legacy_2012_1.domain.dependencies.DepList;
import pyrosim.legacy_2012_1.domain.hvac.HvacAircoil;
import pyrosim.legacy_2012_1.domain.hvac.HvacComponent;
import pyrosim.legacy_2012_1.domain.hvac.HvacFan;
import pyrosim.legacy_2012_1.domain.hvac.HvacNode;
import pyrosim.legacy_2012_1.domain.signals.IInPin;
import pyrosim.legacy_2012_1.domain.signals.ISignalSink;
import pyrosim.legacy_2012_1.domain.signals.OneLogicInPin;
import pyrosim.legacy_2012_1.domain.tasks.AReplaceRefTask;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.AUndoableTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;
import pyrosim.legacy_2012_1.util.Util;

public class HvacDuct
extends HvacComponent
implements ISignalSink {
    private static final long serialVersionUID = -4887397052092333390L;
    public static final String OPT_AREA_DIAMETER = "opt_area_diameter";
    public static final String OPT_AIRFLOW = "opt_none_damper_fan";
    public static final String AIRFLOW_NONE = "airflow_none";
    public static final String AIRFLOW_DAMPER = "airflow_damper";
    public static final String AIRFLOW_FAN = "airflow_fan";
    public static final String USE_LENGTH = "use_length";
    public transient String d_n1;
    public transient String d_n2;
    public TimeFunction d_func;
    private IInPin d_inPin;

    public HvacDuct(String string) {
        super(string);
        HvacDuct.setDefaults(this);
        this.d_inPin = new OneLogicInPin(this);
        this.d_func = TimeFunction.newDefault();
    }

    private static void setDefaults(HvacComponent hvacComponent) {
        hvacComponent.setProp("TYPE_ID", "DUCT");
        hvacComponent.setProp("AIRCOIL_ID", null);
        hvacComponent.setProp("AREA", new UnitDouble(0.0, SI.METER.pow(2)));
        hvacComponent.setProp("DIAMETER", new UnitDouble(0.0, SI.METER));
        hvacComponent.setProp(OPT_AREA_DIAMETER, "AREA");
        hvacComponent.setProp(OPT_AIRFLOW, AIRFLOW_NONE);
        hvacComponent.setProp("DAMPER", false);
        hvacComponent.setProp("VOLUME_FLOW", new UnitDouble(0.0, SI.METER.pow(3).divide(SI.SECOND)));
        hvacComponent.setProp("FAN_ID", null);
        hvacComponent.setProp("LENGTH", new UnitDouble(0.0, SI.METER));
        hvacComponent.setProp(USE_LENGTH, false);
        hvacComponent.setProp("LOSS", Arrays.asList(new UnitDouble(0.0, Unit.ONE), new UnitDouble(0.0, Unit.ONE)));
        hvacComponent.setProp("NODE_ID", Arrays.asList(null, null));
        hvacComponent.setProp("REVERSE", false);
        hvacComponent.setProp("ROUGHNESS", null);
    }

    @Override
    public void takeDepSnapshot(DepList depList) {
        this.addDep(depList, "AIRCOIL_ID");
        this.addDep(depList, "FAN_ID");
        this.addDep(depList, "NODE_ID");
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T t, Set<T> set) {
        if (t instanceof HvacNode) {
            Util.removeAllNotOfType(set, HvacNode.class);
            List list = (List)this.getProp("NODE_ID");
            for (HvacNode hvacNode : list) {
                if (hvacNode == null || hvacNode == t) continue;
                set.remove(hvacNode);
            }
        } else if (t instanceof HvacAircoil) {
            Util.removeAllNotOfType(set, HvacAircoil.class);
        } else if (t instanceof HvacFan) {
            Util.removeAllNotOfType(set, HvacFan.class);
        }
    }

    @Override
    public Task taskReplaceDep(final IPyroObject iPyroObject, final IPyroObject iPyroObject2) {
        if (iPyroObject instanceof HvacNode) {
            return new AUndoableTask(){
                private HvacNode d_old;
                private HvacNode d_repl;

                @Override
                public void undo() {
                    HvacNode hvacNode = this.d_old;
                    this.d_old = this.d_repl;
                    this.d_repl = hvacNode;
                    HvacDuct.this.setNode(this.d_repl, this.d_old);
                }

                @Override
                public void run() {
                    this.d_old = (HvacNode)iPyroObject;
                    this.d_repl = (HvacNode)iPyroObject2;
                    HvacDuct.this.setNode(this.d_repl, this.d_old);
                }
            };
        }
        if (iPyroObject instanceof HvacAircoil) {
            return new AReplaceRefTask<HvacAircoil>((Object)iPyroObject, (Object)iPyroObject2){

                @Override
                protected void set(HvacAircoil hvacAircoil) {
                    HvacDuct.this.setAircoil(hvacAircoil);
                }
            };
        }
        if (iPyroObject instanceof HvacFan) {
            return new AReplaceRefTask<HvacFan>((Object)iPyroObject, (Object)iPyroObject2){

                @Override
                protected void set(HvacFan hvacFan) {
                    HvacDuct.this.setFan(hvacFan);
                }
            };
        }
        return super.taskReplaceDep(iPyroObject, iPyroObject2);
    }

    private void setAircoil(HvacAircoil hvacAircoil) {
        this.setProp("AIRCOIL_ID", hvacAircoil);
        this.changedEvt(new Object[0]);
    }

    private void setFan(HvacFan hvacFan) {
        this.setProp("FAN_ID", hvacFan);
        this.changedEvt(new Object[0]);
    }

    private void setNode(HvacNode hvacNode, HvacNode hvacNode2) {
        List list = (List)this.getProp("NODE_ID");
        ArrayList<HvacNode> arrayList = new ArrayList<HvacNode>();
        HvacNode hvacNode3 = (HvacNode)list.get(0);
        HvacNode hvacNode4 = (HvacNode)list.get(1);
        if (hvacNode3 != null && hvacNode3 == hvacNode2) {
            arrayList.add(hvacNode);
            arrayList.add(hvacNode4);
        } else if (hvacNode4 != null && hvacNode4 == hvacNode2) {
            arrayList.add(hvacNode3);
            arrayList.add(hvacNode);
        } else {
            arrayList.add(hvacNode3);
            arrayList.add(hvacNode4);
        }
        this.setProp("NODE_ID", arrayList);
        this.changedEvt(new Object[0]);
    }

    @Override
    public IInPin getInputPin() {
        return this.d_inPin;
    }

    @Override
    public Object clone() {
        HvacDuct hvacDuct = (HvacDuct)super.clone();
        hvacDuct.d_inPin = (IInPin)this.d_inPin.clone(hvacDuct);
        hvacDuct.d_func = (TimeFunction)this.d_func.clone();
        return hvacDuct;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof HvacDuct && super.equals(object) && this.d_inPin.equals(((HvacDuct)object).d_inPin);
    }

    public boolean isNodeAttached(HvacNode hvacNode) {
        List list = (List)this.getProp("NODE_ID");
        if (!list.isEmpty()) {
            return hvacNode.equals(list.get(0)) || hvacNode.equals(list.get(1));
        }
        return false;
    }
}

