/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.geom;

import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2012_1.domain.Composite;
import pyrosim.legacy_2012_1.domain.ExSpec;
import pyrosim.legacy_2012_1.domain.GeomUtil;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.TimeBasedValue;
import pyrosim.legacy_2012_1.domain.TimeFunction;
import pyrosim.legacy_2012_1.domain.boundcond.surf.BurnerSurfDesc;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Fuel;
import pyrosim.legacy_2012_1.domain.boundcond.surf.LayeredSurfDesc;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Surface;
import pyrosim.legacy_2012_1.domain.dependencies.DLink;
import pyrosim.legacy_2012_1.domain.dependencies.DepList;
import pyrosim.legacy_2012_1.domain.geom.AFDSObject;
import pyrosim.legacy_2012_1.domain.geom.FireSpread;
import pyrosim.legacy_2012_1.domain.geom.ISurfObj;
import pyrosim.legacy_2012_1.domain.geom.TexOrigin;
import pyrosim.legacy_2012_1.domain.rasterization.IFDSObjProps;
import pyrosim.legacy_2012_1.domain.tasks.AReplaceRefTask;
import pyrosim.legacy_2012_1.geom.Geometry;
import pyrosim.legacy_2012_1.geom.TexCoordGenerator;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.IHandle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AARectangle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.GeomGroup;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IDOF;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.LineSeg;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Point;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.Rectifier;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.DisplayGeom;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IDisplayProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPrimProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.ITexCoordGenerator;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.ISnapConstraint;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.LineConstraint;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitPoint3D;
import pyrosim.legacy_2012_1.thunderheadeng.util.AUndoableTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.AcceptAllFilter;
import pyrosim.legacy_2012_1.thunderheadeng.util.HashPool;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObjectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;
import pyrosim.legacy_2012_1.unitsystem.SIUS;
import pyrosim.legacy_2012_1.util.Util;

public class Vent
extends AFDSObject
implements ISurfObj {
    static final long serialVersionUID = 1L;
    public static final int OPTION_OUTLINE = 1;
    public static final int ALL_OPTIONS = 1;
    public static final int DEF_OPTIONS = 0;
    private AARectangle d_quad;
    private Vector3d d_normal;
    private Surface d_surf;
    private TexOrigin d_texOrigin;
    private FireSpread d_fireSpread;
    private OpenProps d_openProps;
    public static final Composite.IObjectProp fireSpreadProp = new Composite.AObjectProp<Vent, FireSpread>(Vent.class){

        @Override
        public void set(Vent vent, FireSpread fireSpread) {
            vent.setFireSpread(fireSpread);
        }

        @Override
        public Object get(Vent vent) {
            return vent.getFireSpread();
        }
    };
    public static final Composite.IObjectProp texOriginProp = new Composite.AObjectProp<Vent, TexOrigin>(Vent.class){

        @Override
        public void set(Vent vent, TexOrigin texOrigin) {
            vent.setTextureOrigin(texOrigin);
        }

        @Override
        public Object get(Vent vent) {
            return vent.getTextureOrigin();
        }
    };
    public static final Composite.IObjectProp surfProp = new Composite.AObjectProp<Vent, Surface>(Vent.class){

        @Override
        public void set(Vent vent, Surface surface) {
            vent.setSurface(surface);
        }

        @Override
        public Object get(Vent vent) {
            return vent.getSurface();
        }
    };

    public Vent(String string, Surface surface) {
        this(string, surface, new AARectangle(2, 0.0, 0.0, 0.0, 1.0, 1.0));
    }

    public Vent(String string, Surface surface, AARectangle aARectangle) {
        super(string);
        this.d_quad = aARectangle;
        this.d_surf = surface;
        this.d_normal = aARectangle instanceof VentGeom ? ((VentGeom)aARectangle).normal : null;
        this.d_fireSpread = null;
        this.d_texOrigin = TexOrigin.defaultWorld();
        this.setOptions(0, true);
    }

    public static IObjectFilter<Surface> getSurfaceFilter() {
        return new AcceptAllFilter<Surface>();
    }

    private static int filterOptions(int n) {
        return n & 1;
    }

    public void setOptions(int n, boolean bl) {
        this.setFlags(Vent.filterOptions(n), bl, new Object[0]);
    }

    public boolean getOptions(int n) {
        return this.testFlags(Vent.filterOptions(n));
    }

    public int getSetOptions() {
        return Vent.filterOptions(super.getSetFlags());
    }

    public void setNormal(Vector3d vector3d) {
        this.d_normal = vector3d;
        this.changedEvt(new Object[0]);
    }

    public Vector3d getNormal() {
        return this.d_normal;
    }

    @Override
    public TexOrigin getTextureOrigin() {
        return this.d_texOrigin;
    }

    @Override
    public void setTextureOrigin(TexOrigin texOrigin) {
        this.d_texOrigin = texOrigin;
        this.changedEvt(new Object[0]);
    }

    public void setOpenProps(OpenProps openProps) {
        this.d_openProps = openProps;
        this.changedEvt(new Object[0]);
    }

    public OpenProps getOpenProps() {
        return this.d_openProps;
    }

    @Override
    public int getNumFaces() {
        return 1;
    }

    @Override
    public Surface[] getSurfaces() {
        return new Surface[]{this.getSurface()};
    }

    @Override
    public void setSurfaces(Surface[] surfaceArray) {
        assert (surfaceArray.length == 1);
        this.setSurface(surfaceArray[0]);
    }

    @Override
    public IObjectFilter<Surface> getSurfFilter() {
        return Vent.getSurfaceFilter();
    }

    public Surface getSurface() {
        return this.d_surf;
    }

    public void setSurface(Surface surface) {
        if (this.d_surf == surface) {
            return;
        }
        this.d_surf = surface;
        this.changedEvt(new Object[0]);
    }

    @Override
    public IFDSObjProps getFragGenerator() {
        return null;
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps iDisplayProps) {
        IPrimProps[] iPrimPropsArray;
        IGeom iGeom;
        Object object;
        VentGeom ventGeom = this.getGeom();
        TexCoordGenerator texCoordGenerator = new TexCoordGenerator(ventGeom, this.d_texOrigin);
        Color color = this.getColors()[0];
        IPrimProps.Face face = new IPrimProps.Face(color, this.getSurface(), false);
        if (ventGeom.normal != null) {
            object = ventGeom.getBoundingBox(new AABox());
            Point3d point3d = Util3D.getMidPoint(((AABox)object).getMin(), ((AABox)object).getMax());
            Point3d point3d2 = new Point3d(ventGeom.normal);
            point3d2.scale(Vent.getNormalDistFromCenter((AABox)object));
            point3d2.add(point3d);
            LineSeg lineSeg = new LineSeg(point3d, point3d2);
            iGeom = new GeomGroup(Arrays.asList(ventGeom, lineSeg));
            iPrimPropsArray = new IPrimProps[]{face, new IPrimProps.Edge(Color.BLACK, 1.0)};
        } else {
            iGeom = ventGeom;
            iPrimPropsArray = new IPrimProps[]{face};
        }
        object = new DisplayGeom(iGeom, (ITexCoordGenerator)texCoordGenerator, iPrimPropsArray);
        if (this.getOptions(1)) {
            object = GeomUtil.convertToOutline((DisplayGeom)object);
        }
        return object;
    }

    public static double getNormalDistFromCenter(AABox aABox) {
        double d = aABox.getWidth();
        double d2 = aABox.getDepth();
        double d3 = aABox.getHeight();
        double d4 = Double.MIN_VALUE;
        if (d > d4) {
            d4 = d;
        }
        if (d2 > d4) {
            d4 = d2;
        }
        if (d3 > d4 && d3 > 0.0) {
            d4 = d3;
        }
        return d4 * 0.25;
    }

    @Override
    public VentGeom getGeom() {
        return new VentGeom(this);
    }

    @Override
    public void setGeom(IGeom iGeom, boolean bl) {
        if ((iGeom = Geometry.finalize(iGeom, bl)) instanceof VentGeom) {
            VentGeom ventGeom = (VentGeom)iGeom;
            this.d_quad = new AARectangle(ventGeom.d_plane, ventGeom.d_planeVal, ventGeom.d_minx, ventGeom.d_miny, ventGeom.d_maxx, ventGeom.d_maxy);
            this.d_normal = ventGeom.normal;
            this.d_fireSpread = ventGeom.fireSpread;
            this.changedEvt(new Object[0]);
        } else if (iGeom instanceof AARectangle) {
            this.pauseUpdates();
            this.d_quad = (AARectangle)iGeom;
            this.clampFireSpread();
            this.changedEvt(new Object[0]);
            this.resumeUpdates();
        }
    }

    private void clampFireSpread() {
        if (this.d_fireSpread == null) {
            return;
        }
        Unit unit = this.d_fireSpread.d_source.getUnit();
        Point3d point3d = this.d_fireSpread.d_source.getPoint3dValue(unit);
        AABox aABox = new AABox();
        this.getGeom().getBoundingBox(aABox);
        Point3d point3d2 = aABox.getMin();
        Point3d point3d3 = aABox.getMax();
        if (point3d.x < point3d2.x) {
            point3d.x = point3d2.x;
        } else if (point3d.x > point3d3.x) {
            point3d.x = point3d3.x;
        }
        if (point3d.y < point3d2.y) {
            point3d.y = point3d2.y;
        } else if (point3d.y > point3d3.y) {
            point3d.y = point3d3.y;
        }
        if (point3d.z < point3d2.z) {
            point3d.z = point3d2.z;
        } else if (point3d.z > point3d3.z) {
            point3d.z = point3d3.z;
        }
        this.setFireSpread(new FireSpread(new UnitPoint3D(point3d, unit), this.d_fireSpread.d_spreadRate));
    }

    public void setFireSpread(FireSpread fireSpread) {
        this.d_fireSpread = fireSpread;
        this.changedEvt(new Object[0]);
    }

    public FireSpread getFireSpread() {
        return this.d_fireSpread;
    }

    public static boolean isValidFireSpreadSurf(Surface surface) {
        if (surface.getSurfDesc() instanceof BurnerSurfDesc) {
            return true;
        }
        if (surface.getSurfDesc() instanceof LayeredSurfDesc) {
            LayeredSurfDesc layeredSurfDesc = (LayeredSurfDesc)surface.getSurfDesc();
            return layeredSurfDesc.d_iReac instanceof Fuel.ManualReac;
        }
        return false;
    }

    @Override
    public void takeDepSnapshot(DepList depList) {
        super.takeDepSnapshot(depList);
        depList.add(DLink.REQUIRED, (IPyroObject)this.d_surf);
        if (this.d_openProps != null) {
            depList.add(DLink.WEAK, this.d_openProps.species.keySet());
        }
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T t, Set<T> set) {
        if (t == this.d_surf) {
            Util.removeAllNotOfType(set, Surface.class);
        } else if (t instanceof ExSpec) {
            Util.removeAllNotOfType(set, ExSpec.class);
        }
    }

    @Override
    public Task taskReplaceDep(final IPyroObject iPyroObject, final IPyroObject iPyroObject2) {
        if (iPyroObject instanceof Surface) {
            return new AReplaceRefTask<Surface>((Object)iPyroObject, (Object)iPyroObject2){

                @Override
                protected void set(Surface surface) {
                    Vent.this.setSurface(surface);
                }
            };
        }
        if (iPyroObject instanceof ExSpec) {
            assert (this.d_openProps != null);
            return new AUndoableTask(){
                private OpenProps d_props;

                @Override
                public void run() {
                    this.d_props = Vent.this.d_openProps;
                    IdentityHashMap<ExSpec, UnitDouble> identityHashMap = new IdentityHashMap<ExSpec, UnitDouble>(((Vent)Vent.this).d_openProps.species);
                    if (iPyroObject2 != null) {
                        UnitDouble unitDouble = ((Vent)Vent.this).d_openProps.species.get(iPyroObject);
                        UnitDouble unitDouble2 = ((Vent)Vent.this).d_openProps.species.get(iPyroObject2);
                        if (unitDouble2 != null) {
                            unitDouble = unitDouble2.add(unitDouble);
                        }
                        identityHashMap.put((ExSpec)iPyroObject2, unitDouble);
                    }
                    identityHashMap.remove(iPyroObject);
                    Vent.this.setOpenProps(new OpenProps(((Vent)Vent.this).d_openProps.temp, ((Vent)Vent.this).d_openProps.pressure, identityHashMap));
                }

                @Override
                public void undo() {
                    OpenProps openProps = this.d_props;
                    this.d_props = null;
                    Vent.this.setOpenProps(openProps);
                }
            };
        }
        return super.taskReplaceDep(iPyroObject, iPyroObject2);
    }

    public static class OptionProp
    extends Composite.AObjectProp<Vent, Boolean> {
        private final int d_option;

        public OptionProp(int n) {
            super(Vent.class);
            this.d_option = n;
        }

        @Override
        public void set(Vent vent, Boolean bl) {
            vent.setOptions(this.d_option, bl);
        }

        @Override
        public Object get(Vent vent) {
            return vent.getOptions(this.d_option);
        }
    }

    public static class OpenProps
    implements Serializable {
        static final long serialVersionUID = 1L;
        public static final OpenProps DEFAULT = new OpenProps(null, new TimeBasedValue<UnitDouble>(new UnitDouble(0.0, SIUS.unit(39)), TimeFunction.newDefault()), Collections.EMPTY_MAP);
        public final UnitDouble temp;
        public final Map<ExSpec, UnitDouble> species;
        public final TimeBasedValue<UnitDouble> pressure;

        public OpenProps(UnitDouble unitDouble, TimeBasedValue<UnitDouble> timeBasedValue, Map<ExSpec, UnitDouble> map) {
            this.temp = unitDouble;
            this.species = map;
            this.pressure = timeBasedValue;
        }
    }

    public static class VentGeom
    extends AARectangle {
        private static final long serialVersionUID = 2758477878491348619L;
        public final Vector3d normal;
        public final FireSpread fireSpread;

        public VentGeom(Vent vent) {
            this(vent.d_quad, vent.d_normal, vent.d_fireSpread);
        }

        public VentGeom(AARectangle aARectangle, Vector3d vector3d, FireSpread fireSpread) {
            super(aARectangle.d_plane, aARectangle.d_planeVal, aARectangle.d_minx, aARectangle.d_miny, aARectangle.d_maxx, aARectangle.d_maxy);
            this.normal = vector3d;
            this.fireSpread = fireSpread;
        }

        public AARectangle optimize(HashPool<Point3d> hashPool) {
            return this;
        }

        @Override
        public IDOF getDOF() {
            return IDOF.ALIGNED;
        }

        @Override
        public VentGeom transform(Matrix4d matrix4d, IGeom.XformOp xformOp) {
            AABox aABox = new AABox();
            super.getBoundingBox(aABox);
            Point3d point3d = Util3D.xform(matrix4d, aABox.getMin());
            Point3d point3d2 = Util3D.xform(matrix4d, aABox.getMax());
            Rectifier.rectify(point3d, point3d2);
            AARectangle aARectangle = AARectangle.construct(point3d, point3d2);
            if (aARectangle == null) {
                return this;
            }
            Vector3d vector3d = this.normal;
            if (this.normal != null) {
                vector3d = Util3D.xform(matrix4d, this.normal);
                vector3d.normalize();
            }
            FireSpread fireSpread = this.fireSpread;
            if (this.fireSpread != null) {
                UnitPoint3D unitPoint3D = Geometry.xform(matrix4d, this.fireSpread.d_source);
                fireSpread = new FireSpread(unitPoint3D, this.fireSpread.d_spreadRate);
            }
            return new VentGeom(aARectangle, vector3d, fireSpread);
        }

        @Override
        public Collection<? extends IHandle> generateManipHandles() {
            Collection<? extends IHandle> collection = super.generateManipHandles();
            ArrayList<? extends IHandle> arrayList = new ArrayList<IHandle>(collection);
            arrayList.add(new NormalHandle(this));
            return arrayList;
        }

        private static class NormalHandle
        implements IHandle {
            private VentGeom geom;

            public NormalHandle(VentGeom ventGeom) {
                this.geom = ventGeom;
            }

            public boolean equals(Object object) {
                return object instanceof NormalHandle;
            }

            @Override
            public IIsectFilter getPickFilter() {
                return null;
            }

            protected Point3d getMidPoint() {
                AABox aABox = this.geom.getBoundingBox(new AABox());
                Point3d point3d = aABox.getMin();
                Point3d point3d2 = aABox.getMax();
                return Util3D.getMidPoint(point3d, point3d2);
            }

            @Override
            public IGeom getGeom() {
                return new Point(this.getLocation());
            }

            protected Point3d getLocation() {
                Point3d point3d = this.getMidPoint();
                Vector3d vector3d = this.geom.normal;
                if (vector3d != null) {
                    Vector3d vector3d2 = new Vector3d(vector3d);
                    vector3d2.scale(this.getNormalDistFromCenter());
                    point3d.add(vector3d2);
                }
                return point3d;
            }

            @Override
            public ISnapConstraint getConstraint(Point3d point3d) {
                return new LineConstraint(point3d, this.geom.getNormal());
            }

            @Override
            public void begin(Point3d point3d, ISnapConstraint iSnapConstraint) {
            }

            @Override
            public VentGeom modify(Point3d point3d) throws Exception {
                Vector3d vector3d = this.geom.getNormal();
                Point3d point3d2 = this.getMidPoint();
                double d = Util3D.tOnLine(point3d2, vector3d, point3d);
                Vector3d vector3d2 = Math.abs(d) < this.getNormalDistFromCenter() * 0.5 ? null : Util3D.scale(vector3d, Math.signum(d));
                this.geom = new VentGeom(this.geom, vector3d2, this.geom.fireSpread);
                return this.geom;
            }

            @Override
            public Object end() {
                return this.geom;
            }

            public double getNormalDistFromCenter() {
                return Vent.getNormalDistFromCenter(this.geom.getBoundingBox(new AABox()));
            }
        }
    }
}

