/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.geom;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Set;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.Composite;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.dependencies.DLink;
import pyrosim.legacy_2012_1.domain.dependencies.DepList;
import pyrosim.legacy_2012_1.domain.dependencies.IDirectDependent;
import pyrosim.legacy_2012_1.domain.geom.AFDSObject;
import pyrosim.legacy_2012_1.domain.particle.Particle;
import pyrosim.legacy_2012_1.domain.rasterization.IFDSObjProps;
import pyrosim.legacy_2012_1.domain.tasks.AReplaceRefTask;
import pyrosim.legacy_2012_1.geom.Geometry;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.GeomConstants;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AABoxGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.BlockGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.DisplayGeom;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IDisplayProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPrimProps;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;
import pyrosim.legacy_2012_1.unitsystem.SIUS;
import pyrosim.legacy_2012_1.util.Util;

public class PartCloud
extends AFDSObject
implements IDirectDependent {
    static final long serialVersionUID = 1L;
    private static final int ALPHA = 51;
    private static final Color DEF_COLOR = new Color(0.7f, 0.7f, 0.9f, 0.2f);
    private AABoxGeom d_geom;
    private Particle d_particle;
    private IDropletCount d_initDropCount;
    private IInsertion d_insertion;
    private boolean d_isStatic;
    private UnitDouble d_density;
    public static final Composite.IObjectProp insertionProp = new Composite.AObjectProp<PartCloud, IInsertion>(PartCloud.class){

        @Override
        public void set(PartCloud partCloud, IInsertion iInsertion) {
            partCloud.setInsertion(iInsertion);
        }

        @Override
        public Object get(PartCloud partCloud) {
            return partCloud.getInsertion();
        }
    };
    public static final Composite.IObjectProp initDropsProp = new Composite.AObjectProp<PartCloud, IDropletCount>(PartCloud.class){

        @Override
        public void set(PartCloud partCloud, IDropletCount iDropletCount) {
            partCloud.setInitDrops(iDropletCount);
        }

        @Override
        public Object get(PartCloud partCloud) {
            return partCloud.getInitDrops();
        }
    };
    public static final Composite.IObjectProp partProp = new Composite.AObjectProp<PartCloud, Particle>(PartCloud.class){

        @Override
        public void set(PartCloud partCloud, Particle particle) {
            partCloud.setParticle(particle);
        }

        @Override
        public Object get(PartCloud partCloud) {
            return partCloud.getParticle();
        }

        @Override
        public boolean equal(Particle particle, Particle particle2) {
            return particle == particle2;
        }
    };
    public static final Composite.IObjectProp staticProp = new Composite.AObjectProp<PartCloud, Boolean>(PartCloud.class){

        @Override
        public void set(PartCloud partCloud, Boolean bl) {
            partCloud.setStatic(bl);
        }

        @Override
        public Object get(PartCloud partCloud) {
            return partCloud.isStatic();
        }
    };

    public PartCloud() {
        this(Intl.intl("Particle Cloud"), null, new AABoxGeom(GeomConstants.PNT3D_ORIGIN, GeomConstants.PNT3D_ORIGIN, 0));
    }

    public PartCloud(String string, Particle particle, AABoxGeom aABoxGeom) {
        super(string);
        this.d_geom = aABoxGeom;
        this.d_particle = particle;
        this.d_initDropCount = new DropDensityCount();
        this.d_insertion = new InsertOnce();
        this.d_isStatic = false;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof PartCloud)) {
            return false;
        }
        PartCloud partCloud = (PartCloud)object;
        return this.d_isStatic == partCloud.isStatic() && this.d_initDropCount.equals(partCloud.getInitDrops()) && this.d_particle.equals(partCloud.getParticle()) && this.d_insertion.equals(partCloud.d_insertion);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.d_density != null) {
            this.d_insertion = new InsertOnce(this.d_density);
            this.d_density = null;
        }
    }

    public Particle getParticle() {
        return this.d_particle;
    }

    public void setParticle(Particle particle) {
        this.d_particle = particle;
        this.changedEvt(new Object[0]);
    }

    public IDropletCount getInitDrops() {
        return this.d_initDropCount;
    }

    public void setInitDrops(IDropletCount iDropletCount) {
        this.d_initDropCount = iDropletCount;
        this.changedEvt(new Object[0]);
    }

    public IInsertion getInsertion() {
        return this.d_insertion;
    }

    public void setInsertion(IInsertion iInsertion) {
        this.d_insertion = iInsertion;
        this.changedEvt(new Object[0]);
    }

    public boolean isStatic() {
        return this.d_isStatic;
    }

    public void setStatic(boolean bl) {
        this.d_isStatic = bl;
        this.changedEvt(new Object[0]);
    }

    @Override
    public void setColors(Color ... colorArray) {
    }

    @Override
    public Color[] getColors() {
        Color color = this.d_particle != null ? this.d_particle.getDescription().getColor() : DEF_COLOR;
        color = new Color(color.getRed(), color.getGreen(), color.getBlue(), 51);
        return new Color[]{color};
    }

    @Override
    public IFDSObjProps getFragGenerator() {
        return null;
    }

    @Override
    public void takeDepSnapshot(DepList depList) {
        super.takeDepSnapshot(depList);
        depList.add(DLink.STRONG, (IPyroObject)this.d_particle);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T t, Set<T> set) {
        if (t == this.d_particle) {
            Util.removeAllNotOfType(set, Particle.class);
        } else {
            super.removeInvalidReplacements(t, set);
        }
    }

    @Override
    public Task taskReplaceDep(IPyroObject iPyroObject, IPyroObject iPyroObject2) {
        if (!(iPyroObject instanceof Particle)) {
            return super.taskReplaceDep(iPyroObject, iPyroObject2);
        }
        assert (iPyroObject2 != null);
        return new AReplaceRefTask<Particle>((Object)iPyroObject, (Object)iPyroObject2){

            @Override
            protected void set(Particle particle) {
                PartCloud.this.setParticle(particle);
            }
        };
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps iDisplayProps) {
        Color[] colorArray = this.getColors();
        return new DisplayGeom((IGeom)this.getGeom(), (IPrimProps)new IPrimProps.Face(colorArray[0], null, true));
    }

    @Override
    public AABoxGeom getGeom() {
        return this.d_geom instanceof BlockGeom ? this.d_geom : new BlockGeom(this.d_geom.min, this.d_geom.max, 0);
    }

    @Override
    public void setGeom(IGeom iGeom, boolean bl) {
        if ((iGeom = Geometry.finalize(iGeom, bl)) instanceof AABoxGeom) {
            this.d_geom = (AABoxGeom)iGeom;
            this.changedEvt(new Object[0]);
        }
    }

    public UnitDouble getVolume() {
        double d = this.d_geom.max.x - this.d_geom.min.x;
        double d2 = this.d_geom.max.y - this.d_geom.min.y;
        double d3 = this.d_geom.max.z - this.d_geom.min.z;
        return new UnitDouble(d * d2 * d3, SIUS.unit(56));
    }

    public static class InsertPeriodically
    implements IInsertion {
        private static final long serialVersionUID = 1L;
        public final UnitDouble dt;
        public final UnitDouble massPerTime;

        public InsertPeriodically() {
            this(new UnitDouble(0.01, SI.SECOND), SIUS.newud(1.0, 4));
        }

        public InsertPeriodically(UnitDouble unitDouble, UnitDouble unitDouble2) {
            this.dt = unitDouble;
            this.massPerTime = unitDouble2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof InsertPeriodically)) {
                return false;
            }
            InsertPeriodically insertPeriodically = (InsertPeriodically)object;
            return this.dt.equals(insertPeriodically.dt) && theUtil.equal(this.massPerTime, insertPeriodically.massPerTime);
        }
    }

    public static class InsertOnce
    implements IInsertion {
        private static final long serialVersionUID = 1L;
        public final UnitDouble massPerVolume;

        public InsertOnce() {
            this(SIUS.newud(1.0, 4));
        }

        public InsertOnce(UnitDouble unitDouble) {
            this.massPerVolume = unitDouble;
        }

        public boolean equals(Object object) {
            return object instanceof InsertOnce && theUtil.equal(((InsertOnce)object).massPerVolume, this.massPerVolume);
        }
    }

    public static interface IInsertion
    extends Serializable {
    }

    public static class DropDensityCount
    implements IDropletCount {
        static final long serialVersionUID = 1L;
        public final UnitDouble d_density;

        public DropDensityCount() {
            this(SIUS.newud(10.0, 55));
        }

        public DropDensityCount(UnitDouble unitDouble) {
            this.d_density = unitDouble;
        }

        @Override
        public int getNumDrops(PartCloud partCloud) {
            double d = partCloud.getVolume().getValue(SIUS.unit(56));
            double d2 = this.d_density.getValue(SIUS.unit(55));
            return (int)Math.round(d * d2);
        }

        public boolean equals(Object object) {
            if (!(object instanceof DropDensityCount)) {
                return false;
            }
            DropDensityCount dropDensityCount = (DropDensityCount)object;
            return this.d_density.equals(dropDensityCount.d_density);
        }
    }

    public static class ConstDropletCount
    implements IDropletCount {
        static final long serialVersionUID = 1L;
        public final int d_dropCount;

        public ConstDropletCount() {
            this(100);
        }

        public ConstDropletCount(int n) {
            this.d_dropCount = n;
        }

        @Override
        public int getNumDrops(PartCloud partCloud) {
            return this.d_dropCount;
        }

        public boolean equals(Object object) {
            if (!(object instanceof ConstDropletCount)) {
                return false;
            }
            ConstDropletCount constDropletCount = (ConstDropletCount)object;
            return this.d_dropCount == constDropletCount.d_dropCount;
        }
    }

    public static interface IDropletCount
    extends Serializable {
        public int getNumDrops(PartCloud var1);
    }
}

