/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.geom;

import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Point3d;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.GeomUtil;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.boundcond.surf.PredefSurf;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Surface;
import pyrosim.legacy_2012_1.domain.dependencies.DLink;
import pyrosim.legacy_2012_1.domain.dependencies.DepList;
import pyrosim.legacy_2012_1.domain.geom.AFDSObject;
import pyrosim.legacy_2012_1.domain.geom.FDSUtil;
import pyrosim.legacy_2012_1.domain.geom.IHole;
import pyrosim.legacy_2012_1.domain.geom.IObstruction;
import pyrosim.legacy_2012_1.domain.geom.TexOrigin;
import pyrosim.legacy_2012_1.domain.rasterization.FaceProps;
import pyrosim.legacy_2012_1.domain.rasterization.IFDSObjProps;
import pyrosim.legacy_2012_1.domain.rasterization.IFragGenerator;
import pyrosim.legacy_2012_1.domain.rasterization.ObstFragGenerator;
import pyrosim.legacy_2012_1.domain.rasterization.RasterizationOptions;
import pyrosim.legacy_2012_1.geom.Geometry;
import pyrosim.legacy_2012_1.geom.IGeomSource;
import pyrosim.legacy_2012_1.geom.IPyroDisplayProps;
import pyrosim.legacy_2012_1.geom.TexCoordGenerator;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.BooleanOp;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.EdgeUse;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.Face;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.nmt.Model;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.GeomGroup;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IFace;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPolygon;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.PolyUtil;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.Containment;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.DisplayGeom;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.FlattenedProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IDisplayProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IMaterial;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPrimProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPropsSrc;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.ITexCoordGenerator;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.UniformProps;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.AUndoableTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObjectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.util.Pair;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;
import pyrosim.legacy_2012_1.util.LWArray;
import pyrosim.legacy_2012_1.util.Util;

public class Obstruction
extends AFDSObject
implements IObstruction {
    static final long serialVersionUID = 1L;
    private static final int DEF_FLAGS = -2147483556;
    private IGeom d_geom;
    private Object d_surfaces;
    private TexOrigin d_texOrigin;
    private UnitDouble d_bulkDensity;
    private static final IObjectFilter<Surface> s_surfFilter = new IObjectFilter<Surface>(){

        @Override
        public boolean shouldFilter(Surface surface) {
            return surface.getName().equals(PredefSurf.OPEN.name()) || surface.getName().equals(PredefSurf.MIRROR.name()) || surface.getName().equals(PredefSurf.HVAC.name());
        }
    };

    public Obstruction(String string, IGeom iGeom, Surface[] surfaceArray) {
        super(string);
        this.d_geom = Geometry.finalize(iGeom, true);
        this.d_surfaces = LWArray.newArray(surfaceArray);
        this.d_texOrigin = TexOrigin.defaultWorld();
        this.d_bulkDensity = null;
        this.setOptions(92, true);
    }

    @Override
    public Object clone() {
        Obstruction obstruction = (Obstruction)super.clone();
        Surface[] surfaceArray = this.getSurfaces();
        obstruction.d_surfaces = LWArray.newArray(surfaceArray);
        return obstruction;
    }

    @Override
    public UnitDouble getBulkDensity() {
        return this.d_bulkDensity;
    }

    @Override
    public void setBulkDensity(UnitDouble unitDouble) {
        if (theUtil.equal(unitDouble, this.d_bulkDensity)) {
            return;
        }
        this.d_bulkDensity = unitDouble;
        this.changedEvt(new Object[0]);
    }

    private static int filterOptions(int n) {
        return n & 0x7F;
    }

    @Override
    public void setOptions(int n, boolean bl) {
        this.setFlags(Obstruction.filterOptions(n), bl, new Object[0]);
    }

    @Override
    public boolean getOptions(int n) {
        return this.testFlags(Obstruction.filterOptions(n));
    }

    @Override
    public int getSetOptions() {
        return Obstruction.filterOptions(super.getSetFlags());
    }

    @Override
    public TexOrigin getTextureOrigin() {
        return this.d_texOrigin;
    }

    @Override
    public void setTextureOrigin(TexOrigin texOrigin) {
        if (this.d_texOrigin.equals(texOrigin)) {
            return;
        }
        this.d_texOrigin = texOrigin;
        this.changedEvt(new Object[0]);
    }

    @Override
    public int getNumFaces() {
        return this.getGeom().getNumPrims(1);
    }

    @Override
    public IFDSObjProps getFragGenerator() {
        return new FragGen();
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps iDisplayProps) {
        IPyroDisplayProps iPyroDisplayProps = iDisplayProps instanceof IPyroDisplayProps ? (IPyroDisplayProps)iDisplayProps : null;
        DisplayGeom displayGeom = FDSUtil.getRastDisplay(iPyroDisplayProps, this, this.getTextureOrigin());
        if (displayGeom != null) {
            return displayGeom;
        }
        displayGeom = this.constructBaseGeom(iPyroDisplayProps);
        if (this.getOptions(32)) {
            displayGeom = GeomUtil.convertToOutline(displayGeom);
        }
        return displayGeom;
    }

    private DisplayGeom constructBaseGeom(IPyroDisplayProps iPyroDisplayProps) {
        Collection<? extends IGeomSource> collection;
        IPropsSrc iPropsSrc = this.getDisplayProps();
        TexCoordGenerator texCoordGenerator = new TexCoordGenerator(this.d_geom, this.d_texOrigin);
        PyroMod pyroMod = (PyroMod)this.getDomain();
        if (pyroMod != null && this.getOptions(4) && (iPyroDisplayProps == null || iPyroDisplayProps.getCutHoles()) && !(collection = pyroMod.getGeomProx().getNearObjs(this)).isEmpty()) {
            Cloneable cloneable;
            IPrimProps iPrimProps;
            List<IGeom> list = pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.GeomUtil.flatten(this.d_geom);
            if (iPropsSrc instanceof UniformProps) {
                iPrimProps = iPropsSrc.get(0);
            } else {
                cloneable = (Surface)pyroMod.getSurfaceMgr().get(PredefSurf.INERT.name());
                iPrimProps = new IPrimProps.Face(null, (IMaterial)((Object)cloneable), false);
            }
            cloneable = new ArrayList(collection.size());
            for (IGeomSource iGeomSource : collection) {
                if (!(iGeomSource instanceof IHole)) continue;
                pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.GeomUtil.flatten(((IHole)iGeomSource).getGeom(), (List<IGeom>)((Object)cloneable));
            }
            DisplayGeom displayGeom = Obstruction.subtractHoles(texCoordGenerator, list, iPropsSrc, (List<IGeom>)((Object)cloneable), iPrimProps);
            if (displayGeom != null) {
                return displayGeom;
            }
        }
        return new DisplayGeom(this.d_geom, (ITexCoordGenerator)texCoordGenerator, iPropsSrc);
    }

    private static void toModels(IGeom iGeom, Map<IPrimProps, Integer> map, IPropsSrc iPropsSrc, int n, List<Pair<Model, Boolean>> list) {
        if (iGeom instanceof GeomGroup) {
            GeomGroup geomGroup = (GeomGroup)iGeom;
            for (IGeom iGeom2 : geomGroup.children) {
                Obstruction.toModels(iGeom2, map, iPropsSrc, n, list);
                n += iGeom2.getNumPrims(1);
            }
        } else {
            Model model = Obstruction.toModel(iGeom, map, iPropsSrc, n);
            list.add(new Pair<Model, Boolean>(model, !iGeom.isShell()));
        }
    }

    private static Model toModel(IGeom iGeom, Map<IPrimProps, Integer> map, IPropsSrc iPropsSrc, int n) {
        Model model = new Model();
        List list = pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.GeomUtil.explode(iGeom, IFace.class);
        for (int i = 0; i < list.size(); ++i) {
            IFace iFace = (IFace)list.get(i);
            IPrimProps iPrimProps = iPropsSrc.get(n + i);
            Integer n2 = map.get(iPrimProps);
            if (n2 == null) {
                n2 = map.size();
                map.put(iPrimProps, n2);
            }
            List<IPolygon> list2 = GeomUtil.toPolys(iFace, 0.1, true);
            for (IPolygon iPolygon : list2) {
                Point3d[] point3dArray = PolyUtil.getAllVerts(iPolygon, false);
                model.addPolygonFace(n2, PolyUtil.getPlane(iPolygon), point3dArray);
            }
        }
        return model;
    }

    private static DisplayGeom subtractHoles(ITexCoordGenerator iTexCoordGenerator, List<IGeom> list, IPropsSrc iPropsSrc, List<IGeom> list2, IPrimProps iPrimProps) {
        ArrayList<IPrimProps> arrayList = new ArrayList<IPrimProps>();
        ArrayList<IGeom> arrayList2 = new ArrayList<IGeom>();
        int n = 0;
        for (IGeom iGeom : list) {
            Obstruction.subtractHoles(iGeom, list2, iPropsSrc, n, iPrimProps, arrayList2, arrayList);
            n += iGeom.getNumPrims(1);
        }
        GeomGroup geomGroup = new GeomGroup(arrayList2);
        return new DisplayGeom((IGeom)geomGroup, iTexCoordGenerator, arrayList.toArray(new IPrimProps[arrayList.size()]));
    }

    /*
     * WARNING - void declaration
     */
    private static void subtractHoles(IGeom iGeom, List<IGeom> list, IPropsSrc iPropsSrc, int n, IPrimProps iPrimProps, List<IGeom> list2, List<IPrimProps> list3) {
        Point3d[] point3dArray;
        HashMap<IPrimProps, Integer> hashMap = new HashMap<IPrimProps, Integer>();
        boolean bl = false;
        Model model = null;
        AABox aABox = iGeom.getBoundingBox(new AABox());
        for (IGeom object : list) {
            boolean bl2;
            Model model2;
            boolean bl3;
            Containment containment = aABox.test(object.getBoundingBox(new AABox()));
            if (containment == Containment.OUTSIDE) continue;
            if (model == null) {
                model = Obstruction.toModel(iGeom, hashMap, iPropsSrc, n);
            }
            if ((point3dArray = BooleanOp.subtract(model, bl3 = !iGeom.isShell() && model.getFaces().size() >= 4, model2 = Obstruction.toModel(object, hashMap, new UniformProps(iPrimProps), 0), bl2 = !object.isShell() && model2.getFaces().size() >= 4)) == model || point3dArray == null) continue;
            model = point3dArray;
            aABox = model.getBoundingBox();
            bl = true;
        }
        if (bl) {
            assert (model != null);
            IPrimProps[] iPrimPropsArray = new IPrimProps[hashMap.size()];
            for (Map.Entry entry : hashMap.entrySet()) {
                IPrimProps iPrimProps2 = (IPrimProps)entry.getKey();
                if (iPrimProps2.getCullFace()) {
                    iPrimProps2 = new IPrimProps.Face(iPrimProps2.getColor(), iPrimProps2.getMaterial(), false);
                }
                iPrimPropsArray[((Integer)entry.getValue()).intValue()] = iPrimProps2;
            }
            for (Face face : model.getFaces()) {
                Serializable serializable;
                int n2;
                Point3d[][] point3dArray2 = new Point3d[face.edgeLoops.size()][];
                for (n2 = 0; n2 < face.edgeLoops.size(); ++n2) {
                    serializable = face.edgeLoops.get(n2);
                    point3dArray = new Point3d[serializable.edges.size()];
                    for (int i = 0; i < serializable.edges.size(); ++i) {
                        EdgeUse edgeUse = serializable.edges.get(i);
                        point3dArray[i] = edgeUse.v1().loc;
                    }
                    point3dArray2[n2] = point3dArray;
                }
                n2 = face.groups[0];
                serializable = iPrimPropsArray[n2];
                list3.add((IPrimProps)serializable);
                list2.add(PolyUtil.newPoly(point3dArray2));
            }
        } else {
            void var12_17;
            list2.add(iGeom);
            int n3 = iGeom.getNumPrims(1);
            boolean bl4 = false;
            while (var12_17 < n3) {
                list3.add(iPropsSrc.get((int)(var12_17 + n)));
                ++var12_17;
            }
        }
    }

    @Override
    public IGeom getGeom() {
        return this.d_geom;
    }

    @Override
    public void setGeom(IGeom iGeom, boolean bl) {
        if (this.d_geom == (iGeom = Geometry.finalize(iGeom, bl))) {
            return;
        }
        assert (iGeom.getNumPrims(6) == 0) : "Geometry assigned to an obstruction should contain only faces.";
        this.d_geom = iGeom;
        this.changedEvt(new Object[0]);
    }

    @Override
    public void setSurfaces(Surface[] surfaceArray) {
        assert (surfaceArray.length == 1 || surfaceArray.length == this.d_geom.getNumPrims(1));
        this.d_surfaces = LWArray.newArray(surfaceArray);
        this.changedEvt(new Object[0]);
    }

    @Override
    public Surface[] getSurfaces() {
        return LWArray.toArray(this.d_surfaces, Surface.class);
    }

    public IPropsSrc getDisplayProps() {
        Surface[] surfaceArray = this.getSurfaces();
        Color[] colorArray = this.getColors();
        boolean bl = GeomUtil.isCullGeom(this.d_geom);
        if (surfaceArray.length == 1 && colorArray.length == 1) {
            IPrimProps.Face face = new IPrimProps.Face(colorArray[0], surfaceArray[0], bl);
            return new UniformProps(face);
        }
        int n = Math.max(surfaceArray.length, colorArray.length);
        IPrimProps[] iPrimPropsArray = new IPrimProps[n];
        for (int i = 0; i < n; ++i) {
            Surface surface = surfaceArray.length == 1 ? surfaceArray[0] : surfaceArray[i];
            Color color = colorArray.length == 1 ? colorArray[0] : colorArray[i];
            iPrimPropsArray[i] = new IPrimProps.Face(color, surface, bl);
        }
        return new FlattenedProps(iPrimPropsArray);
    }

    @Override
    public IObjectFilter<Surface> getSurfFilter() {
        return s_surfFilter;
    }

    public static IObjectFilter<Surface> getSurfaceFilter() {
        return s_surfFilter;
    }

    @Override
    public void takeDepSnapshot(DepList depList) {
        super.takeDepSnapshot(depList);
        IPyroObject[] iPyroObjectArray = this.getSurfaces();
        depList.add(DLink.REQUIRED, iPyroObjectArray);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T t, Set<T> set) {
        if (t instanceof Surface) {
            Util.removeAllNotOfType(set, Surface.class);
        } else {
            super.removeInvalidReplacements(t, set);
        }
    }

    @Override
    public Task taskReplaceDep(final IPyroObject iPyroObject, final IPyroObject iPyroObject2) {
        if (!(iPyroObject instanceof Surface)) {
            return super.taskReplaceDep(iPyroObject, iPyroObject2);
        }
        return new AUndoableTask(){
            private int[] d_ixes = null;

            @Override
            public void undo() {
                this.setCurrentSurface((Surface)iPyroObject);
                this.d_ixes = null;
            }

            @Override
            public void run() {
                if (this.d_ixes == null) {
                    ArrayList<Integer> arrayList = new ArrayList<Integer>();
                    Surface[] surfaceArray = Obstruction.this.getSurfaces();
                    for (int i = 0; i < surfaceArray.length; ++i) {
                        if (surfaceArray[i] != iPyroObject) continue;
                        arrayList.add(i);
                    }
                    this.d_ixes = theUtil.toIntArray(arrayList);
                }
                this.setCurrentSurface((Surface)iPyroObject2);
            }

            private void setCurrentSurface(Surface surface) {
                Surface[] surfaceArray = Obstruction.this.getSurfaces();
                Surface[] surfaceArray2 = (Surface[])surfaceArray.clone();
                for (int i = 0; i < this.d_ixes.length; ++i) {
                    surfaceArray2[this.d_ixes[i]] = surface;
                }
                Obstruction.this.setSurfaces(surfaceArray2);
            }
        };
    }

    private class FragGen
    implements IFDSObjProps {
        @Override
        public IFragGenerator getFragGenerator(RasterizationOptions rasterizationOptions) {
            return new ObstFragGenerator(Obstruction.this, rasterizationOptions);
        }

        @Override
        public FaceProps getFace(int n) {
            Surface[] surfaceArray = Obstruction.this.getSurfaces();
            Surface surface = surfaceArray.length > 1 ? surfaceArray[n] : surfaceArray[0];
            Color[] colorArray = Obstruction.this.getColors();
            Color color = colorArray.length == 1 ? colorArray[0] : colorArray[n];
            return new FaceProps(surface, color);
        }

        @Override
        public boolean thickenEnabled() {
            return Obstruction.this.getOptions(1);
        }
    }
}

