/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.geom;

import java.awt.Color;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.Composite;
import pyrosim.legacy_2012_1.domain.ExSpec;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.dependencies.DLink;
import pyrosim.legacy_2012_1.domain.dependencies.DepList;
import pyrosim.legacy_2012_1.domain.dependencies.IDirectDependent;
import pyrosim.legacy_2012_1.domain.geom.AFDSObject;
import pyrosim.legacy_2012_1.domain.rasterization.IFDSObjProps;
import pyrosim.legacy_2012_1.geom.Geometry;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.GeomConstants;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AABoxGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.BlockGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.DisplayGeom;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IDisplayProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPrimProps;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.AUndoableTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;
import pyrosim.legacy_2012_1.unitsystem.SIUS;
import pyrosim.legacy_2012_1.util.Util;

public class InitRegion
extends AFDSObject
implements IDirectDependent {
    static final long serialVersionUID = 1L;
    private static final int ALPHA = 51;
    private static final Color DEF_COLOR = new Color(0.3f, 0.7f, 0.9f, 0.2f);
    private AABoxGeom d_geom;
    private UnitDouble d_density;
    private UnitDouble d_temperature;
    private Map<ExSpec, UnitDouble> d_specMassFrac;
    public static final Composite.IObjectProp densityProp = new Composite.AObjectProp<InitRegion, UnitDouble>(InitRegion.class){

        @Override
        public void set(InitRegion initRegion, UnitDouble unitDouble) {
            initRegion.setDensity(unitDouble);
        }

        @Override
        public Object get(InitRegion initRegion) {
            return initRegion.getDensity();
        }
    };
    public static final Composite.IObjectProp tempProp = new Composite.AObjectProp<InitRegion, UnitDouble>(InitRegion.class){

        @Override
        public void set(InitRegion initRegion, UnitDouble unitDouble) {
            initRegion.setTemperature(unitDouble);
        }

        @Override
        public Object get(InitRegion initRegion) {
            return initRegion.getTemperature();
        }
    };

    public InitRegion() {
        this(Intl.intl("Init Region"), new AABoxGeom(GeomConstants.PNT3D_ORIGIN, GeomConstants.PNT3D_ORIGIN, 0));
    }

    public InitRegion(String string, AABoxGeom aABoxGeom) {
        super(string);
        this.d_geom = aABoxGeom.optimize(Geometry.P3D_POOL);
        this.d_density = null;
        this.d_temperature = null;
        this.d_specMassFrac = Collections.EMPTY_MAP;
    }

    @Override
    public Object clone() {
        InitRegion initRegion = (InitRegion)super.clone();
        if (initRegion.d_specMassFrac != Collections.EMPTY_MAP) {
            initRegion.d_specMassFrac = new IdentityHashMap<ExSpec, UnitDouble>(initRegion.d_specMassFrac);
        }
        return initRegion;
    }

    @Override
    public void setColors(Color ... colorArray) {
    }

    @Override
    public Color[] getColors() {
        return new Color[]{DEF_COLOR};
    }

    public UnitDouble getDensity() {
        return this.d_density;
    }

    public void setDensity(UnitDouble unitDouble) {
        this.d_density = unitDouble;
        this.changedEvt(new Object[0]);
    }

    public UnitDouble getTemperature() {
        return this.d_temperature;
    }

    public void setTemperature(UnitDouble unitDouble) {
        this.d_temperature = unitDouble;
        this.changedEvt(new Object[0]);
    }

    public Map<ExSpec, UnitDouble> getExtraSpecies() {
        return Collections.unmodifiableMap(this.d_specMassFrac);
    }

    public void setExtraSpecies(Map<ExSpec, UnitDouble> map) {
        this.d_specMassFrac = map.isEmpty() ? Collections.EMPTY_MAP : map;
        this.changedEvt(new Object[0]);
    }

    public void setSpecMF(ExSpec exSpec, UnitDouble unitDouble) {
        if (unitDouble == null || unitDouble.getValueNoUnit() == 0.0) {
            if (this.d_specMassFrac.containsKey(exSpec)) {
                this.d_specMassFrac.remove(exSpec);
                if (this.d_specMassFrac.isEmpty()) {
                    this.d_specMassFrac = Collections.EMPTY_MAP;
                }
                this.changedEvt(new Object[0]);
            }
        } else {
            if (this.d_specMassFrac == Collections.EMPTY_MAP) {
                this.d_specMassFrac = new IdentityHashMap<ExSpec, UnitDouble>();
            }
            this.d_specMassFrac.put(exSpec, unitDouble);
            this.changedEvt(new Object[0]);
        }
    }

    @Override
    public IFDSObjProps getFragGenerator() {
        return null;
    }

    @Override
    public void takeDepSnapshot(DepList depList) {
        super.takeDepSnapshot(depList);
        depList.add(DLink.WEAK, this.d_specMassFrac.keySet());
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T t, Set<T> set) {
        if (t instanceof ExSpec) {
            Util.removeAllNotOfType(set, ExSpec.class);
        } else {
            super.removeInvalidReplacements(t, set);
        }
    }

    @Override
    public Task taskReplaceDep(IPyroObject iPyroObject, IPyroObject iPyroObject2) {
        if (!(iPyroObject instanceof ExSpec)) {
            return super.taskReplaceDep(iPyroObject, iPyroObject2);
        }
        final ExSpec exSpec = (ExSpec)iPyroObject;
        final ExSpec exSpec2 = (ExSpec)iPyroObject2;
        return new AUndoableTask(){
            private UnitDouble d_oldVal;
            private UnitDouble d_replVal;

            @Override
            public void run() {
                assert (InitRegion.this.d_specMassFrac.containsKey(exSpec));
                this.d_oldVal = (UnitDouble)InitRegion.this.d_specMassFrac.remove(exSpec);
                if (exSpec2 != null) {
                    if (InitRegion.this.d_specMassFrac.containsKey(exSpec2)) {
                        this.d_replVal = (UnitDouble)InitRegion.this.d_specMassFrac.get(exSpec2);
                        InitRegion.this.d_specMassFrac.put(exSpec2, this.d_replVal.add(this.d_oldVal));
                    } else {
                        this.d_replVal = null;
                        InitRegion.this.d_specMassFrac.put(exSpec2, this.d_oldVal);
                    }
                } else if (InitRegion.this.d_specMassFrac.isEmpty()) {
                    InitRegion.this.d_specMassFrac = Collections.EMPTY_MAP;
                }
                InitRegion.this.changedEvt(new Object[0]);
            }

            @Override
            public void undo() {
                if (InitRegion.this.d_specMassFrac == Collections.EMPTY_MAP) {
                    InitRegion.this.d_specMassFrac = new IdentityHashMap();
                }
                InitRegion.this.d_specMassFrac.put(exSpec, this.d_oldVal);
                if (exSpec2 != null) {
                    if (this.d_replVal == null) {
                        InitRegion.this.d_specMassFrac.remove(exSpec2);
                    } else {
                        InitRegion.this.d_specMassFrac.put(exSpec2, this.d_replVal);
                    }
                }
                InitRegion.this.changedEvt(new Object[0]);
            }
        };
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps iDisplayProps) {
        Color[] colorArray = this.getColors();
        return new DisplayGeom((IGeom)this.getGeom(), (IPrimProps)new IPrimProps.Face(colorArray[0], null, true));
    }

    @Override
    public AABoxGeom getGeom() {
        return this.d_geom instanceof BlockGeom ? this.d_geom : new BlockGeom(this.d_geom.min, this.d_geom.max, 0);
    }

    @Override
    public void setGeom(IGeom iGeom, boolean bl) {
        if ((iGeom = Geometry.finalize(iGeom, bl)) instanceof AABoxGeom) {
            this.d_geom = (AABoxGeom)iGeom;
            this.changedEvt(new Object[0]);
        }
    }

    public static class SpecMFProp
    extends Composite.AObjectProp<InitRegion, UnitDouble> {
        public ExSpec currSpec;

        public SpecMFProp() {
            super(InitRegion.class);
        }

        @Override
        public void set(InitRegion initRegion, UnitDouble unitDouble) {
            initRegion.setSpecMF(this.currSpec, unitDouble);
        }

        @Override
        public Object get(InitRegion initRegion) {
            UnitDouble unitDouble = (UnitDouble)initRegion.d_specMassFrac.get(this.currSpec);
            return unitDouble == null ? SIUS.newud(0.0, 18) : unitDouble;
        }
    }
}

