/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.geom;

import java.awt.Color;
import pyrosim.legacy_2012_1.domain.GeomUtil;
import pyrosim.legacy_2012_1.domain.geom.AFDSObject;
import pyrosim.legacy_2012_1.domain.geom.FDSUtil;
import pyrosim.legacy_2012_1.domain.geom.IHole;
import pyrosim.legacy_2012_1.domain.geom.TexOrigin;
import pyrosim.legacy_2012_1.domain.rasterization.FaceProps;
import pyrosim.legacy_2012_1.domain.rasterization.HoleFragGenerator;
import pyrosim.legacy_2012_1.domain.rasterization.IFDSObjProps;
import pyrosim.legacy_2012_1.domain.rasterization.IFragGenerator;
import pyrosim.legacy_2012_1.domain.rasterization.RasterizationOptions;
import pyrosim.legacy_2012_1.geom.Geometry;
import pyrosim.legacy_2012_1.geom.IPyroDisplayProps;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.DisplayGeom;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.FlattenedProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IDisplayProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPrimProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPropsSrc;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.UniformProps;

public class Hole
extends AFDSObject
implements IHole {
    static final long serialVersionUID = 1L;
    public static final double ALPHA = 0.4;
    public static final Color DEF_COLOR = new Color(Color.GRAY.getRed(), Color.GRAY.getGreen(), Color.GRAY.getBlue(), 102);
    private IGeom d_geom;

    public Hole(String string, IGeom iGeom) {
        super(string);
        this.d_geom = Geometry.finalize(iGeom, true);
    }

    @Override
    public IFDSObjProps getFragGenerator() {
        return new FragGen();
    }

    @Override
    public IGeom getGeom() {
        return this.d_geom;
    }

    @Override
    public void setGeom(IGeom iGeom, boolean bl) {
        if ((iGeom = Geometry.finalize(iGeom, bl)) == this.d_geom) {
            return;
        }
        this.d_geom = iGeom;
        this.changedEvt(new Object[0]);
    }

    private static IPrimProps toProps(Color color, boolean bl) {
        color = color == null ? DEF_COLOR : new Color(color.getRed(), color.getGreen(), color.getBlue(), 102);
        return new IPrimProps.Face(color, null, bl);
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps iDisplayProps) {
        IPropsSrc iPropsSrc;
        IPyroDisplayProps iPyroDisplayProps = iDisplayProps instanceof IPyroDisplayProps ? (IPyroDisplayProps)iDisplayProps : null;
        DisplayGeom displayGeom = FDSUtil.getRastDisplay(iPyroDisplayProps, this, TexOrigin.DEF_WORLD);
        if (displayGeom != null) {
            return displayGeom;
        }
        Color[] colorArray = this.getColors();
        boolean bl = GeomUtil.isCullGeom(this.d_geom);
        if (colorArray.length == 1) {
            iPropsSrc = new UniformProps(Hole.toProps(colorArray[0], bl));
        } else {
            IPrimProps[] iPrimPropsArray = new IPrimProps[colorArray.length];
            for (int i = 0; i < colorArray.length; ++i) {
                iPrimPropsArray[i] = Hole.toProps(colorArray[i], bl);
            }
            iPropsSrc = new FlattenedProps(iPrimPropsArray);
        }
        return new DisplayGeom(this.d_geom, iPropsSrc);
    }

    private class FragGen
    implements IFDSObjProps {
        private FaceProps d_faceProps;

        private FragGen() {
            this.d_faceProps = new FaceProps(Hole.this.getColors()[0]);
        }

        @Override
        public FaceProps getFace(int n) {
            return this.d_faceProps;
        }

        @Override
        public IFragGenerator getFragGenerator(RasterizationOptions rasterizationOptions) {
            return new HoleFragGenerator(Hole.this, rasterizationOptions);
        }

        @Override
        public boolean thickenEnabled() {
            return true;
        }
    }
}

