/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.geom;

import java.awt.Color;
import java.util.Arrays;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.Composite;
import pyrosim.legacy_2012_1.domain.NamedPyroObject;
import pyrosim.legacy_2012_1.domain.geom.IModelObj;
import pyrosim.legacy_2012_1.geom.Geometry;
import pyrosim.legacy_2012_1.geom.TexCoordGenerator;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.ConvexHull;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.search.ITest;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.DisplayGeom;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IDisplayProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPrimProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPropsSrc;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.ITexCoordGenerator;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.PropsBuilder;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IBoxCollector;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectCollector;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectFilter;

public class GenericGeomSrc
extends NamedPyroObject
implements IModelObj {
    static final long serialVersionUID = 1L;
    private IGeom d_geom;
    private ITexCoordGenerator d_texGen;
    private IPropsSrc d_props;
    private boolean d_visible;
    public static final Composite.IObjectProp colorProp = new Composite.AObjectProp<GenericGeomSrc, Color[]>(GenericGeomSrc.class){

        @Override
        public void set(GenericGeomSrc genericGeomSrc, Color[] colorArray) {
            PropsBuilder propsBuilder = new PropsBuilder();
            int n = genericGeomSrc.getGeom().getNumPrims(7);
            assert (colorArray.length == 1 || colorArray.length == n);
            for (int i = 0; i < n; ++i) {
                Color color;
                IPrimProps iPrimProps = genericGeomSrc.getDisplayProps().get(i);
                Color color2 = color = colorArray.length == 1 ? colorArray[0] : colorArray[i];
                if (color != null) {
                    iPrimProps = new IPrimProps.GenericProps(color, iPrimProps.getMaterial(), iPrimProps.getCullFace(), iPrimProps.getEdgeWidth(), iPrimProps.getPointSize());
                }
                propsBuilder.add(iPrimProps, true);
            }
            genericGeomSrc.setDisplayProps(propsBuilder.finalizeProps());
        }

        @Override
        public Object get(GenericGeomSrc genericGeomSrc) {
            int n = genericGeomSrc.getGeom().getNumPrims(7);
            Color[] colorArray = new Color[n];
            for (int i = 0; i < n; ++i) {
                colorArray[i] = genericGeomSrc.getDisplayProps().get(i).getColor();
            }
            return colorArray;
        }

        @Override
        public boolean equal(Color[] colorArray, Color[] colorArray2) {
            return Arrays.equals(colorArray, colorArray2);
        }
    };

    public GenericGeomSrc(String string, IGeom iGeom, IPropsSrc iPropsSrc) {
        this(string, iGeom, new TexCoordGenerator(new Point3d(0.0, 0.0, 0.0)), iPropsSrc);
    }

    public GenericGeomSrc(String string, IGeom iGeom, ITexCoordGenerator iTexCoordGenerator, IPropsSrc iPropsSrc) {
        super(string);
        this.d_geom = Geometry.finalize(iGeom, true);
        this.d_texGen = iTexCoordGenerator;
        this.d_props = iPropsSrc;
        this.d_visible = true;
    }

    @Override
    public IGeom getGeom() {
        return this.d_geom;
    }

    @Override
    public void setGeom(IGeom iGeom, boolean bl) {
        if (this.d_geom == (iGeom = Geometry.finalize(iGeom, bl))) {
            return;
        }
        this.d_geom = iGeom;
        this.changedEvt(new Object[0]);
    }

    public void setTexCoordGen(ITexCoordGenerator iTexCoordGenerator) {
        if (this.d_texGen == iTexCoordGenerator) {
            return;
        }
        this.d_texGen = iTexCoordGenerator;
        this.changedEvt(new Object[0]);
    }

    public ITexCoordGenerator getTexCoordGen() {
        return this.d_texGen;
    }

    public IPropsSrc getDisplayProps() {
        return this.d_props;
    }

    public void setDisplayProps(IPropsSrc iPropsSrc) {
        this.d_props = iPropsSrc;
        this.changedEvt(new Object[0]);
    }

    @Override
    public AABox getBounds() {
        return this.d_geom.getBoundingBox(new AABox());
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps iDisplayProps) {
        return new DisplayGeom(this.d_geom, this.d_texGen, this.d_props);
    }

    @Override
    public boolean isVisible() {
        return this.d_visible;
    }

    @Override
    public void setVisible(boolean bl) {
        if (this.d_visible == bl) {
            return;
        }
        this.d_visible = bl;
        this.changedEvt(PyroMod.EVT_VISIBILITY_CHANGED);
    }

    @Override
    public void pickPoints(IIsectCollector iIsectCollector, IIsectFilter iIsectFilter, Point3d point3d, Point3d point3d2, Vector3d vector3d, ITest<AABox> iTest) {
        if (!iIsectFilter.acceptPickObject(this)) {
            return;
        }
        this.d_geom.pickPoints(iIsectCollector, iIsectFilter, this, point3d, point3d2, vector3d, iTest);
    }

    @Override
    public void pickBox(IBoxCollector iBoxCollector, IIsectFilter iIsectFilter, ConvexHull convexHull) {
        if (!iIsectFilter.acceptPickObject(this)) {
            return;
        }
        if (this.d_geom.intersectsBox(this, iIsectFilter, convexHull)) {
            iBoxCollector.add(this);
        }
    }

    @Override
    public void getAll(IBoxCollector iBoxCollector, IIsectFilter iIsectFilter) {
        if (iIsectFilter.acceptPickObject(this)) {
            iBoxCollector.add(this);
        }
    }
}

