/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.geom;

import java.io.Serializable;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2012_1.ILegacy_2012_1;
import pyrosim.legacy_2012_1.LegacyDictionary_2012_1;
import pyrosim.legacy_2012_1.geom.Geometry;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitAABox;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitPoint3D;
import thunderheadeng.geometry.objs.Point;

public class FreePointLoc
implements Serializable,
ILegacy_2012_1 {
    static final long serialVersionUID = 1L;
    public final UnitPoint3D d_location;
    public final Vector3d d_orientation;
    public final UnitDouble d_rotation;
    private static final Vector3d s_baseRotVec = new Vector3d(0.0, 0.0, -1.0);

    public FreePointLoc() {
        this(Geometry.UP3D_ZERO);
    }

    public FreePointLoc(UnitPoint3D unitPoint3D) {
        this(unitPoint3D, new Vector3d(0.0, 0.0, -1.0));
    }

    public FreePointLoc(UnitPoint3D unitPoint3D, Vector3d vector3d) {
        this(unitPoint3D, vector3d, new UnitDouble(0.0, NonSI.DEGREE_ANGLE));
    }

    public FreePointLoc(UnitPoint3D unitPoint3D, Vector3d vector3d, UnitDouble unitDouble) {
        this.d_location = unitPoint3D;
        this.d_orientation = vector3d;
        this.d_rotation = unitDouble;
    }

    @Override
    public pyrosim.domain.geom.FreePointLoc fromLegacy(LegacyDictionary_2012_1 legacyDictionary_2012_1) {
        return new pyrosim.domain.geom.FreePointLoc(new Point(this.d_location.fromLegacy(legacyDictionary_2012_1).getPoint3dValue(Geometry.LU)), this.d_orientation, this.d_rotation.fromLegacy(legacyDictionary_2012_1));
    }

    public FreePointLoc setLoc(Point3d point3d) {
        return new FreePointLoc(new UnitPoint3D(point3d, Geometry.LU), this.d_orientation, this.d_rotation);
    }

    public Matrix4d toTransform() {
        Matrix4d matrix4d = new Matrix4d();
        matrix4d.setIdentity();
        matrix4d.setTranslation(this.d_location.getVector3dValue(Geometry.LU));
        if (!s_baseRotVec.equals(this.d_orientation)) {
            Vector3d vector3d = Util3D.cross(s_baseRotVec, this.d_orientation);
            double d = s_baseRotVec.angle(this.d_orientation);
            matrix4d.mul(Util.rotMat(vector3d.x, vector3d.y, vector3d.z, d));
        }
        return matrix4d;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FreePointLoc)) {
            return false;
        }
        FreePointLoc freePointLoc = (FreePointLoc)object;
        return this.d_location.equals(freePointLoc.d_location) && this.d_orientation.equals(freePointLoc.d_orientation) && this.d_rotation.equals(freePointLoc.d_rotation);
    }

    public int hashCode() {
        return 16851725 + this.d_location.hashCode() + this.d_orientation.hashCode() + this.d_rotation.hashCode();
    }

    public void getBounds(AABox aABox, Unit unit) {
        aABox.add(this.d_location.getValue(unit));
    }

    public UnitAABox getBounds() {
        AABox aABox = new AABox();
        this.getBounds(aABox, Geometry.LU);
        return new UnitAABox(aABox, Geometry.LU);
    }

    public FreePointLoc transform(Matrix4d matrix4d) {
        UnitPoint3D unitPoint3D = Geometry.xform(matrix4d, this.d_location);
        Vector3d vector3d = Util3D.xform(matrix4d, this.d_orientation);
        vector3d.normalize();
        return new FreePointLoc(unitPoint3D, vector3d, this.d_rotation);
    }
}

