/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.geom;

import java.util.ArrayList;
import pyrosim.legacy_2012_1.domain.geom.FDSObject;
import pyrosim.legacy_2012_1.domain.geom.TexOrigin;
import pyrosim.legacy_2012_1.domain.rasterization.FDSObjectRasterization;
import pyrosim.legacy_2012_1.domain.rasterization.FDSRasterization;
import pyrosim.legacy_2012_1.domain.rasterization.FaceProps;
import pyrosim.legacy_2012_1.geom.IPyroDisplayProps;
import pyrosim.legacy_2012_1.geom.TexCoordGenerator;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.GeomGroup;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.DisplayGeom;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPrimProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPropsSrc;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.ITexCoordGenerator;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.PropsBuilder;
import pyrosim.legacy_2012_1.thunderheadeng.util.Pair;

public class FDSUtil {
    public static DisplayGeom getRastDisplay(IPyroDisplayProps iPyroDisplayProps, FDSObject fDSObject, TexOrigin texOrigin) {
        if (iPyroDisplayProps == null || iPyroDisplayProps.getRasterizer() == null || !iPyroDisplayProps.getRasterizer().shouldRasterize(fDSObject)) {
            return null;
        }
        FDSRasterization fDSRasterization = iPyroDisplayProps.getRasterizer();
        FDSObjectRasterization fDSObjectRasterization = fDSRasterization.rasterize(fDSObject);
        if (fDSObjectRasterization == null) {
            return DisplayGeom.EMPTY;
        }
        ArrayList arrayList = new ArrayList(fDSObjectRasterization.geoms.length);
        PropsBuilder propsBuilder = new PropsBuilder();
        for (Pair<IGeom, FaceProps[]> pair : fDSObjectRasterization.geoms) {
            arrayList.add(pair.v1);
            if (((FaceProps[])pair.v2).length == 1) {
                IPrimProps iPrimProps = fDSObjectRasterization.fragGen.generateDisplayProps(((FaceProps[])pair.v2)[0]);
                int n = ((IGeom)pair.v1).getNumPrims(1);
                propsBuilder.add(iPrimProps, n);
                continue;
            }
            for (FaceProps faceProps : (FaceProps[])pair.v2) {
                propsBuilder.add(fDSObjectRasterization.fragGen.generateDisplayProps(faceProps), false);
            }
        }
        IPropsSrc iPropsSrc = propsBuilder.finalizeProps();
        GeomGroup geomGroup = new GeomGroup(arrayList);
        TexCoordGenerator texCoordGenerator = new TexCoordGenerator(geomGroup, texOrigin);
        return new DisplayGeom((IGeom)geomGroup, (ITexCoordGenerator)texCoordGenerator, iPropsSrc);
    }
}

