/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.devices.sprayers;

import java.io.Serializable;
import java.util.Set;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.dependencies.DLink;
import pyrosim.legacy_2012_1.domain.dependencies.DepList;
import pyrosim.legacy_2012_1.domain.dependencies.IDirectDependent;
import pyrosim.legacy_2012_1.domain.devices.detectors.SprinklerLinkModel;
import pyrosim.legacy_2012_1.domain.devices.sprayers.ASprayer;
import pyrosim.legacy_2012_1.domain.devices.sprayers.DryPipe;
import pyrosim.legacy_2012_1.domain.devices.sprayers.SprayModel;
import pyrosim.legacy_2012_1.domain.geom.FreePointLoc;
import pyrosim.legacy_2012_1.domain.quantity.IQuantity;
import pyrosim.legacy_2012_1.domain.quantity.Quantity;
import pyrosim.legacy_2012_1.domain.quantity.QuantityReplacer;
import pyrosim.legacy_2012_1.domain.quantity.QuantityType;
import pyrosim.legacy_2012_1.domain.quantity.QuantityUtil;
import pyrosim.legacy_2012_1.domain.tasks.AReplaceRefTask;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObjectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;
import pyrosim.legacy_2012_1.unitsystem.SIUS;
import pyrosim.legacy_2012_1.util.Util;

public class Sprinkler
extends ASprayer
implements IDirectDependent {
    static final long serialVersionUID = 1L;
    private LinkModel d_linkModel;
    private DryPipe d_dryPipe;

    public Sprinkler(String string, SprayModel sprayModel, LinkModel linkModel, FreePointLoc freePointLoc) {
        super(string, sprayModel, freePointLoc);
        this.d_linkModel = linkModel;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Sprinkler)) {
            return false;
        }
        Sprinkler sprinkler = (Sprinkler)object;
        return super.equals(object) && this.d_linkModel.equals(sprinkler.d_linkModel) && theUtil.equal(this.d_dryPipe, sprinkler.d_dryPipe);
    }

    public DryPipe getDryPipe() {
        return this.d_dryPipe;
    }

    public void setDryPipe(DryPipe dryPipe) {
        this.d_dryPipe = dryPipe;
        this.changedEvt(new Object[0]);
    }

    public LinkModel getLinkModel() {
        return this.d_linkModel;
    }

    public void setLinkModel(LinkModel linkModel) {
        this.d_linkModel = linkModel;
        this.changedEvt(new Object[0]);
    }

    public Task taskSetLinkModel(LinkModel linkModel) {
        return new AReplaceRefTask<LinkModel>((Object)this.d_linkModel, (Object)linkModel){

            @Override
            protected void set(LinkModel linkModel) {
                Sprinkler.this.setLinkModel(linkModel);
            }
        };
    }

    @Override
    public void takeDepSnapshot(DepList depList) {
        super.takeDepSnapshot(depList);
        if (this.d_linkModel instanceof TraditionalModel) {
            depList.add(DLink.STRONG, (IPyroObject)((TraditionalModel)this.d_linkModel).d_link);
        } else {
            QuantityUtil.takeDepSnapshot(depList, DLink.STRONG, ((QuantityModel)this.d_linkModel).d_quantity);
        }
        depList.add(DLink.WEAK, (IPyroObject)this.d_dryPipe);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T t, Set<T> set) {
        if (t instanceof SprinklerLinkModel) {
            Util.removeAllNotOfType(set, SprinklerLinkModel.class);
        } else if (t instanceof DryPipe) {
            Util.removeAllNotOfType(set, DryPipe.class);
        } else if (this.d_linkModel instanceof QuantityModel && QuantityUtil.isQuantityRef(t, ((QuantityModel)this.d_linkModel).d_quantity)) {
            QuantReplacer quantReplacer = new QuantReplacer();
            quantReplacer.removeInvalidReplacements(t, set, ((QuantityModel)this.d_linkModel).d_quantity);
        } else {
            super.removeInvalidReplacements(t, set);
        }
    }

    @Override
    public Task taskReplaceDep(IPyroObject iPyroObject, IPyroObject iPyroObject2) {
        if (iPyroObject instanceof SprinklerLinkModel) {
            assert (iPyroObject2 != null);
            TraditionalModel traditionalModel = new TraditionalModel((SprinklerLinkModel)iPyroObject2);
            return this.taskSetLinkModel(traditionalModel);
        }
        if (iPyroObject instanceof DryPipe) {
            return new AReplaceRefTask<DryPipe>((Object)iPyroObject, (Object)iPyroObject2){

                @Override
                protected void set(DryPipe dryPipe) {
                    Sprinkler.this.setDryPipe(dryPipe);
                }
            };
        }
        if (this.d_linkModel instanceof QuantityModel && QuantityUtil.isQuantityRef(iPyroObject, ((QuantityModel)this.d_linkModel).d_quantity)) {
            QuantReplacer quantReplacer = new QuantReplacer();
            return quantReplacer.taskReplaceDep(iPyroObject, iPyroObject2, ((QuantityModel)this.d_linkModel).d_quantity);
        }
        return super.taskReplaceDep(iPyroObject, iPyroObject2);
    }

    public static class QuantityModel
    extends LinkModel {
        static final long serialVersionUID = 1L;
        public final IQuantity d_quantity;
        public final UnitDouble d_setPoint;

        public QuantityModel(IQuantity iQuantity, UnitDouble unitDouble) {
            this(iQuantity, unitDouble, false, true);
        }

        public QuantityModel(IQuantity iQuantity, UnitDouble unitDouble, boolean bl, boolean bl2) {
            super(bl, bl2);
            this.d_quantity = iQuantity;
            this.d_setPoint = unitDouble;
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof QuantityModel)) {
                return false;
            }
            QuantityModel quantityModel = (QuantityModel)object;
            return this.d_quantity.equals(quantityModel.d_quantity) && this.d_setPoint.equals(quantityModel.d_setPoint);
        }

        @Override
        public int hashCode() {
            return super.hashCode() + 1647607715 + this.d_quantity.hashCode() + this.d_setPoint.hashCode();
        }

        public static int getOutputType() {
            return 1;
        }

        public static QuantityType getQuantityType() {
            return QuantityType.GAS;
        }

        public static IObjectFilter<Quantity> getQuantityFilter() {
            return new QuantityUtil.TypeFilter(QuantityModel.getOutputType(), new QuantityType[]{QuantityModel.getQuantityType()}){

                @Override
                public boolean shouldFilter(Quantity quantity) {
                    if (quantity == Quantity.TIME) {
                        return false;
                    }
                    return super.shouldFilter(quantity);
                }
            };
        }
    }

    public static class TraditionalModel
    extends LinkModel {
        static final long serialVersionUID = 1L;
        public final SprinklerLinkModel d_link;

        public TraditionalModel(SprinklerLinkModel sprinklerLinkModel) {
            this(sprinklerLinkModel, false, true);
        }

        public TraditionalModel(SprinklerLinkModel sprinklerLinkModel, boolean bl, boolean bl2) {
            super(bl, bl2);
            this.d_link = sprinklerLinkModel;
        }

        @Override
        public boolean equals(Object object) {
            return object == this || object instanceof TraditionalModel && this.d_link.equals(((TraditionalModel)object).d_link);
        }

        @Override
        public int hashCode() {
            return super.hashCode() + 864318175 + this.d_link.hashCode();
        }
    }

    public static abstract class LinkModel
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final boolean d_initState;
        public final boolean d_latch;

        public LinkModel(boolean bl, boolean bl2) {
            this.d_initState = bl;
            this.d_latch = bl2;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof LinkModel)) {
                return false;
            }
            LinkModel linkModel = (LinkModel)object;
            return this.d_initState == linkModel.d_initState && this.d_latch == linkModel.d_latch;
        }

        public int hashCode() {
            return 9602042 + theUtil.hashCode(this.d_initState) + theUtil.hashCode(this.d_latch);
        }
    }

    private class QuantReplacer
    extends QuantityReplacer {
        public QuantReplacer() {
            super((PyroMod)Sprinkler.this.getDomain());
        }

        @Override
        protected Task taskReplaceQuant(IQuantity iQuantity, IQuantity iQuantity2) {
            Unit unit;
            assert (iQuantity2 != null);
            QuantityModel quantityModel = (QuantityModel)Sprinkler.this.d_linkModel;
            Unit unit2 = quantityModel.d_setPoint.getUnit();
            UnitDouble unitDouble = pyrosim.legacy_2012_1.domain.signals.Util.areCompatible(unit2, unit = SIUS.unit(iQuantity2.get().unitType)) ? quantityModel.d_setPoint : new UnitDouble(quantityModel.d_setPoint.getValueNoUnit(), unit);
            QuantityModel quantityModel2 = new QuantityModel(iQuantity2, unitDouble);
            return Sprinkler.this.taskSetLinkModel(quantityModel2);
        }
    }
}

