/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.devices.sprayers;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.NamedPyroObject;
import pyrosim.legacy_2012_1.domain.TimeBasedValue;
import pyrosim.legacy_2012_1.domain.TimeFunction;
import pyrosim.legacy_2012_1.domain.dependencies.DLink;
import pyrosim.legacy_2012_1.domain.dependencies.DepList;
import pyrosim.legacy_2012_1.domain.dependencies.IDirectDependent;
import pyrosim.legacy_2012_1.domain.devices.IDeviceModel;
import pyrosim.legacy_2012_1.domain.particle.Particle;
import pyrosim.legacy_2012_1.domain.ramp.IRampInput;
import pyrosim.legacy_2012_1.domain.ramp.Ramp;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.AUndoableTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObjectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;
import pyrosim.legacy_2012_1.unitsystem.SIUS;
import pyrosim.legacy_2012_1.util.Util;

public class SprayModel
extends NamedPyroObject
implements IDirectDependent,
IDeviceModel {
    static final long serialVersionUID = 1L;
    private Particle d_particle;
    private String d_fyi;
    private UnitDouble d_sprayOffset;
    private FlowRate d_flowRate;
    private List<Jet> d_jets;
    private int d_dropsPerSecond;
    private UnitDouble d_dtInsert;

    public SprayModel(String string, Particle particle) {
        this(string, particle, new UnitDouble(0.05, SI.METER), (FlowRate)new ExplicitFlowRate(), 5000, new UnitDouble(0.01, SI.SECOND), new Jet());
    }

    public SprayModel(String string, Particle particle, UnitDouble unitDouble, FlowRate flowRate, int n, UnitDouble unitDouble2, Jet ... jetArray) {
        this(string, particle, unitDouble, flowRate, n, unitDouble2, Arrays.asList(jetArray));
    }

    public SprayModel(String string, Particle particle, UnitDouble unitDouble, FlowRate flowRate, int n, UnitDouble unitDouble2, List<Jet> list) {
        super(string);
        this.d_sprayOffset = unitDouble;
        this.d_particle = particle;
        this.d_flowRate = flowRate;
        this.d_dropsPerSecond = n;
        assert (!list.isEmpty());
        this.d_jets = list;
        this.d_dtInsert = unitDouble2 == null ? new UnitDouble(0.01, SI.SECOND) : unitDouble2;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.d_dtInsert == null) {
            this.d_dtInsert = new UnitDouble(0.01, SI.SECOND);
        }
    }

    public String getFYI() {
        return this.d_fyi == null ? "" : this.d_fyi;
    }

    public void setFYI(String string) {
        this.d_fyi = string;
        this.changedEvt(new Object[0]);
    }

    public UnitDouble getDtInsert() {
        return this.d_dtInsert;
    }

    public void setDtInsert(UnitDouble unitDouble) {
        this.d_dtInsert = unitDouble;
    }

    public int getDropsPerSecond() {
        return this.d_dropsPerSecond;
    }

    public void setDropsPerSecond(int n) {
        this.d_dropsPerSecond = n;
        this.changedEvt(new Object[0]);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return super.equals(object) && this.propEquals(object);
    }

    public boolean propEquals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SprayModel)) {
            return false;
        }
        SprayModel sprayModel = (SprayModel)object;
        return this.d_sprayOffset.equals(sprayModel.d_sprayOffset) && this.d_flowRate.equals(sprayModel.d_flowRate) && this.d_jets.equals(sprayModel.d_jets) && this.d_particle.equals(sprayModel.d_particle);
    }

    public int propHash() {
        return this.d_sprayOffset.hashCode() + this.d_flowRate.hashCode() + this.d_jets.hashCode() + this.d_particle.hashCode();
    }

    public static boolean isParticleValid(Particle particle) {
        return particle != null && !particle.isMassless();
    }

    public static IObjectFilter<Particle> getParticleFilter() {
        return new IObjectFilter<Particle>(){

            @Override
            public boolean shouldFilter(Particle particle) {
                return particle.isMassless();
            }
        };
    }

    public UnitDouble getSprayOffset() {
        return this.d_sprayOffset;
    }

    public void setSprayOffset(UnitDouble unitDouble) {
        this.d_sprayOffset = unitDouble;
        this.changedEvt(new Object[0]);
    }

    public Particle getParticle() {
        return this.d_particle;
    }

    public void setParticle(Particle particle) {
        assert (SprayModel.isParticleValid(particle));
        this.d_particle = particle;
        this.changedEvt(new Object[0]);
    }

    public void setFlowRate(FlowRate flowRate) {
        this.d_flowRate = flowRate;
        this.changedEvt(new Object[0]);
    }

    public FlowRate getFlowRate() {
        return this.d_flowRate;
    }

    public List<Jet> getJets() {
        return Collections.unmodifiableList(this.d_jets);
    }

    public void setJets(List<Jet> list) {
        this.d_jets = list;
        this.changedEvt(new Object[0]);
    }

    @Override
    public void takeDepSnapshot(DepList depList) {
        depList.add(DLink.STRONG, (IPyroObject)this.d_particle);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T t, Set<T> set) {
        Util.removeAllNotOfType(set, Particle.class);
        Iterator<T> iterator = set.iterator();
        while (iterator.hasNext()) {
            Particle particle = (Particle)iterator.next();
            if (particle == null || SprayModel.isParticleValid(particle)) continue;
            iterator.remove();
        }
    }

    @Override
    public Task taskReplaceDep(final IPyroObject iPyroObject, final IPyroObject iPyroObject2) {
        if (iPyroObject != this.getParticle()) {
            return null;
        }
        assert (iPyroObject2 != null);
        return new AUndoableTask(){

            @Override
            public void undo() {
                SprayModel.this.setParticle((Particle)iPyroObject);
            }

            @Override
            public void run() {
                SprayModel.this.setParticle((Particle)iPyroObject2);
            }
        };
    }

    public static class Jet
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final UnitDouble d_velocity;
        public final UnitDouble d_orificeDiam;
        public final double d_flowFrac;
        public final UnitDouble d_long1;
        public final UnitDouble d_long2;
        public final UnitDouble d_lat1;
        public final UnitDouble d_lat2;

        public Jet() {
            this(SIUS.newud(5.0, 8), null, 1.0, new UnitDouble(60.0, NonSI.DEGREE_ANGLE), new UnitDouble(75.0, NonSI.DEGREE_ANGLE));
        }

        public Jet(UnitDouble unitDouble, UnitDouble unitDouble2, double d, UnitDouble unitDouble3, UnitDouble unitDouble4) {
            this(unitDouble, unitDouble2, d, new UnitDouble(0.0, NonSI.DEGREE_ANGLE), new UnitDouble(360.0, NonSI.DEGREE_ANGLE), unitDouble3, unitDouble4);
        }

        public Jet(UnitDouble unitDouble, UnitDouble unitDouble2, double d, UnitDouble unitDouble3, UnitDouble unitDouble4, UnitDouble unitDouble5, UnitDouble unitDouble6) {
            this.d_velocity = unitDouble;
            this.d_orificeDiam = unitDouble2;
            this.d_flowFrac = d;
            this.d_long1 = unitDouble3;
            this.d_long2 = unitDouble4;
            this.d_lat1 = unitDouble5;
            this.d_lat2 = unitDouble6;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Jet)) {
                return false;
            }
            Jet jet = (Jet)object;
            return this.d_flowFrac == jet.d_flowFrac && theUtil.equal(this.d_velocity, jet.d_velocity) && theUtil.equal(this.d_orificeDiam, jet.d_orificeDiam) && this.d_long1.equals(jet.d_long1) && this.d_long2.equals(jet.d_long2) && this.d_lat1.equals(jet.d_lat1) && this.d_lat2.equals(jet.d_lat2);
        }

        public int hashCode() {
            return theUtil.hashCode(this.d_flowFrac) + theUtil.hashCode(this.d_velocity) + theUtil.hashCode(this.d_orificeDiam) + this.d_long1.hashCode() + this.d_long2.hashCode() + this.d_lat1.hashCode() + this.d_lat2.hashCode();
        }
    }

    public static class VaryingFlowRate
    extends FlowRate {
        static final long serialVersionUID = 1L;
        public static final ActiveSprkRamp DEF_RAMP_INPUT = new ActiveSprkRamp();
        public final Ramp d_pressureRamp;
        public final UnitDouble d_opPressure;
        public final UnitDouble d_kFactor;
        public final UnitDouble d_rate;

        public VaryingFlowRate(Ramp ramp, UnitDouble unitDouble, UnitDouble unitDouble2, UnitDouble unitDouble3, TimeFunction timeFunction) {
            super(timeFunction);
            this.d_opPressure = unitDouble;
            this.d_kFactor = unitDouble2;
            this.d_rate = unitDouble3;
            this.d_pressureRamp = ramp;
            assert (this.isValid());
        }

        public boolean isValid() {
            if (this.d_pressureRamp.getTUnitType() != 28 || this.d_pressureRamp.getFUnitType() != 39) {
                return false;
            }
            int n = 0;
            if (this.d_opPressure != null) {
                ++n;
            }
            if (this.d_kFactor != null) {
                ++n;
            }
            if (this.d_rate != null) {
                ++n;
            }
            return n >= 2;
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof VaryingFlowRate)) {
                return false;
            }
            VaryingFlowRate varyingFlowRate = (VaryingFlowRate)object;
            return super.equals(object) && theUtil.equal(this.d_opPressure, varyingFlowRate.d_opPressure) && theUtil.equal(this.d_kFactor, varyingFlowRate.d_kFactor) && theUtil.equal(this.d_rate, varyingFlowRate.d_rate) && this.d_ramp.equals(varyingFlowRate.d_ramp);
        }

        @Override
        public int hashCode() {
            return super.hashCode() + theUtil.hashCode(this.d_opPressure) + theUtil.hashCode(this.d_kFactor) + theUtil.hashCode(this.d_rate) + this.d_ramp.hashCode();
        }

        private static class ActiveSprkRamp
        implements IRampInput {
            static final long serialVersionUID = 1L;

            private ActiveSprkRamp() {
            }

            @Override
            public String getName() {
                return Intl.intl("Num Active Sprinklers/Nozzles");
            }

            @Override
            public int getUnitType() {
                return 28;
            }

            private Object readResolve() throws ObjectStreamException {
                return DEF_RAMP_INPUT;
            }

            @Override
            public String getTVar() {
                return "T";
            }
        }
    }

    public static class PressurizedFlowRate
    extends FlowRate {
        static final long serialVersionUID = 1L;
        public final UnitDouble d_opPressure;
        public final UnitDouble d_kFactor;

        public PressurizedFlowRate() {
            this(SIUS.newud(1.0, 59), SIUS.newud(1.0, 58), new TimeFunction.TanH(new UnitDouble(0.0, SI.SECOND)));
        }

        public PressurizedFlowRate(UnitDouble unitDouble, UnitDouble unitDouble2, TimeFunction timeFunction) {
            super(timeFunction);
            this.d_opPressure = unitDouble;
            this.d_kFactor = unitDouble2;
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof PressurizedFlowRate)) {
                return false;
            }
            PressurizedFlowRate pressurizedFlowRate = (PressurizedFlowRate)object;
            return super.equals(object) && this.d_opPressure.equals(pressurizedFlowRate.d_opPressure) && this.d_kFactor.equals(pressurizedFlowRate.d_kFactor);
        }

        @Override
        public int hashCode() {
            return super.hashCode() + this.d_opPressure.hashCode() + this.d_kFactor.hashCode();
        }
    }

    public static class ExplicitFlowRate
    extends FlowRate {
        static final long serialVersionUID = 1L;
        public final UnitDouble d_rate;

        public ExplicitFlowRate() {
            this(new TimeBasedValue<UnitDouble>(SIUS.newud(1.0, 30), new TimeFunction.TanH(new UnitDouble(0.0, SI.SECOND))));
        }

        public ExplicitFlowRate(TimeBasedValue<UnitDouble> timeBasedValue) {
            this((UnitDouble)timeBasedValue.val, timeBasedValue.func);
        }

        public ExplicitFlowRate(UnitDouble unitDouble, TimeFunction timeFunction) {
            super(timeFunction);
            this.d_rate = unitDouble;
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof ExplicitFlowRate)) {
                return false;
            }
            ExplicitFlowRate explicitFlowRate = (ExplicitFlowRate)object;
            return super.equals(object) && this.d_rate.equals(explicitFlowRate.d_rate);
        }

        @Override
        public int hashCode() {
            return super.hashCode() + this.d_rate.hashCode();
        }
    }

    public static abstract class FlowRate
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final TimeFunction d_ramp;

        public FlowRate(TimeFunction timeFunction) {
            this.d_ramp = timeFunction;
        }

        public boolean equals(Object object) {
            return object instanceof FlowRate && this.d_ramp.equals(((FlowRate)object).d_ramp);
        }

        public int hashCode() {
            return this.d_ramp.hashCode();
        }
    }
}

