/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.devices.sprayers;

import java.util.Arrays;
import java.util.List;
import org.jscience.physics.units.SI;
import pyrosim.legacy_2012_1.domain.devices.ADevice;
import pyrosim.legacy_2012_1.domain.devices.ISinkDevice;
import pyrosim.legacy_2012_1.domain.devices.ISourceDevice;
import pyrosim.legacy_2012_1.domain.signals.IOutPin;
import pyrosim.legacy_2012_1.domain.signals.LogicOutPin;
import pyrosim.legacy_2012_1.domain.signals.MultiLogicInPin;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.EmptyGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.DisplayGeom;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IDisplayProps;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;

public class DryPipe
extends ADevice
implements ISourceDevice,
ISinkDevice {
    static final long serialVersionUID = 1L;
    private MultiLogicInPin d_inPin;
    private LogicOutPin d_outPin;
    private UnitDouble d_depressDelay;

    public DryPipe(String string) {
        this(string, new UnitDouble(30.0, SI.SECOND));
    }

    public DryPipe(String string, UnitDouble unitDouble) {
        super(string);
        this.d_depressDelay = unitDouble;
        this.d_inPin = new MultiLogicInPin(this, Integer.MAX_VALUE);
        this.d_outPin = new LogicOutPin(this);
    }

    @Override
    public Object clone() {
        DryPipe dryPipe = (DryPipe)super.clone();
        dryPipe.d_inPin = (MultiLogicInPin)this.d_inPin.clone(dryPipe);
        dryPipe.d_outPin = (LogicOutPin)this.d_outPin.clone(dryPipe);
        return dryPipe;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DryPipe)) {
            return false;
        }
        DryPipe dryPipe = (DryPipe)object;
        return super.equals(object) && this.d_depressDelay.equals(dryPipe.d_depressDelay) && this.d_inPin.equals(dryPipe.d_inPin);
    }

    public UnitDouble getDelay() {
        return this.d_depressDelay;
    }

    public void setDelay(UnitDouble unitDouble) {
        this.d_depressDelay = unitDouble;
        this.changedEvt(new Object[0]);
    }

    @Override
    public MultiLogicInPin getInputPin() {
        return this.d_inPin;
    }

    public LogicOutPin getOutputPin() {
        return this.d_outPin;
    }

    @Override
    public List<? extends IOutPin> getOutputPins() {
        return Arrays.asList(this.d_outPin);
    }

    @Override
    public IGeom getGeom() {
        return EmptyGeom.INSTANCE;
    }

    @Override
    public void setGeom(IGeom iGeom, boolean bl) {
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps iDisplayProps) {
        return DisplayGeom.EMPTY;
    }
}

