/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.devices.measurers;

import java.io.IOException;
import java.io.ObjectInputStream;
import org.jscience.physics.units.SI;
import pyrosim.legacy_2012_1.domain.devices.measurers.GasPointMeasurer;
import pyrosim.legacy_2012_1.domain.geom.FreePointLoc;
import pyrosim.legacy_2012_1.domain.quantity.Quantity;
import pyrosim.legacy_2012_1.io.PyroSimObjectInputStream;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.unitsystem.SIUS;

public class Thermocouple
extends GasPointMeasurer {
    static final long serialVersionUID = 1L;
    private UnitDouble d_beadDiameter;
    private double d_emissivity;
    private UnitDouble d_beadDensity;
    private UnitDouble d_beadSpecHeat;

    public Thermocouple(String string, FreePointLoc freePointLoc) {
        this(string, new UnitDouble(0.001, SI.METER), 0.85, SIUS.newud(8908.0, 4), SIUS.newud(0.44, 11), freePointLoc);
    }

    public Thermocouple(String string, UnitDouble unitDouble, double d, UnitDouble unitDouble2, UnitDouble unitDouble3, FreePointLoc freePointLoc) {
        super(string, Quantity.THERMOCOUPLE.create(), freePointLoc);
        this.d_beadDiameter = unitDouble;
        this.d_emissivity = d;
        this.d_beadDensity = unitDouble2;
        this.d_beadSpecHeat = unitDouble3;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Thermocouple)) {
            return false;
        }
        Thermocouple thermocouple = (Thermocouple)object;
        return super.equals(object) && this.d_emissivity == thermocouple.d_emissivity && this.d_beadDiameter.equals(thermocouple.d_beadDiameter) && this.d_beadDensity.equals(thermocouple.d_beadDensity) && this.d_beadSpecHeat.equals(thermocouple.d_beadSpecHeat);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (PyroSimObjectInputStream.getVersion(objectInputStream) < 38) {
            this.d_beadDensity = SIUS.newud(8908.0, 4);
            this.d_beadSpecHeat = SIUS.newud(0.44, 11);
        }
    }

    public void setBeadDiameter(UnitDouble unitDouble) {
        this.d_beadDiameter = unitDouble;
        this.changedEvt(new Object[0]);
    }

    public UnitDouble getBeadDiameter() {
        return this.d_beadDiameter;
    }

    public void setEmissivity(double d) {
        this.d_emissivity = d;
        this.changedEvt(new Object[0]);
    }

    public double getEmissivity() {
        return this.d_emissivity;
    }

    public void setBeadDensity(UnitDouble unitDouble) {
        this.d_beadDensity = unitDouble;
        this.changedEvt(new Object[0]);
    }

    public UnitDouble getBeadDensity() {
        return this.d_beadDensity;
    }

    public void setBeadSpecHeat(UnitDouble unitDouble) {
        this.d_beadSpecHeat = unitDouble;
        this.changedEvt(new Object[0]);
    }

    public UnitDouble getBeadSpecHeat() {
        return this.d_beadSpecHeat;
    }
}

