/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.devices.measurers;

import org.jscience.physics.units.SI;
import pyrosim.legacy_2012_1.domain.boundcond.mat.Material;
import pyrosim.legacy_2012_1.domain.devices.measurers.SolidPointMeasurer;
import pyrosim.legacy_2012_1.domain.geom.AttachedPointLoc;
import pyrosim.legacy_2012_1.domain.quantity.ObjectQuantity;
import pyrosim.legacy_2012_1.domain.quantity.Quantity;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObjectFilter;
import pyrosim.legacy_2012_1.util.Filters;

public class SolidDensityMeasurer
extends SolidPointMeasurer {
    static final long serialVersionUID = 1L;
    private UnitDouble d_depth;

    public SolidDensityMeasurer(String string, ObjectQuantity<Material> objectQuantity, AttachedPointLoc attachedPointLoc) {
        this(string, objectQuantity, new UnitDouble(0.0, SI.METER), attachedPointLoc);
    }

    public SolidDensityMeasurer(String string, ObjectQuantity<Material> objectQuantity, UnitDouble unitDouble, AttachedPointLoc attachedPointLoc) {
        super(string, objectQuantity, attachedPointLoc);
        this.d_depth = unitDouble;
        assert (objectQuantity.get() == Quantity.MATL_SOLID_DENSITY);
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof SolidDensityMeasurer && super.equals(object) && this.d_depth.equals(((SolidDensityMeasurer)object).d_depth);
    }

    public static IObjectFilter<Quantity> getQuantityFilter() {
        return Filters.acceptOnly(Quantity.MATL_SOLID_DENSITY);
    }

    public UnitDouble getDepth() {
        return this.d_depth;
    }

    public void setDepth(UnitDouble unitDouble) {
        this.d_depth = unitDouble;
        this.changedEvt(new Object[0]);
    }
}

