/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.devices.measurers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.dependencies.DepSnapshot;
import pyrosim.legacy_2012_1.domain.dependencies.Dependency;
import pyrosim.legacy_2012_1.domain.dependencies.IDirectDependent;
import pyrosim.legacy_2012_1.domain.dependencies.SkipDep;
import pyrosim.legacy_2012_1.domain.devices.AlarmInfo;
import pyrosim.legacy_2012_1.domain.devices.TripFlags;
import pyrosim.legacy_2012_1.domain.ramp.Ramp;
import pyrosim.legacy_2012_1.domain.ramp.SignalInput;
import pyrosim.legacy_2012_1.domain.signals.IDoubleOutPin;
import pyrosim.legacy_2012_1.domain.signals.IInPin;
import pyrosim.legacy_2012_1.domain.signals.ILatchable;
import pyrosim.legacy_2012_1.domain.signals.IOutPin;
import pyrosim.legacy_2012_1.domain.signals.ISignalSource;
import pyrosim.legacy_2012_1.domain.signals.LogicOutPin;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class MeasureOutInfo
implements Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    @SkipDep
    private ILatchable d_src;
    private boolean d_enabled;
    private IDoubleOutPin d_pin;
    private LogicOutPin d_alarmPin;
    private AlarmInfo d_alarmInfo;

    public MeasureOutInfo(ILatchable iLatchable, boolean bl, IDoubleOutPin iDoubleOutPin, String string) {
        this.d_src = iLatchable;
        this.d_enabled = bl;
        this.d_pin = iDoubleOutPin;
        this.d_alarmPin = new LogicOutPin(this.d_src, string);
    }

    public void setAlarmInfo(AlarmInfo alarmInfo) {
        if (AlarmInfo.checkAlarmChange(this.d_src, this.d_alarmInfo, alarmInfo, this.d_alarmPin)) {
            this.d_alarmInfo = alarmInfo;
            this.d_src.changedEvt(new Object[0]);
        }
    }

    public boolean latches() {
        return this.d_alarmInfo != null ? TripFlags.latch(this.d_alarmInfo.tripFlags) : false;
    }

    public AlarmInfo getAlarmInfo() {
        return this.d_alarmInfo;
    }

    public IDoubleOutPin getPin() {
        return this.d_pin;
    }

    public LogicOutPin getAlarmPin() {
        return this.d_alarmPin;
    }

    public void legacySetPin(IDoubleOutPin iDoubleOutPin) {
        this.d_pin = iDoubleOutPin;
        this.d_pin.setSource(this.d_src);
    }

    public void legacySetSource(ILatchable iLatchable) {
        this.d_src = iLatchable;
        this.d_pin.setSource(iLatchable);
        this.d_alarmPin.setSource(iLatchable);
    }

    public Object clone(ISignalSource iSignalSource) {
        try {
            MeasureOutInfo measureOutInfo = (MeasureOutInfo)super.clone();
            measureOutInfo.d_pin = (IDoubleOutPin)this.d_pin.clone(iSignalSource);
            measureOutInfo.d_alarmPin = (LogicOutPin)this.d_alarmPin.clone(iSignalSource);
            assert (iSignalSource instanceof ILatchable);
            measureOutInfo.d_src = (ILatchable)iSignalSource;
            return measureOutInfo;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean equals(Object object) {
        return object == this || object instanceof MeasureOutInfo && ((MeasureOutInfo)object).d_enabled == this.d_enabled && theUtil.equal(((MeasureOutInfo)object).d_alarmInfo, this.d_alarmInfo);
    }

    public List<IOutPin> getPins() {
        ArrayList<IOutPin> arrayList = new ArrayList<IOutPin>(2);
        this.getPins(arrayList);
        return arrayList;
    }

    public void getPins(List<IOutPin> list) {
        if (this.d_enabled) {
            list.add(this.d_pin);
            if (this.d_alarmInfo != null) {
                list.add(this.d_alarmPin);
            }
        }
    }

    public boolean isEnabled() {
        return this.d_enabled;
    }

    public void setEnabled(boolean bl) {
        if (bl == this.d_enabled) {
            return;
        }
        this.d_enabled = bl;
        PyroMod pyroMod = (PyroMod)this.d_src.getDomain();
        if (pyroMod != null) {
            pyroMod.pauseUpdates();
        }
        if (!this.d_enabled && pyroMod != null) {
            DepSnapshot depSnapshot = pyroMod.getDependencies(this.d_src);
            Set<Dependency> set = depSnapshot.getDependents(this.d_src);
            for (Dependency dependency : set) {
                IDirectDependent iDirectDependent;
                if (dependency.source instanceof IInPin) {
                    iDirectDependent = (IInPin)dependency.source;
                    iDirectDependent.disconnect(this.d_pin);
                    iDirectDependent.disconnect(this.d_alarmPin);
                    continue;
                }
                if (!(dependency.source instanceof Ramp)) continue;
                iDirectDependent = (Ramp)dependency.source;
                if (((SignalInput)((Ramp)iDirectDependent).getInput()).input != this.d_pin) continue;
                ((Ramp)iDirectDependent).taskSetInput(((Ramp)iDirectDependent).getDefaultInput()).run();
                for (IPyroObject iPyroObject : depSnapshot.getAncestors(IPyroObject.class, this.d_src)) {
                    iPyroObject.changedEvt(new Object[0]);
                }
            }
        }
        this.d_src.changedEvt(new Object[0]);
        if (pyroMod != null) {
            pyroMod.resumeUpdates();
        }
    }
}

