/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.devices.measurers;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.devices.ASourceDevice;
import pyrosim.legacy_2012_1.domain.devices.IBeamDevice;
import pyrosim.legacy_2012_1.domain.devices.measurers.IMeasurer;
import pyrosim.legacy_2012_1.domain.devices.measurers.MeasureOutInfo;
import pyrosim.legacy_2012_1.domain.quantity.IQuantity;
import pyrosim.legacy_2012_1.domain.quantity.Quantity;
import pyrosim.legacy_2012_1.domain.signals.DoubleOutPin;
import pyrosim.legacy_2012_1.domain.signals.ILogicOutPin;
import pyrosim.legacy_2012_1.domain.signals.IOutPin;
import pyrosim.legacy_2012_1.domain.signals.ISignalSource;
import pyrosim.legacy_2012_1.geom.Geometry;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.LineSeg;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.DisplayGeom;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IDisplayProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPrimProps;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitLineSeg3D;

public class LayerMeasurer
extends ASourceDevice
implements IBeamDevice,
IMeasurer {
    static final long serialVersionUID = 1L;
    public static final String HEIGHT_ID = Intl.intl("HEIGHT");
    public static final String LOWERTEMP_ID = Intl.intl("LTEMP");
    public static final String UPPERTEMP_ID = Intl.intl("UTEMP");
    private UnitLineSeg3D d_beam;
    private MeasureOutInfo d_height;
    private MeasureOutInfo d_upperTemp;
    private MeasureOutInfo d_lowerTemp;
    private static final IPrimProps s_primProps = new IPrimProps.Edge(new Color(0.7f, 0.7f, 0.0f), 1.0);

    public LayerMeasurer(String string) {
        this(string, true, false, false, new UnitLineSeg3D(0.0, 0.0, 0.0, 0.0, 0.0, 3.0, SI.METER));
    }

    public LayerMeasurer(String string, boolean bl, boolean bl2, boolean bl3, UnitLineSeg3D unitLineSeg3D) {
        super(string);
        this.d_beam = unitLineSeg3D;
        this.d_height = new MeasureOutInfo(this, bl, new LayerPin((ISignalSource)this, HEIGHT_ID, Quantity.LAYER_HEIGHT.create()), Intl.intl("HT_ALARM"));
        this.d_upperTemp = new MeasureOutInfo(this, bl2, new LayerPin((ISignalSource)this, UPPERTEMP_ID, Quantity.UPPER_TEMPERATURE.create()), Intl.intl("UT_ALARM"));
        this.d_lowerTemp = new MeasureOutInfo(this, bl3, new LayerPin((ISignalSource)this, LOWERTEMP_ID, Quantity.LOWER_TEMPERATURE.create()), Intl.intl("LT_ALARM"));
    }

    @Override
    public boolean latches(ILogicOutPin iLogicOutPin) {
        if (iLogicOutPin == this.d_height.getAlarmPin()) {
            return this.d_height.latches();
        }
        if (iLogicOutPin == this.d_upperTemp.getAlarmPin()) {
            return this.d_upperTemp.latches();
        }
        if (iLogicOutPin == this.d_lowerTemp.getAlarmPin()) {
            return this.d_lowerTemp.latches();
        }
        return false;
    }

    @Override
    public Object clone() {
        LayerMeasurer layerMeasurer = (LayerMeasurer)super.clone();
        layerMeasurer.d_height = (MeasureOutInfo)this.d_height.clone(layerMeasurer);
        layerMeasurer.d_upperTemp = (MeasureOutInfo)this.d_upperTemp.clone(layerMeasurer);
        layerMeasurer.d_lowerTemp = (MeasureOutInfo)this.d_lowerTemp.clone(layerMeasurer);
        return layerMeasurer;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof LayerMeasurer)) {
            return false;
        }
        LayerMeasurer layerMeasurer = (LayerMeasurer)object;
        return super.equals(object) && this.d_height.equals(layerMeasurer.d_height) && this.d_lowerTemp.equals(layerMeasurer.d_lowerTemp) && this.d_upperTemp.equals(layerMeasurer.d_upperTemp) && this.d_beam.equals(layerMeasurer.d_beam);
    }

    @Override
    public int getNumMeasurements() {
        return 3;
    }

    @Override
    public IQuantity getQuantity(int n) {
        switch (n) {
            case 0: {
                return Quantity.LAYER_HEIGHT.create();
            }
            case 1: {
                return Quantity.LOWER_TEMPERATURE.create();
            }
            case 2: {
                return Quantity.UPPER_TEMPERATURE.create();
            }
        }
        return null;
    }

    @Override
    public MeasureOutInfo getMsrInfo(int n) {
        switch (n) {
            case 0: {
                return this.d_height;
            }
            case 1: {
                return this.d_lowerTemp;
            }
            case 2: {
                return this.d_upperTemp;
            }
        }
        return null;
    }

    public MeasureOutInfo getHeightInfo() {
        return this.d_height;
    }

    public MeasureOutInfo getLowerTempInfo() {
        return this.d_lowerTemp;
    }

    public MeasureOutInfo getUpperTempInfo() {
        return this.d_upperTemp;
    }

    @Override
    public List<? extends IOutPin> getOutputPins() {
        ArrayList<IOutPin> arrayList = new ArrayList<IOutPin>(3);
        this.d_height.getPins(arrayList);
        this.d_lowerTemp.getPins(arrayList);
        this.d_upperTemp.getPins(arrayList);
        return arrayList;
    }

    public void setMeasures(boolean bl, boolean bl2, boolean bl3) {
        this.pauseUpdates();
        this.d_height.setEnabled(bl);
        this.d_lowerTemp.setEnabled(bl2);
        this.d_upperTemp.setEnabled(bl3);
        this.resumeUpdates();
    }

    public boolean measureHeight() {
        return this.d_height.isEnabled();
    }

    public boolean measureLowerTemp() {
        return this.d_lowerTemp.isEnabled();
    }

    public boolean measureUpperTemp() {
        return this.d_upperTemp.isEnabled();
    }

    public void setBeam(UnitLineSeg3D unitLineSeg3D) {
        this.d_beam = unitLineSeg3D;
        this.changedEvt(new Object[0]);
    }

    @Override
    public UnitLineSeg3D getBeam() {
        return this.d_beam;
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps iDisplayProps) {
        return new DisplayGeom(this.getGeom(), s_primProps);
    }

    @Override
    public IGeom getGeom() {
        return new LineSeg(this.d_beam.getP1(Geometry.LU), this.d_beam.getP2(Geometry.LU));
    }

    @Override
    public void setGeom(IGeom iGeom, boolean bl) {
        if ((iGeom = Geometry.finalize(iGeom, bl)) instanceof LineSeg) {
            LineSeg lineSeg = (LineSeg)iGeom;
            this.setBeam(new UnitLineSeg3D(lineSeg.p1, lineSeg.p2, Geometry.LU));
        }
    }

    public static class LayerPin
    extends DoubleOutPin {
        static final long serialVersionUID = 5796923347439345807L;
        public final IQuantity d_measurement;

        public LayerPin(ISignalSource iSignalSource, String string, IQuantity iQuantity) {
            super(iSignalSource, string, iQuantity.get().unitType);
            this.d_measurement = iQuantity;
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof LayerPin && super.equals(object) && this.d_measurement.equals(((LayerPin)object).d_measurement);
        }

        @Override
        public int hashCode() {
            return super.hashCode() + -1719520006 + this.d_measurement.hashCode();
        }
    }
}

