/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.devices.measurers;

import java.awt.Color;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2012_1.domain.devices.IAARectDevice;
import pyrosim.legacy_2012_1.domain.devices.measurers.AMeasuringDevc;
import pyrosim.legacy_2012_1.domain.quantity.IQuantity;
import pyrosim.legacy_2012_1.domain.quantity.Quantity;
import pyrosim.legacy_2012_1.domain.quantity.QuantityType;
import pyrosim.legacy_2012_1.domain.quantity.QuantityUtil;
import pyrosim.legacy_2012_1.geom.Geometry;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.GeomConstants;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AARectangle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IDOF;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.DisplayGeom;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IDisplayProps;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPrimProps;
import pyrosim.legacy_2012_1.thunderheadeng.util.HashPool;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObjectFilter;

public class FlowMeasurer
extends AMeasuringDevc
implements IAARectDevice {
    static final long serialVersionUID = 1L;
    public static final int FLOWDIR_POS = 0;
    public static final int FLOWDIR_NEG = 1;
    public static final int FLOWDIR_BOTH = 2;
    private AARectangle d_rect;
    private int d_flowDir;
    private static final IPrimProps s_primProps = new IPrimProps.Face(new Color(1.0f, 1.0f, 0.0f, 0.5f), null, false);

    public FlowMeasurer(String string, IQuantity iQuantity, AARectangle aARectangle, int n) {
        super(string, iQuantity);
        this.d_rect = aARectangle;
        this.d_flowDir = n;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof FlowMeasurer)) {
            return false;
        }
        FlowMeasurer flowMeasurer = (FlowMeasurer)object;
        return super.equals(object) && this.d_flowDir == flowMeasurer.d_flowDir && this.d_rect.equals(flowMeasurer.d_rect);
    }

    private static int toFlowDir(Vector3d vector3d) {
        if (vector3d.epsilonEquals(GeomConstants.VEC3D_XNEG, 1.0E-9) || vector3d.epsilonEquals(GeomConstants.VEC3D_YNEG, 1.0E-9) || vector3d.epsilonEquals(GeomConstants.VEC3D_ZNEG, 1.0E-9)) {
            return 1;
        }
        return 0;
    }

    private static Vector3d toFlowVec(AARectangle aARectangle, int n) {
        switch (aARectangle.d_plane) {
            case 0: {
                switch (n) {
                    case 0: {
                        return GeomConstants.VEC3D_XPOS;
                    }
                    case 1: {
                        return GeomConstants.VEC3D_XNEG;
                    }
                }
                break;
            }
            case 1: {
                switch (n) {
                    case 0: {
                        return GeomConstants.VEC3D_YPOS;
                    }
                    case 1: {
                        return GeomConstants.VEC3D_YNEG;
                    }
                }
                break;
            }
            case 2: {
                switch (n) {
                    case 0: {
                        return GeomConstants.VEC3D_ZPOS;
                    }
                    case 1: {
                        return GeomConstants.VEC3D_ZNEG;
                    }
                }
            }
        }
        return null;
    }

    @Override
    public AARectangle getRect() {
        return this.d_rect;
    }

    public void setRect(AARectangle aARectangle) {
        this.d_rect = aARectangle;
        this.changedEvt(new Object[0]);
    }

    public int getFlowDir() {
        return this.d_flowDir;
    }

    public void setFlowDir(int n) {
        this.d_flowDir = n;
        this.changedEvt(new Object[0]);
    }

    public static QuantityType getQuantityType() {
        return QuantityType.INTEGRATED;
    }

    public static int getOutputType() {
        return 2;
    }

    public static IObjectFilter<Quantity> getQuantityFilter() {
        return new QuantityUtil.TypeFilter(FlowMeasurer.getOutputType(), FlowMeasurer.getQuantityType());
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps iDisplayProps) {
        return new DisplayGeom(this.getGeom(), s_primProps);
    }

    @Override
    public IGeom getGeom() {
        return new FlowMsrGeom(this.d_rect, this.d_flowDir);
    }

    @Override
    public void setGeom(IGeom iGeom, boolean bl) {
        if ((iGeom = Geometry.finalize(iGeom, bl)) instanceof FlowMsrGeom) {
            FlowMsrGeom flowMsrGeom = (FlowMsrGeom)iGeom;
            this.pauseUpdates();
            this.setRect(new AARectangle(flowMsrGeom.d_plane, flowMsrGeom.d_planeVal, flowMsrGeom.d_minx, flowMsrGeom.d_miny, flowMsrGeom.d_maxx, flowMsrGeom.d_maxy));
            this.setFlowDir(flowMsrGeom.flowDir);
            this.resumeUpdates();
        } else if (iGeom instanceof AARectangle) {
            this.setRect((AARectangle)iGeom);
        }
    }

    private static class FlowMsrGeom
    extends AARectangle {
        private static final long serialVersionUID = 1011009642198541349L;
        public final int flowDir;

        public FlowMsrGeom(AARectangle aARectangle, int n) {
            super(aARectangle.d_plane, aARectangle.d_planeVal, aARectangle.d_minx, aARectangle.d_miny, aARectangle.d_maxx, aARectangle.d_maxy);
            this.flowDir = n;
        }

        public FlowMsrGeom optimize(HashPool<Point3d> hashPool) {
            return this;
        }

        @Override
        public IDOF getDOF() {
            return IDOF.ALIGNED;
        }

        @Override
        public FlowMsrGeom transform(Matrix4d matrix4d) {
            AABox aABox = new AABox();
            this.getBoundingBox(aABox);
            Point3d point3d = Util3D.xform(matrix4d, aABox.getMin());
            Point3d point3d2 = Util3D.xform(matrix4d, aABox.getMax());
            AARectangle aARectangle = AARectangle.construct(point3d, point3d2);
            int n = this.flowDir;
            if (this.flowDir != 2) {
                Vector3d vector3d = FlowMeasurer.toFlowVec(this, this.flowDir);
                vector3d.normalize();
                vector3d = Util3D.xform(matrix4d, vector3d);
                n = FlowMeasurer.toFlowDir(vector3d);
            }
            return new FlowMsrGeom(aARectangle, n);
        }
    }
}

