/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.devices.measurers;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.APyroObject;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.dependencies.DLink;
import pyrosim.legacy_2012_1.domain.dependencies.DepList;
import pyrosim.legacy_2012_1.domain.dependencies.DepSnapshot;
import pyrosim.legacy_2012_1.domain.dependencies.Dependency;
import pyrosim.legacy_2012_1.domain.dependencies.IDirectDependent;
import pyrosim.legacy_2012_1.domain.dependencies.SkipDep;
import pyrosim.legacy_2012_1.domain.devices.ASourceDevice;
import pyrosim.legacy_2012_1.domain.devices.measurers.IMeasurer;
import pyrosim.legacy_2012_1.domain.devices.measurers.MeasureOutInfo;
import pyrosim.legacy_2012_1.domain.quantity.IQuantity;
import pyrosim.legacy_2012_1.domain.quantity.QuantityReplacer;
import pyrosim.legacy_2012_1.domain.quantity.QuantityUtil;
import pyrosim.legacy_2012_1.domain.signals.IDoubleInPin;
import pyrosim.legacy_2012_1.domain.signals.IDoubleOutPin;
import pyrosim.legacy_2012_1.domain.signals.ILogicOutPin;
import pyrosim.legacy_2012_1.domain.signals.IOutPin;
import pyrosim.legacy_2012_1.domain.signals.ISignalSource;
import pyrosim.legacy_2012_1.domain.tasks.AReplaceRefTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;

public abstract class AMeasuringDevc
extends ASourceDevice
implements IDirectDependent,
IMeasurer {
    static final long serialVersionUID = 1L;
    private Object d_outPin;
    private IQuantity d_measurement;

    public AMeasuringDevc(String string, IQuantity iQuantity) {
        super(string);
        this.d_measurement = iQuantity;
        this.d_outPin = this.createOutInfo(new QuantOutPin(this));
    }

    @Override
    public boolean latches(ILogicOutPin iLogicOutPin) {
        return this.getMsrInfo().latches();
    }

    private MeasureOutInfo createOutInfo(QuantOutPin quantOutPin) {
        return new MeasureOutInfo(this, true, quantOutPin, Intl.intl("ALARM"));
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.d_outPin instanceof QuantOutPin) {
            this.d_outPin = this.createOutInfo((QuantOutPin)this.d_outPin);
        }
        ((MeasureOutInfo)this.d_outPin).legacySetSource(this);
    }

    @Override
    public Object clone() {
        AMeasuringDevc aMeasuringDevc = (AMeasuringDevc)super.clone();
        aMeasuringDevc.d_outPin = ((MeasureOutInfo)this.d_outPin).clone(aMeasuringDevc);
        return aMeasuringDevc;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AMeasuringDevc)) {
            return false;
        }
        AMeasuringDevc aMeasuringDevc = (AMeasuringDevc)object;
        return super.equals(aMeasuringDevc) && this.d_measurement.equals(aMeasuringDevc.d_measurement) && this.d_outPin.equals(aMeasuringDevc.d_outPin);
    }

    @Override
    public boolean isMixFracOnly() {
        return this.getQuantity().get().mixFracOnly;
    }

    @Override
    public List<? extends IOutPin> getOutputPins() {
        ArrayList<IOutPin> arrayList = new ArrayList<IOutPin>();
        ((MeasureOutInfo)this.d_outPin).getPins(arrayList);
        return arrayList;
    }

    @Override
    public int getNumMeasurements() {
        return 1;
    }

    public IQuantity getQuantity() {
        return this.d_measurement;
    }

    @Override
    public IQuantity getQuantity(int n) {
        return this.getQuantity();
    }

    public void setQuantity(IQuantity iQuantity, Unit unit) {
        assert (iQuantity != null);
        if (!this.d_measurement.equals(iQuantity)) {
            if (this.getDomain() != null) {
                DepSnapshot depSnapshot = ((PyroMod)this.getDomain()).getDependencies(this);
                Set<Dependency> set = depSnapshot.getDependents(this);
                for (Dependency dependency : set) {
                    if (!(dependency.source instanceof IDoubleInPin)) continue;
                    IDoubleInPin iDoubleInPin = (IDoubleInPin)dependency.source;
                    iDoubleInPin.updateInputUnit(unit);
                }
            }
            this.d_measurement = iQuantity;
            this.changedEvt(new Object[0]);
        }
    }

    public MeasureOutInfo getMsrInfo() {
        return (MeasureOutInfo)this.d_outPin;
    }

    @Override
    public MeasureOutInfo getMsrInfo(int n) {
        return this.getMsrInfo();
    }

    @Override
    public void takeDepSnapshot(DepList depList) {
        assert (this.d_measurement != null);
        QuantityUtil.takeDepSnapshot(depList, DLink.STRONG, this.d_measurement);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T t, Set<T> set) {
        QuantReplacer quantReplacer = new QuantReplacer();
        quantReplacer.removeInvalidReplacements(t, set, this.d_measurement);
    }

    @Override
    public Task taskReplaceDep(IPyroObject iPyroObject, IPyroObject iPyroObject2) {
        QuantReplacer quantReplacer = new QuantReplacer();
        return quantReplacer.taskReplaceDep(iPyroObject, iPyroObject2, this.d_measurement);
    }

    private class QuantReplacer
    extends QuantityReplacer {
        public QuantReplacer() {
            super((PyroMod)AMeasuringDevc.this.getDomain());
        }

        @Override
        protected Task taskReplaceQuant(IQuantity iQuantity, IQuantity iQuantity2) {
            assert (iQuantity2 != null);
            return new AReplaceRefTask<IQuantity>((Object)iQuantity, (Object)iQuantity2){

                @Override
                protected void set(IQuantity iQuantity) {
                    AMeasuringDevc.this.d_measurement = iQuantity;
                    AMeasuringDevc.this.changedEvt(new Object[0]);
                }
            };
        }
    }

    private static class QuantOutPin
    extends APyroObject
    implements IDoubleOutPin {
        static final long serialVersionUID = 1L;
        @SkipDep
        private ISignalSource d_source;

        public QuantOutPin(AMeasuringDevc aMeasuringDevc) {
            this.d_source = aMeasuringDevc;
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
        }

        @Override
        public ISignalSource getAttachedSource() {
            return this.d_source;
        }

        @Override
        public void setSource(ISignalSource iSignalSource) {
            assert (iSignalSource instanceof AMeasuringDevc);
            this.d_source = iSignalSource;
        }

        @Override
        public String getName() {
            return Intl.intl("OUT");
        }

        @Override
        public void setName(String string) {
        }

        @Override
        public int getUnitType() {
            return ((AMeasuringDevc)((AMeasuringDevc)this.d_source)).d_measurement.get().unitType;
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof QuantOutPin && this.getAttachedSource().equals(((QuantOutPin)object).getAttachedSource());
        }

        @Override
        public Object clone(ISignalSource iSignalSource) {
            QuantOutPin quantOutPin = (QuantOutPin)super.clone();
            assert (iSignalSource instanceof AMeasuringDevc);
            quantOutPin.d_source = iSignalSource;
            return quantOutPin;
        }

        public int hashCode() {
            return 160596815 + this.getAttachedSource().hashCode();
        }
    }
}

