/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.devices.hvac;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.vecmath.Point3d;
import org.jscience.physics.units.SI;
import pyrosim.legacy_2012_1.domain.devices.ADevice;
import pyrosim.legacy_2012_1.domain.hvac.HvacDuct;
import pyrosim.legacy_2012_1.domain.hvac.HvacNode;
import pyrosim.legacy_2012_1.domain.quantity.IQuantity;
import pyrosim.legacy_2012_1.domain.quantity.ObjectQuantity;
import pyrosim.legacy_2012_1.domain.quantity.Quantity;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.EmptyGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Point;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.DisplayGeom;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IDisplayProps;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitPoint3D;
import pyrosim.legacy_2012_1.util.Util;

public abstract class HvacDevice
extends ADevice {
    static final long serialVersionUID = 1L;
    private IQuantity d_msr;

    public HvacDevice(String string, IQuantity iQuantity) {
        super(string);
        this.d_msr = iQuantity;
    }

    public IQuantity getQuantity() {
        return this.d_msr;
    }

    public void setQuantity(IQuantity iQuantity) {
        this.d_msr = iQuantity;
    }

    @Override
    public void setGeom(IGeom iGeom, boolean bl) {
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps iDisplayProps) {
        return DisplayGeom.EMPTY;
    }

    private static Point3d getPointForNode(HvacNode hvacNode) {
        if (hvacNode != null && hvacNode.getProp("XYZ") != null) {
            return ((UnitPoint3D)hvacNode.getProp("XYZ")).getPoint3dValue(SI.METER);
        }
        return null;
    }

    public static boolean isValidQuantity(IQuantity iQuantity) {
        if (!(iQuantity instanceof ObjectQuantity)) {
            return false;
        }
        ObjectQuantity objectQuantity = (ObjectQuantity)iQuantity;
        for (Object t : objectQuantity.objects) {
            if (!(t instanceof HvacDuct) && !(t instanceof HvacNode)) continue;
            return true;
        }
        return false;
    }

    public static class NodeDevice
    extends HvacDevice {
        static final long serialVersionUID = 1L;

        public NodeDevice(String string, IQuantity iQuantity) {
            super(string, iQuantity);
        }

        @Override
        public IGeom getGeom() {
            ObjectQuantity objectQuantity = (ObjectQuantity)this.getQuantity();
            Collection<HvacNode> collection = Util.filter(Arrays.asList(objectQuantity.objects), HvacNode.class);
            if (collection.isEmpty()) {
                return EmptyGeom.INSTANCE;
            }
            if (objectQuantity.get() == Quantity.HVAC_NODE_PRESSURE_DIFFERENCE) {
                assert (collection.size() == 2);
            } else {
                HvacNode hvacNode = collection.iterator().next();
                Point3d point3d = HvacDevice.getPointForNode(hvacNode);
                if (point3d != null) {
                    return new Point(point3d);
                }
                System.err.printf("[x] Unable to find location for NodeDevice (%s)%n", hvacNode.getName());
            }
            return EmptyGeom.INSTANCE;
        }
    }

    public static class DuctDevice
    extends HvacDevice {
        static final long serialVersionUID = 1L;

        public DuctDevice(String string, IQuantity iQuantity) {
            super(string, iQuantity);
        }

        @Override
        public IGeom getGeom() {
            ObjectQuantity objectQuantity = (ObjectQuantity)this.getQuantity();
            Collection<HvacDuct> collection = Util.filter(Arrays.asList(objectQuantity.objects), HvacDuct.class);
            if (collection.isEmpty()) {
                return EmptyGeom.INSTANCE;
            }
            HvacDuct hvacDuct = collection.iterator().next();
            List list = (List)hvacDuct.getProp("NODE_ID");
            if (list == null || list.isEmpty() || list.get(0) == null) {
                System.err.printf("[x] Unable to find location for DUCT (%s)%n", hvacDuct.getName());
                return EmptyGeom.INSTANCE;
            }
            if (list.size() < 2) {
                Point3d point3d = HvacDevice.getPointForNode((HvacNode)list.get(0));
                if (point3d != null) {
                    return new Point(point3d);
                }
                System.err.printf("[xx] Unable to find location for DUCT (%s)%n", hvacDuct.getName());
            } else {
                Point3d point3d = HvacDevice.getPointForNode((HvacNode)list.get(0));
                Point3d point3d2 = HvacDevice.getPointForNode((HvacNode)list.get(1));
                if (point3d != null && point3d2 != null) {
                    Point3d point3d3 = Util3D.getMidPoint(point3d, point3d2);
                    return new Point(point3d3);
                }
                System.err.printf("[xxx] Unable to find location for DUCT (%s)%n", hvacDuct.getName());
            }
            return EmptyGeom.INSTANCE;
        }
    }
}

