/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.devices.detectors;

import org.jscience.physics.units.SI;
import pyrosim.legacy_2012_1.domain.NamedPyroObject;
import pyrosim.legacy_2012_1.domain.devices.IDeviceModel;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;
import pyrosim.legacy_2012_1.unitsystem.SIUS;

public class SprinklerLinkModel
extends NamedPyroObject
implements IDeviceModel {
    static final long serialVersionUID = 1L;
    private String d_fyi;
    private UnitDouble d_rti;
    private UnitDouble d_activationTemp;
    private UnitDouble d_initTemp;
    private UnitDouble d_cFactor;

    public SprinklerLinkModel(String string) {
        this(string, new UnitDouble(100.0, SIUS.getInstance().getRtiUnit()), null, new UnitDouble(74.0, SI.CELSIUS), SIUS.newud(0.0, 60));
    }

    public SprinklerLinkModel(String string, UnitDouble unitDouble, UnitDouble unitDouble2, UnitDouble unitDouble3, UnitDouble unitDouble4) {
        super(string);
        this.d_rti = unitDouble;
        this.d_activationTemp = unitDouble3;
        this.d_initTemp = unitDouble2;
        this.d_cFactor = unitDouble4;
    }

    public String getFYI() {
        return this.d_fyi == null ? "" : this.d_fyi;
    }

    public void setFYI(String string) {
        this.d_fyi = string;
        this.changedEvt(new Object[0]);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return super.equals(object) && this.propEquals(object);
    }

    public boolean propEquals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SprinklerLinkModel)) {
            return false;
        }
        SprinklerLinkModel sprinklerLinkModel = (SprinklerLinkModel)object;
        return this.d_cFactor.equals(sprinklerLinkModel.d_cFactor) && this.d_rti.equals(sprinklerLinkModel.d_rti) && this.d_activationTemp.equals(sprinklerLinkModel.d_activationTemp) && theUtil.equal(this.d_initTemp, sprinklerLinkModel.d_initTemp);
    }

    public int propHash() {
        return this.d_cFactor.hashCode() + this.d_rti.hashCode() + this.d_activationTemp.hashCode() + theUtil.hashCode(this.d_initTemp);
    }

    public UnitDouble getRti() {
        return this.d_rti;
    }

    public void setRti(UnitDouble unitDouble) {
        this.d_rti = unitDouble;
        this.changedEvt(new Object[0]);
    }

    public UnitDouble getInitialTemp() {
        return this.d_initTemp;
    }

    public void setInitialTemp(UnitDouble unitDouble) {
        this.d_initTemp = unitDouble;
        this.changedEvt(new Object[0]);
    }

    public UnitDouble getActivationTemp() {
        return this.d_activationTemp;
    }

    public void setActivationTemp(UnitDouble unitDouble) {
        this.d_activationTemp = unitDouble;
        this.changedEvt(new Object[0]);
    }

    public UnitDouble getCFactor() {
        return this.d_cFactor;
    }

    public void setCFactor(UnitDouble unitDouble) {
        this.d_cFactor = unitDouble;
        this.changedEvt(new Object[0]);
    }
}

