/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.devices.detectors;

import java.io.Serializable;
import java.util.Set;
import org.jscience.physics.units.SI;
import pyrosim.legacy_2012_1.domain.ExSpec;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.NamedPyroObject;
import pyrosim.legacy_2012_1.domain.dependencies.DLink;
import pyrosim.legacy_2012_1.domain.dependencies.DepList;
import pyrosim.legacy_2012_1.domain.dependencies.IDirectDependent;
import pyrosim.legacy_2012_1.domain.devices.IDeviceModel;
import pyrosim.legacy_2012_1.domain.tasks.AReplaceRefTask;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;
import pyrosim.legacy_2012_1.unitsystem.SIUS;
import pyrosim.legacy_2012_1.util.Util;

public class SmokeLinkModel
extends NamedPyroObject
implements IDeviceModel,
IDirectDependent {
    static final long serialVersionUID = 1L;
    private String d_fyi;
    private UnitDouble d_actObsc;
    private ExSpec d_smokeSpecies;
    private ISpec d_spec;

    public SmokeLinkModel(String string) {
        this(string, SIUS.newud(3.28, 31), null, new Cleary());
    }

    public SmokeLinkModel(String string, UnitDouble unitDouble, ExSpec exSpec, ISpec iSpec) {
        super(string);
        this.d_actObsc = unitDouble;
        this.d_smokeSpecies = exSpec;
        this.d_spec = iSpec;
    }

    public String getFYI() {
        return this.d_fyi == null ? "" : this.d_fyi;
    }

    public void setFYI(String string) {
        this.d_fyi = string;
        this.changedEvt(new Object[0]);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return super.equals(object) && this.propEquals(object);
    }

    public boolean propEquals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SmokeLinkModel)) {
            return false;
        }
        SmokeLinkModel smokeLinkModel = (SmokeLinkModel)object;
        return this.d_actObsc.equals(smokeLinkModel.d_actObsc) && theUtil.equal(this.d_smokeSpecies, smokeLinkModel.d_smokeSpecies) && this.d_spec.equals(smokeLinkModel.d_spec);
    }

    public int propHash() {
        return this.d_actObsc.hashCode() + theUtil.hashCode(this.d_smokeSpecies) + this.d_spec.hashCode();
    }

    @Override
    public void takeDepSnapshot(DepList depList) {
        depList.add(DLink.WEAK, (IPyroObject)this.d_smokeSpecies);
    }

    @Override
    public Task taskReplaceDep(IPyroObject iPyroObject, IPyroObject iPyroObject2) {
        if (iPyroObject instanceof ExSpec) {
            return new AReplaceRefTask<ExSpec>((Object)iPyroObject, (Object)iPyroObject2){

                @Override
                protected void set(ExSpec exSpec) {
                    SmokeLinkModel.this.setSmokeSpecies(exSpec);
                }
            };
        }
        return null;
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T t, Set<T> set) {
        if (t instanceof ExSpec) {
            Util.removeAllNotOfType(set, ExSpec.class);
        }
    }

    public UnitDouble getActivationObscuration() {
        return this.d_actObsc;
    }

    public void setActivationObscuration(UnitDouble unitDouble) {
        this.d_actObsc = unitDouble;
        this.changedEvt(new Object[0]);
    }

    public ExSpec getSmokeSpecies() {
        return this.d_smokeSpecies;
    }

    public void setSmokeSpecies(ExSpec exSpec) {
        this.d_smokeSpecies = exSpec;
        this.changedEvt(new Object[0]);
    }

    public ISpec getSpec() {
        return this.d_spec;
    }

    public void setSpec(ISpec iSpec) {
        this.d_spec = iSpec;
        this.changedEvt(new Object[0]);
    }

    public static class Cleary
    implements ISpec {
        static final long serialVersionUID = 1L;
        public final double d_cAlpha;
        public final double d_cBeta;
        public final double d_eAlpha;
        public final double d_eBeta;

        public Cleary() {
            this(1.8, 1.0, 0.0, 1.0);
        }

        public Cleary(double d, double d2, double d3, double d4) {
            this.d_cAlpha = d;
            this.d_cBeta = d2;
            this.d_eAlpha = d3;
            this.d_eBeta = d4;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Cleary)) {
                return false;
            }
            Cleary cleary = (Cleary)object;
            return this.d_cAlpha == cleary.d_cAlpha && this.d_cBeta == cleary.d_cBeta && this.d_eAlpha == cleary.d_eAlpha && this.d_eBeta == cleary.d_eBeta;
        }

        public int hashCode() {
            return theUtil.hashCode(this.d_cAlpha + this.d_cBeta + this.d_eAlpha + this.d_eBeta);
        }
    }

    public static class Heskestad
    implements ISpec {
        static final long serialVersionUID = 1L;
        public final UnitDouble d_length;

        public Heskestad() {
            this(new UnitDouble(1.8, SI.METER));
        }

        public Heskestad(UnitDouble unitDouble) {
            this.d_length = unitDouble;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Heskestad)) {
                return false;
            }
            Heskestad heskestad = (Heskestad)object;
            return this.d_length.equals(heskestad.d_length);
        }

        public int hashCode() {
            return -2092433667 + this.d_length.hashCode();
        }
    }

    public static interface ISpec
    extends Serializable {
    }
}

