/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.devices.detectors;

import java.awt.Color;
import java.io.Serializable;
import java.util.Set;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.dependencies.DLink;
import pyrosim.legacy_2012_1.domain.dependencies.DepList;
import pyrosim.legacy_2012_1.domain.dependencies.IDirectDependent;
import pyrosim.legacy_2012_1.domain.devices.detectors.APointDetector;
import pyrosim.legacy_2012_1.domain.devices.detectors.SmokeLinkModel;
import pyrosim.legacy_2012_1.domain.geom.FreePointLoc;
import pyrosim.legacy_2012_1.domain.tasks.AReplaceRefTask;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPrimProps;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;
import pyrosim.legacy_2012_1.util.Util;

public class SmokeDetector
extends APointDetector
implements IDirectDependent,
Serializable {
    static final long serialVersionUID = 1L;
    private SmokeLinkModel d_model;
    private static final IPrimProps s_primProps = new IPrimProps.Vertex(Color.GREEN, 10.0);

    public SmokeDetector(String string, SmokeLinkModel smokeLinkModel) {
        this(string, smokeLinkModel, new FreePointLoc());
    }

    public SmokeDetector(String string, SmokeLinkModel smokeLinkModel, FreePointLoc freePointLoc) {
        super(string, freePointLoc);
        this.d_model = smokeLinkModel;
    }

    @Override
    public boolean isMixFracOnly() {
        return true;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof SmokeDetector && super.equals(object) && this.d_model.equals(((SmokeDetector)object).d_model);
    }

    public SmokeLinkModel getModel() {
        return this.d_model;
    }

    public void setModel(SmokeLinkModel smokeLinkModel) {
        assert (this.d_model != null);
        this.d_model = smokeLinkModel;
        this.changedEvt(new Object[0]);
    }

    @Override
    public void takeDepSnapshot(DepList depList) {
        assert (this.d_model != null) : "A SmokeDetector must have a model";
        depList.add(DLink.STRONG, (IPyroObject)this.d_model);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T t, Set<T> set) {
        Util.removeAllNotOfType(set, SmokeLinkModel.class);
    }

    @Override
    public Task taskReplaceDep(IPyroObject iPyroObject, IPyroObject iPyroObject2) {
        if (iPyroObject == this.d_model) {
            assert (iPyroObject2 != null);
            return new AReplaceRefTask<SmokeLinkModel>((Object)iPyroObject, (Object)iPyroObject2){

                @Override
                public void set(SmokeLinkModel smokeLinkModel) {
                    SmokeDetector.this.setModel(smokeLinkModel);
                }
            };
        }
        return null;
    }

    @Override
    protected IPrimProps getPrimProps() {
        return s_primProps;
    }
}

