/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.devices.detectors;

import java.awt.Color;
import java.io.Serializable;
import java.util.Set;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.dependencies.DLink;
import pyrosim.legacy_2012_1.domain.dependencies.DepList;
import pyrosim.legacy_2012_1.domain.dependencies.IDirectDependent;
import pyrosim.legacy_2012_1.domain.devices.detectors.APointDetector;
import pyrosim.legacy_2012_1.domain.devices.detectors.HeatLinkModel;
import pyrosim.legacy_2012_1.domain.geom.FreePointLoc;
import pyrosim.legacy_2012_1.domain.tasks.AReplaceRefTask;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPrimProps;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;
import pyrosim.legacy_2012_1.util.Util;

public class HeatDetector
extends APointDetector
implements IDirectDependent,
Serializable {
    static final long serialVersionUID = 1L;
    private HeatLinkModel d_link;
    private static final IPrimProps s_primProps = new IPrimProps.Vertex(Color.RED, 10.0);

    public HeatDetector(String string, HeatLinkModel heatLinkModel, FreePointLoc freePointLoc) {
        super(string, freePointLoc);
        this.d_link = heatLinkModel;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof HeatDetector && super.equals(object) && this.d_link.equals(((HeatDetector)object).d_link);
    }

    public HeatLinkModel getModel() {
        return this.d_link;
    }

    public void setModel(HeatLinkModel heatLinkModel) {
        assert (heatLinkModel != null);
        this.d_link = heatLinkModel;
        this.changedEvt(new Object[0]);
    }

    @Override
    public void takeDepSnapshot(DepList depList) {
        assert (this.d_link != null) : "A Heat Detector must have a link";
        depList.add(DLink.STRONG, (IPyroObject)this.d_link);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T t, Set<T> set) {
        Util.removeAllNotOfType(set, HeatLinkModel.class);
    }

    @Override
    public Task taskReplaceDep(IPyroObject iPyroObject, IPyroObject iPyroObject2) {
        if (iPyroObject == this.getModel()) {
            assert (iPyroObject2 != null);
            return new AReplaceRefTask<HeatLinkModel>((Object)iPyroObject, (Object)iPyroObject2){

                @Override
                public void set(HeatLinkModel heatLinkModel) {
                    HeatDetector.this.setModel(heatLinkModel);
                }
            };
        }
        return null;
    }

    @Override
    protected IPrimProps getPrimProps() {
        return s_primProps;
    }
}

