/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.devices.aspiration;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.dependencies.DLink;
import pyrosim.legacy_2012_1.domain.dependencies.DepList;
import pyrosim.legacy_2012_1.domain.dependencies.IDirectDependent;
import pyrosim.legacy_2012_1.domain.devices.APointSrcDevc;
import pyrosim.legacy_2012_1.domain.devices.aspiration.AspiratorSampler;
import pyrosim.legacy_2012_1.domain.devices.measurers.IMeasurer;
import pyrosim.legacy_2012_1.domain.devices.measurers.MeasureOutInfo;
import pyrosim.legacy_2012_1.domain.geom.FreePointLoc;
import pyrosim.legacy_2012_1.domain.quantity.IQuantity;
import pyrosim.legacy_2012_1.domain.quantity.Quantity;
import pyrosim.legacy_2012_1.domain.signals.DoubleOutPin;
import pyrosim.legacy_2012_1.domain.signals.IDoubleOutPin;
import pyrosim.legacy_2012_1.domain.signals.ILogicOutPin;
import pyrosim.legacy_2012_1.domain.signals.IOutPin;
import pyrosim.legacy_2012_1.domain.signals.ISignalSource;
import pyrosim.legacy_2012_1.io.PyroSimObjectInputStream;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPrimProps;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.AUndoableTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;
import pyrosim.legacy_2012_1.unitsystem.SIUS;
import pyrosim.legacy_2012_1.util.Util;

public class Aspirator
extends APointSrcDevc
implements IMeasurer,
IDirectDependent {
    static final long serialVersionUID = 1L;
    private UnitDouble d_bypassFlowrate;
    private Map<AspiratorSampler, SamplerLine> d_samplerLines;
    private Object d_outPin;
    private static final IPrimProps s_primProps = new IPrimProps.Vertex(Color.DARK_GRAY, 10.0);

    public Aspirator(String string, FreePointLoc freePointLoc) {
        this(string, SIUS.newud(0.0, 38), freePointLoc);
    }

    public Aspirator(String string, UnitDouble unitDouble, FreePointLoc freePointLoc) {
        super(string, freePointLoc);
        this.d_bypassFlowrate = unitDouble;
        this.d_outPin = this.createOutInfo(new DoubleOutPin((ISignalSource)this, Quantity.ASPIRATION.unitType));
        this.d_samplerLines = new IdentityHashMap<AspiratorSampler, SamplerLine>();
    }

    @Override
    public boolean latches(ILogicOutPin iLogicOutPin) {
        return this.getMsrInfo().latches();
    }

    private MeasureOutInfo createOutInfo(IDoubleOutPin iDoubleOutPin) {
        return new MeasureOutInfo(this, true, iDoubleOutPin, Intl.intl("ALARM"));
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (objectInputStream instanceof PyroSimObjectInputStream && ((PyroSimObjectInputStream)objectInputStream).getVersion() < 29) {
            assert (this.d_outPin instanceof IDoubleOutPin);
            this.d_outPin = this.createOutInfo((IDoubleOutPin)this.d_outPin);
        }
    }

    @Override
    public Object clone() {
        Aspirator aspirator = (Aspirator)super.clone();
        aspirator.d_samplerLines = new IdentityHashMap<AspiratorSampler, SamplerLine>();
        aspirator.d_samplerLines.putAll(this.d_samplerLines);
        aspirator.d_outPin = ((MeasureOutInfo)this.d_outPin).clone(aspirator);
        return aspirator;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Aspirator)) {
            return false;
        }
        Aspirator aspirator = (Aspirator)object;
        return super.equals(object) && this.d_bypassFlowrate.equals(aspirator.d_bypassFlowrate) && this.d_outPin.equals(aspirator.d_outPin) && Util.identityMapsEqual(this.d_samplerLines, aspirator.d_samplerLines);
    }

    @Override
    public boolean isMixFracOnly() {
        return Quantity.ASPIRATION.mixFracOnly;
    }

    private static boolean sampLinesEqual(Collection<SamplerLine> collection, Collection<SamplerLine> collection2) {
        for (SamplerLine samplerLine : collection) {
            boolean bl = false;
            for (SamplerLine samplerLine2 : collection2) {
                if (!samplerLine.equals(samplerLine2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<? extends IOutPin> getOutputPins() {
        ArrayList<IOutPin> arrayList = new ArrayList<IOutPin>(2);
        ((MeasureOutInfo)this.d_outPin).getPins(arrayList);
        return arrayList;
    }

    @Override
    public int getNumMeasurements() {
        return 1;
    }

    public IQuantity getQuantity() {
        return Quantity.ASPIRATION.create();
    }

    @Override
    public IQuantity getQuantity(int n) {
        return this.getQuantity();
    }

    public MeasureOutInfo getMsrInfo() {
        return (MeasureOutInfo)this.d_outPin;
    }

    @Override
    public MeasureOutInfo getMsrInfo(int n) {
        return this.getMsrInfo();
    }

    public UnitDouble getBypassFlowrate() {
        return this.d_bypassFlowrate;
    }

    public void setBypassFlowrate(UnitDouble unitDouble) {
        this.d_bypassFlowrate = unitDouble;
        this.changedEvt(new Object[0]);
    }

    public void setSamplerLines(Collection<SamplerLine> collection) {
        this.pauseUpdates();
        this.d_samplerLines.clear();
        for (SamplerLine samplerLine : collection) {
            this.setSamplerLine(samplerLine);
        }
        this.changedEvt(new Object[0]);
        this.resumeUpdates();
    }

    public Collection<SamplerLine> getSamplerLines() {
        return Collections.unmodifiableCollection(this.d_samplerLines.values());
    }

    public void setSamplerLine(SamplerLine samplerLine) {
        this.d_samplerLines.put(samplerLine.d_sampler, samplerLine);
        this.changedEvt(new Object[0]);
    }

    public boolean removeSamplerLine(AspiratorSampler aspiratorSampler) {
        if (this.d_samplerLines.remove(aspiratorSampler) != null) {
            this.changedEvt(new Object[0]);
            return true;
        }
        return false;
    }

    public SamplerLine getSamplerLine(AspiratorSampler aspiratorSampler) {
        return this.d_samplerLines.get(aspiratorSampler);
    }

    public boolean isConnectedTo(AspiratorSampler aspiratorSampler) {
        return this.d_samplerLines.containsKey(aspiratorSampler);
    }

    @Override
    public void takeDepSnapshot(DepList depList) {
        depList.add(DLink.WEAK, this.d_samplerLines.keySet());
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T t, Set<T> set) {
        Util.removeAllNotOfType(set, AspiratorSampler.class);
    }

    @Override
    public Task taskReplaceDep(final IPyroObject iPyroObject, final IPyroObject iPyroObject2) {
        if (!(iPyroObject instanceof AspiratorSampler)) {
            return null;
        }
        return new AUndoableTask(){
            private SamplerLine d_oldLine;

            @Override
            public void undo() {
                Aspirator.this.d_samplerLines.put(this.d_oldLine.d_sampler, this.d_oldLine);
                Aspirator.this.changedEvt(new Object[0]);
            }

            @Override
            public void run() {
                this.d_oldLine = (SamplerLine)Aspirator.this.d_samplerLines.remove(iPyroObject);
                if (iPyroObject2 != null && !Aspirator.this.d_samplerLines.containsKey(iPyroObject2)) {
                    AspiratorSampler aspiratorSampler = (AspiratorSampler)iPyroObject2;
                    SamplerLine samplerLine = new SamplerLine(aspiratorSampler, this.d_oldLine.d_flowrate, this.d_oldLine.d_delay);
                    Aspirator.this.d_samplerLines.put(aspiratorSampler, samplerLine);
                }
                Aspirator.this.changedEvt(new Object[0]);
            }
        };
    }

    @Override
    protected IPrimProps getPrimProps() {
        return s_primProps;
    }

    public static class SamplerLine
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final AspiratorSampler d_sampler;
        public final UnitDouble d_flowrate;
        public final UnitDouble d_delay;

        public SamplerLine(AspiratorSampler aspiratorSampler) {
            this(aspiratorSampler, SIUS.newud(0.0, 38), new UnitDouble(0.0, SI.SECOND));
        }

        public SamplerLine(AspiratorSampler aspiratorSampler, UnitDouble unitDouble, UnitDouble unitDouble2) {
            this.d_sampler = aspiratorSampler;
            this.d_flowrate = unitDouble;
            this.d_delay = unitDouble2;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof SamplerLine)) {
                return false;
            }
            SamplerLine samplerLine = (SamplerLine)object;
            return this.d_sampler.equals(samplerLine.d_sampler) && this.d_flowrate.equals(samplerLine.d_flowrate) && this.d_delay.equals(samplerLine.d_delay);
        }

        public int hashCode() {
            return this.d_sampler.hashCode() + this.d_flowrate.hashCode() + this.d_delay.hashCode();
        }
    }
}

