/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.devices;

import java.io.Serializable;
import java.util.Set;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.dependencies.DepSnapshot;
import pyrosim.legacy_2012_1.domain.dependencies.Dependency;
import pyrosim.legacy_2012_1.domain.signals.IInPin;
import pyrosim.legacy_2012_1.domain.signals.ISignalSource;
import pyrosim.legacy_2012_1.domain.signals.LogicOutPin;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class AlarmInfo
implements Serializable {
    static final long serialVersionUID = 1L;
    public final UnitDouble setpoint;
    public final int tripFlags;

    public AlarmInfo(UnitDouble unitDouble) {
        this(unitDouble, 1);
    }

    public AlarmInfo(UnitDouble unitDouble, int n) {
        this.setpoint = unitDouble;
        this.tripFlags = n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AlarmInfo)) {
            return false;
        }
        AlarmInfo alarmInfo = (AlarmInfo)object;
        return this.setpoint.equals(alarmInfo.setpoint) && this.tripFlags == alarmInfo.tripFlags;
    }

    public int hashCode() {
        return 10462195 + this.tripFlags + this.setpoint.hashCode();
    }

    public static boolean checkAlarmChange(ISignalSource iSignalSource, AlarmInfo alarmInfo, AlarmInfo alarmInfo2, LogicOutPin logicOutPin) {
        if (theUtil.equal(alarmInfo, alarmInfo2)) {
            return false;
        }
        PyroMod pyroMod = (PyroMod)iSignalSource.getDomain();
        if (alarmInfo2 == null && pyroMod != null) {
            DepSnapshot depSnapshot = pyroMod.getDependencies(iSignalSource);
            Set<Dependency> set = depSnapshot.getDependents(iSignalSource);
            for (Dependency dependency : set) {
                if (!(dependency.source instanceof IInPin)) continue;
                IInPin iInPin = (IInPin)dependency.source;
                iInPin.disconnect(logicOutPin);
            }
        }
        return true;
    }
}

